package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class MatcherBuilder extends MatcherFluentImpl<MatcherBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<Matcher,MatcherBuilder> {

    MatcherFluent<?> fluent;
    Boolean validationEnabled;

    public MatcherBuilder() {
        this(true);
    }

    public MatcherBuilder(Boolean validationEnabled) {
        this(new Matcher(), validationEnabled);
    }

    public MatcherBuilder(MatcherFluent<?> fluent) {
        this(fluent, true);
    }

    public MatcherBuilder(MatcherFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new Matcher(), validationEnabled);
    }

    public MatcherBuilder(MatcherFluent<?> fluent,Matcher instance) {
        this(fluent, instance, true);
    }

    public MatcherBuilder(MatcherFluent<?> fluent,Matcher instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withExactMatch(instance.getExactMatch()); 
        fluent.withInvertMatch(instance.getInvertMatch()); 
        fluent.withName(instance.getName()); 
        fluent.withPrefixMatch(instance.getPrefixMatch()); 
        fluent.withPresentMatch(instance.getPresentMatch()); 
        fluent.withRangeMatch(instance.getRangeMatch()); 
        fluent.withRegexMatch(instance.getRegexMatch()); 
        fluent.withSafeRegexMatch(instance.getSafeRegexMatch()); 
        fluent.withSuffixMatch(instance.getSuffixMatch()); 
        this.validationEnabled = validationEnabled; 
    }

    public MatcherBuilder(Matcher instance) {
        this(instance,true);
    }

    public MatcherBuilder(Matcher instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withExactMatch(instance.getExactMatch()); 
        this.withInvertMatch(instance.getInvertMatch()); 
        this.withName(instance.getName()); 
        this.withPrefixMatch(instance.getPrefixMatch()); 
        this.withPresentMatch(instance.getPresentMatch()); 
        this.withRangeMatch(instance.getRangeMatch()); 
        this.withRegexMatch(instance.getRegexMatch()); 
        this.withSafeRegexMatch(instance.getSafeRegexMatch()); 
        this.withSuffixMatch(instance.getSuffixMatch()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.chaosmesh.v1alpha1.EditableMatcher build() {
        EditableMatcher buildable = new EditableMatcher(fluent.getExactMatch(),fluent.getInvertMatch(),fluent.getName(),fluent.getPrefixMatch(),fluent.getPresentMatch(),fluent.getRangeMatch(),fluent.getRegexMatch(),fluent.getSafeRegexMatch(),fluent.getSuffixMatch());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        MatcherBuilder that = (MatcherBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
