package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class JVMReturnSpecBuilder extends JVMReturnSpecFluentImpl<JVMReturnSpecBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<JVMReturnSpec,JVMReturnSpecBuilder> {

    JVMReturnSpecFluent<?> fluent;
    Boolean validationEnabled;

    public JVMReturnSpecBuilder() {
        this(true);
    }

    public JVMReturnSpecBuilder(Boolean validationEnabled) {
        this(new JVMReturnSpec(), validationEnabled);
    }

    public JVMReturnSpecBuilder(JVMReturnSpecFluent<?> fluent) {
        this(fluent, true);
    }

    public JVMReturnSpecBuilder(JVMReturnSpecFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new JVMReturnSpec(), validationEnabled);
    }

    public JVMReturnSpecBuilder(JVMReturnSpecFluent<?> fluent,JVMReturnSpec instance) {
        this(fluent, instance, true);
    }

    public JVMReturnSpecBuilder(JVMReturnSpecFluent<?> fluent,JVMReturnSpec instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withAfter(instance.getAfter()); 
        fluent.withClassname(instance.getClassname()); 
        fluent.withMethodname(instance.getMethodname()); 
        fluent.withValue(instance.getValue()); 
        this.validationEnabled = validationEnabled; 
    }

    public JVMReturnSpecBuilder(JVMReturnSpec instance) {
        this(instance,true);
    }

    public JVMReturnSpecBuilder(JVMReturnSpec instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withAfter(instance.getAfter()); 
        this.withClassname(instance.getClassname()); 
        this.withMethodname(instance.getMethodname()); 
        this.withValue(instance.getValue()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.chaosmesh.v1alpha1.EditableJVMReturnSpec build() {
        EditableJVMReturnSpec buildable = new EditableJVMReturnSpec(fluent.getAfter(),fluent.getClassname(),fluent.getMethodname(),fluent.getValue());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        JVMReturnSpecBuilder that = (JVMReturnSpecBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
