package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class JVMChaosStatusBuilder extends JVMChaosStatusFluentImpl<JVMChaosStatusBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<JVMChaosStatus,JVMChaosStatusBuilder> {

    JVMChaosStatusFluent<?> fluent;
    Boolean validationEnabled;

    public JVMChaosStatusBuilder() {
        this(true);
    }

    public JVMChaosStatusBuilder(Boolean validationEnabled) {
        this(new JVMChaosStatus(), validationEnabled);
    }

    public JVMChaosStatusBuilder(JVMChaosStatusFluent<?> fluent) {
        this(fluent, true);
    }

    public JVMChaosStatusBuilder(JVMChaosStatusFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new JVMChaosStatus(), validationEnabled);
    }

    public JVMChaosStatusBuilder(JVMChaosStatusFluent<?> fluent,JVMChaosStatus instance) {
        this(fluent, instance, true);
    }

    public JVMChaosStatusBuilder(JVMChaosStatusFluent<?> fluent,JVMChaosStatus instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withExperiment(instance.getExperiment()); 
        fluent.withFailedMessage(instance.getFailedMessage()); 
        fluent.withScheduler(instance.getScheduler()); 
        this.validationEnabled = validationEnabled; 
    }

    public JVMChaosStatusBuilder(JVMChaosStatus instance) {
        this(instance,true);
    }

    public JVMChaosStatusBuilder(JVMChaosStatus instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withExperiment(instance.getExperiment()); 
        this.withFailedMessage(instance.getFailedMessage()); 
        this.withScheduler(instance.getScheduler()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.chaosmesh.v1alpha1.EditableJVMChaosStatus build() {
        EditableJVMChaosStatus buildable = new EditableJVMChaosStatus(fluent.getExperiment(),fluent.getFailedMessage(),fluent.getScheduler());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        JVMChaosStatusBuilder that = (JVMChaosStatusBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
