package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class JVMChaosSpecBuilder extends JVMChaosSpecFluentImpl<JVMChaosSpecBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<JVMChaosSpec,JVMChaosSpecBuilder> {

    JVMChaosSpecFluent<?> fluent;
    Boolean validationEnabled;

    public JVMChaosSpecBuilder() {
        this(true);
    }

    public JVMChaosSpecBuilder(Boolean validationEnabled) {
        this(new JVMChaosSpec(), validationEnabled);
    }

    public JVMChaosSpecBuilder(JVMChaosSpecFluent<?> fluent) {
        this(fluent, true);
    }

    public JVMChaosSpecBuilder(JVMChaosSpecFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new JVMChaosSpec(), validationEnabled);
    }

    public JVMChaosSpecBuilder(JVMChaosSpecFluent<?> fluent,JVMChaosSpec instance) {
        this(fluent, instance, true);
    }

    public JVMChaosSpecBuilder(JVMChaosSpecFluent<?> fluent,JVMChaosSpec instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withAction(instance.getAction()); 
        fluent.withCfl(instance.getCfl()); 
        fluent.withDelay(instance.getDelay()); 
        fluent.withDelay4servlet(instance.getDelay4servlet()); 
        fluent.withDuration(instance.getDuration()); 
        fluent.withEffectcount(instance.getEffectcount()); 
        fluent.withEffectpercent(instance.getEffectpercent()); 
        fluent.withMode(instance.getMode()); 
        fluent.withOom(instance.getOom()); 
        fluent.withReturn(instance.getReturn()); 
        fluent.withScheduler(instance.getScheduler()); 
        fluent.withScript(instance.getScript()); 
        fluent.withSelector(instance.getSelector()); 
        fluent.withTce(instance.getTce()); 
        fluent.withTce4servlet(instance.getTce4servlet()); 
        fluent.withValue(instance.getValue()); 
        this.validationEnabled = validationEnabled; 
    }

    public JVMChaosSpecBuilder(JVMChaosSpec instance) {
        this(instance,true);
    }

    public JVMChaosSpecBuilder(JVMChaosSpec instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withAction(instance.getAction()); 
        this.withCfl(instance.getCfl()); 
        this.withDelay(instance.getDelay()); 
        this.withDelay4servlet(instance.getDelay4servlet()); 
        this.withDuration(instance.getDuration()); 
        this.withEffectcount(instance.getEffectcount()); 
        this.withEffectpercent(instance.getEffectpercent()); 
        this.withMode(instance.getMode()); 
        this.withOom(instance.getOom()); 
        this.withReturn(instance.getReturn()); 
        this.withScheduler(instance.getScheduler()); 
        this.withScript(instance.getScript()); 
        this.withSelector(instance.getSelector()); 
        this.withTce(instance.getTce()); 
        this.withTce4servlet(instance.getTce4servlet()); 
        this.withValue(instance.getValue()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.chaosmesh.v1alpha1.EditableJVMChaosSpec build() {
        EditableJVMChaosSpec buildable = new EditableJVMChaosSpec(fluent.getAction(),fluent.getCfl(),fluent.getDelay(),fluent.getDelay4servlet(),fluent.getDuration(),fluent.getEffectcount(),fluent.getEffectpercent(),fluent.getMode(),fluent.getOom(),fluent.getReturn(),fluent.getScheduler(),fluent.getScript(),fluent.getSelector(),fluent.getTce(),fluent.getTce4servlet(),fluent.getValue());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        JVMChaosSpecBuilder that = (JVMChaosSpecBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
