package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class HTTPChaosListBuilder extends HTTPChaosListFluentImpl<HTTPChaosListBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<HTTPChaosList,HTTPChaosListBuilder> {

    HTTPChaosListFluent<?> fluent;
    Boolean validationEnabled;

    public HTTPChaosListBuilder() {
        this(true);
    }

    public HTTPChaosListBuilder(Boolean validationEnabled) {
        this(new HTTPChaosList(), validationEnabled);
    }

    public HTTPChaosListBuilder(HTTPChaosListFluent<?> fluent) {
        this(fluent, true);
    }

    public HTTPChaosListBuilder(HTTPChaosListFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new HTTPChaosList(), validationEnabled);
    }

    public HTTPChaosListBuilder(HTTPChaosListFluent<?> fluent,HTTPChaosList instance) {
        this(fluent, instance, true);
    }

    public HTTPChaosListBuilder(HTTPChaosListFluent<?> fluent,HTTPChaosList instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion()); 
        fluent.withItems(instance.getItems()); 
        fluent.withKind(instance.getKind()); 
        fluent.withMetadata(instance.getMetadata()); 
        this.validationEnabled = validationEnabled; 
    }

    public HTTPChaosListBuilder(HTTPChaosList instance) {
        this(instance,true);
    }

    public HTTPChaosListBuilder(HTTPChaosList instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion()); 
        this.withItems(instance.getItems()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.chaosmesh.v1alpha1.EditableHTTPChaosList build() {
        EditableHTTPChaosList buildable = new EditableHTTPChaosList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        HTTPChaosListBuilder that = (HTTPChaosListBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
