package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.lang.Integer;
import java.lang.StringBuffer;
import java.util.Collection;
import java.lang.Object;

public class FailKernRequestFluentImpl<A extends FailKernRequestFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements FailKernRequestFluent<A> {

    private List<FrameBuilder> callchain;
    private Integer failtype;
    private List<String> headers;
    private Integer probability;
    private Integer times;

    public FailKernRequestFluentImpl() {
    }

    public FailKernRequestFluentImpl(FailKernRequest instance) {
        this.withCallchain(instance.getCallchain()); 
        this.withFailtype(instance.getFailtype()); 
        this.withHeaders(instance.getHeaders()); 
        this.withProbability(instance.getProbability()); 
        this.withTimes(instance.getTimes()); 
    }

    public A addToCallchain(int index,Frame item) {
        if (this.callchain == null) {this.callchain = new ArrayList<FrameBuilder>();}
        FrameBuilder builder = new FrameBuilder(item);_visitables.get("callchain").add(index >= 0 ? index : _visitables.get("callchain").size(), builder);this.callchain.add(index >= 0 ? index : callchain.size(), builder); return (A)this;
    }

    public A setToCallchain(int index,Frame item) {
        if (this.callchain == null) {this.callchain = new ArrayList<FrameBuilder>();}
        FrameBuilder builder = new FrameBuilder(item);
        if (index < 0 || index >= _visitables.get("callchain").size()) { _visitables.get("callchain").add(builder); } else { _visitables.get("callchain").set(index, builder);}
        if (index < 0 || index >= callchain.size()) { callchain.add(builder); } else { callchain.set(index, builder);}
         return (A)this;
    }

    public A addToCallchain(Frame... items) {
        if (this.callchain == null) {this.callchain = new ArrayList<FrameBuilder>();}
        for (Frame item : items) {FrameBuilder builder = new FrameBuilder(item);_visitables.get("callchain").add(builder);this.callchain.add(builder);} return (A)this;
    }

    public A addAllToCallchain(Collection<Frame> items) {
        if (this.callchain == null) {this.callchain = new ArrayList<FrameBuilder>();}
        for (Frame item : items) {FrameBuilder builder = new FrameBuilder(item);_visitables.get("callchain").add(builder);this.callchain.add(builder);} return (A)this;
    }

    public A removeFromCallchain(Frame... items) {
        for (Frame item : items) {FrameBuilder builder = new FrameBuilder(item);_visitables.get("callchain").remove(builder);if (this.callchain != null) {this.callchain.remove(builder);}} return (A)this;
    }

    public A removeAllFromCallchain(Collection<Frame> items) {
        for (Frame item : items) {FrameBuilder builder = new FrameBuilder(item);_visitables.get("callchain").remove(builder);if (this.callchain != null) {this.callchain.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromCallchain(Predicate<FrameBuilder> predicate) {
        if (callchain == null) return (A) this;
        final Iterator<FrameBuilder> each = callchain.iterator();
        final List visitables = _visitables.get("callchain");
        while (each.hasNext()) {
          FrameBuilder builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildCallchain instead.
 * @return The buildable object.
 */
@Deprecated public List<Frame> getCallchain() {
        return build(callchain);
    }

    public List<Frame> buildCallchain() {
        return build(callchain);
    }

    public Frame buildCallchain(int index) {
        return this.callchain.get(index).build();
    }

    public Frame buildFirstCallchain() {
        return this.callchain.get(0).build();
    }

    public Frame buildLastCallchain() {
        return this.callchain.get(callchain.size() - 1).build();
    }

    public Frame buildMatchingCallchain(Predicate<FrameBuilder> predicate) {
        for (FrameBuilder item: callchain) { if(predicate.test(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingCallchain(Predicate<FrameBuilder> predicate) {
        for (FrameBuilder item: callchain) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withCallchain(List<Frame> callchain) {
        if (this.callchain != null) { _visitables.get("callchain").removeAll(this.callchain);}
        if (callchain != null) {this.callchain = new ArrayList<FrameBuilder>(); for (Frame item : callchain){this.addToCallchain(item);}} else { this.callchain = null;} return (A) this;
    }

    public A withCallchain(Frame... callchain) {
        if (this.callchain != null) {this.callchain.clear();}
        if (callchain != null) {for (Frame item :callchain){ this.addToCallchain(item);}} return (A) this;
    }

    public Boolean hasCallchain() {
        return callchain != null && !callchain.isEmpty();
    }

    public A addNewCallchain(String funcname,String parameters,String predicate) {
        return (A)addToCallchain(new Frame(funcname, parameters, predicate));
    }

    public io.fabric8.chaosmesh.v1alpha1.FailKernRequestFluent.CallchainNested<A> addNewCallchain() {
        return new CallchainNestedImpl();
    }

    public io.fabric8.chaosmesh.v1alpha1.FailKernRequestFluent.CallchainNested<A> addNewCallchainLike(Frame item) {
        return new CallchainNestedImpl(-1, item);
    }

    public io.fabric8.chaosmesh.v1alpha1.FailKernRequestFluent.CallchainNested<A> setNewCallchainLike(int index,Frame item) {
        return new CallchainNestedImpl(index, item);
    }

    public io.fabric8.chaosmesh.v1alpha1.FailKernRequestFluent.CallchainNested<A> editCallchain(int index) {
        if (callchain.size() <= index) throw new RuntimeException("Can't edit callchain. Index exceeds size.");
        return setNewCallchainLike(index, buildCallchain(index));
    }

    public io.fabric8.chaosmesh.v1alpha1.FailKernRequestFluent.CallchainNested<A> editFirstCallchain() {
        if (callchain.size() == 0) throw new RuntimeException("Can't edit first callchain. The list is empty.");
        return setNewCallchainLike(0, buildCallchain(0));
    }

    public io.fabric8.chaosmesh.v1alpha1.FailKernRequestFluent.CallchainNested<A> editLastCallchain() {
        int index = callchain.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last callchain. The list is empty.");
        return setNewCallchainLike(index, buildCallchain(index));
    }

    public io.fabric8.chaosmesh.v1alpha1.FailKernRequestFluent.CallchainNested<A> editMatchingCallchain(Predicate<FrameBuilder> predicate) {
        int index = -1;
        for (int i=0;i<callchain.size();i++) { 
        if (predicate.test(callchain.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching callchain. No match found.");
        return setNewCallchainLike(index, buildCallchain(index));
    }

    public Integer getFailtype() {
        return this.failtype;
    }

    public A withFailtype(Integer failtype) {
        this.failtype=failtype; return (A) this;
    }

    public Boolean hasFailtype() {
        return this.failtype != null;
    }

    public A withNewFailtype(int arg0) {
        return (A)withFailtype(new Integer(arg0));
    }

    public A addToHeaders(int index,String item) {
        if (this.headers == null) {this.headers = new ArrayList<String>();}
        this.headers.add(index, item);
        return (A)this;
    }

    public A setToHeaders(int index,String item) {
        if (this.headers == null) {this.headers = new ArrayList<String>();}
        this.headers.set(index, item); return (A)this;
    }

    public A addToHeaders(String... items) {
        if (this.headers == null) {this.headers = new ArrayList<String>();}
        for (String item : items) {this.headers.add(item);} return (A)this;
    }

    public A addAllToHeaders(Collection<String> items) {
        if (this.headers == null) {this.headers = new ArrayList<String>();}
        for (String item : items) {this.headers.add(item);} return (A)this;
    }

    public A removeFromHeaders(String... items) {
        for (String item : items) {if (this.headers!= null){ this.headers.remove(item);}} return (A)this;
    }

    public A removeAllFromHeaders(Collection<String> items) {
        for (String item : items) {if (this.headers!= null){ this.headers.remove(item);}} return (A)this;
    }

    public List<String> getHeaders() {
        return this.headers;
    }

    public String getHeader(int index) {
        return this.headers.get(index);
    }

    public String getFirstHeader() {
        return this.headers.get(0);
    }

    public String getLastHeader() {
        return this.headers.get(headers.size() - 1);
    }

    public String getMatchingHeader(Predicate<String> predicate) {
        for (String item: headers) { if(predicate.test(item)){ return item;} } return null;
    }

    public Boolean hasMatchingHeader(Predicate<String> predicate) {
        for (String item: headers) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withHeaders(List<String> headers) {
        if (this.headers != null) { _visitables.get("headers").removeAll(this.headers);}
        if (headers != null) {this.headers = new ArrayList<String>(); for (String item : headers){this.addToHeaders(item);}} else { this.headers = null;} return (A) this;
    }

    public A withHeaders(String... headers) {
        if (this.headers != null) {this.headers.clear();}
        if (headers != null) {for (String item :headers){ this.addToHeaders(item);}} return (A) this;
    }

    public Boolean hasHeaders() {
        return headers != null && !headers.isEmpty();
    }

    public A addNewHeader(StringBuilder arg1) {
        return (A)addToHeaders(new String(arg1));
    }

    public A addNewHeader(int[] arg1,int arg2,int arg3) {
        return (A)addToHeaders(new String(arg1, arg2, arg3));
    }

    public A addNewHeader(char[] arg1) {
        return (A)addToHeaders(new String(arg1));
    }

    public A addNewHeader(StringBuffer arg1) {
        return (A)addToHeaders(new String(arg1));
    }

    public A addNewHeader(byte[] arg1,int arg2) {
        return (A)addToHeaders(new String(arg1, arg2));
    }

    public A addNewHeader(byte[] arg1) {
        return (A)addToHeaders(new String(arg1));
    }

    public A addNewHeader(char[] arg1,int arg2,int arg3) {
        return (A)addToHeaders(new String(arg1, arg2, arg3));
    }

    public A addNewHeader(byte[] arg1,int arg2,int arg3) {
        return (A)addToHeaders(new String(arg1, arg2, arg3));
    }

    public A addNewHeader(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)addToHeaders(new String(arg1, arg2, arg3, arg4));
    }

    public A addNewHeader(String arg1) {
        return (A)addToHeaders(new String(arg1));
    }

    public Integer getProbability() {
        return this.probability;
    }

    public A withProbability(Integer probability) {
        this.probability=probability; return (A) this;
    }

    public Boolean hasProbability() {
        return this.probability != null;
    }

    public A withNewProbability(int arg0) {
        return (A)withProbability(new Integer(arg0));
    }

    public Integer getTimes() {
        return this.times;
    }

    public A withTimes(Integer times) {
        this.times=times; return (A) this;
    }

    public Boolean hasTimes() {
        return this.times != null;
    }

    public A withNewTimes(int arg0) {
        return (A)withTimes(new Integer(arg0));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        FailKernRequestFluentImpl that = (FailKernRequestFluentImpl) o;
        if (callchain != null ? !callchain.equals(that.callchain) :that.callchain != null) return false;
        if (failtype != null ? !failtype.equals(that.failtype) :that.failtype != null) return false;
        if (headers != null ? !headers.equals(that.headers) :that.headers != null) return false;
        if (probability != null ? !probability.equals(that.probability) :that.probability != null) return false;
        if (times != null ? !times.equals(that.times) :that.times != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(callchain,  failtype,  headers,  probability,  times,  super.hashCode());
    }

    public class CallchainNestedImpl<N> extends FrameFluentImpl<io.fabric8.chaosmesh.v1alpha1.FailKernRequestFluent.CallchainNested<N>> implements io.fabric8.chaosmesh.v1alpha1.FailKernRequestFluent.CallchainNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final FrameBuilder builder;
        private final int index;

            CallchainNestedImpl(int index,Frame item) {
                this.index = index;
                this.builder = new FrameBuilder(this, item);
                        
            }

            CallchainNestedImpl() {
                this.index = -1;
                this.builder = new FrameBuilder(this);
                        
            }

            public N and() {
                return (N) FailKernRequestFluentImpl.this.setToCallchain(index,builder.build());
            }

            public N endCallchain() {
                return and();
            }
    }


}
