package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class DuplicateSpecBuilder extends DuplicateSpecFluentImpl<DuplicateSpecBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<DuplicateSpec,DuplicateSpecBuilder> {

    DuplicateSpecFluent<?> fluent;
    Boolean validationEnabled;

    public DuplicateSpecBuilder() {
        this(true);
    }

    public DuplicateSpecBuilder(Boolean validationEnabled) {
        this(new DuplicateSpec(), validationEnabled);
    }

    public DuplicateSpecBuilder(DuplicateSpecFluent<?> fluent) {
        this(fluent, true);
    }

    public DuplicateSpecBuilder(DuplicateSpecFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new DuplicateSpec(), validationEnabled);
    }

    public DuplicateSpecBuilder(DuplicateSpecFluent<?> fluent,DuplicateSpec instance) {
        this(fluent, instance, true);
    }

    public DuplicateSpecBuilder(DuplicateSpecFluent<?> fluent,DuplicateSpec instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withCorrelation(instance.getCorrelation()); 
        fluent.withDuplicate(instance.getDuplicate()); 
        this.validationEnabled = validationEnabled; 
    }

    public DuplicateSpecBuilder(DuplicateSpec instance) {
        this(instance,true);
    }

    public DuplicateSpecBuilder(DuplicateSpec instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withCorrelation(instance.getCorrelation()); 
        this.withDuplicate(instance.getDuplicate()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.chaosmesh.v1alpha1.EditableDuplicateSpec build() {
        EditableDuplicateSpec buildable = new EditableDuplicateSpec(fluent.getCorrelation(),fluent.getDuplicate());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        DuplicateSpecBuilder that = (DuplicateSpecBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
