package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class CorruptSpecBuilder extends CorruptSpecFluentImpl<CorruptSpecBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<CorruptSpec,CorruptSpecBuilder> {

    CorruptSpecFluent<?> fluent;
    Boolean validationEnabled;

    public CorruptSpecBuilder() {
        this(true);
    }

    public CorruptSpecBuilder(Boolean validationEnabled) {
        this(new CorruptSpec(), validationEnabled);
    }

    public CorruptSpecBuilder(CorruptSpecFluent<?> fluent) {
        this(fluent, true);
    }

    public CorruptSpecBuilder(CorruptSpecFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new CorruptSpec(), validationEnabled);
    }

    public CorruptSpecBuilder(CorruptSpecFluent<?> fluent,CorruptSpec instance) {
        this(fluent, instance, true);
    }

    public CorruptSpecBuilder(CorruptSpecFluent<?> fluent,CorruptSpec instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withCorrelation(instance.getCorrelation()); 
        fluent.withCorrupt(instance.getCorrupt()); 
        this.validationEnabled = validationEnabled; 
    }

    public CorruptSpecBuilder(CorruptSpec instance) {
        this(instance,true);
    }

    public CorruptSpecBuilder(CorruptSpec instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withCorrelation(instance.getCorrelation()); 
        this.withCorrupt(instance.getCorrupt()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.chaosmesh.v1alpha1.EditableCorruptSpec build() {
        EditableCorruptSpec buildable = new EditableCorruptSpec(fluent.getCorrelation(),fluent.getCorrupt());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        CorruptSpecBuilder that = (CorruptSpecBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
