package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class CPUStressorBuilder extends CPUStressorFluentImpl<CPUStressorBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<CPUStressor,CPUStressorBuilder> {

    CPUStressorFluent<?> fluent;
    Boolean validationEnabled;

    public CPUStressorBuilder() {
        this(true);
    }

    public CPUStressorBuilder(Boolean validationEnabled) {
        this(new CPUStressor(), validationEnabled);
    }

    public CPUStressorBuilder(CPUStressorFluent<?> fluent) {
        this(fluent, true);
    }

    public CPUStressorBuilder(CPUStressorFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new CPUStressor(), validationEnabled);
    }

    public CPUStressorBuilder(CPUStressorFluent<?> fluent,CPUStressor instance) {
        this(fluent, instance, true);
    }

    public CPUStressorBuilder(CPUStressorFluent<?> fluent,CPUStressor instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withLoad(instance.getLoad()); 
        fluent.withOptions(instance.getOptions()); 
        fluent.withWorkers(instance.getWorkers()); 
        this.validationEnabled = validationEnabled; 
    }

    public CPUStressorBuilder(CPUStressor instance) {
        this(instance,true);
    }

    public CPUStressorBuilder(CPUStressor instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withLoad(instance.getLoad()); 
        this.withOptions(instance.getOptions()); 
        this.withWorkers(instance.getWorkers()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.chaosmesh.v1alpha1.EditableCPUStressor build() {
        EditableCPUStressor buildable = new EditableCPUStressor(fluent.getLoad(),fluent.getOptions(),fluent.getWorkers());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        CPUStressorBuilder that = (CPUStressorBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
