package io.fabric8.chaosmesh.v1alpha1;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.lang.Integer;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Long;
import java.lang.Object;
import java.lang.Boolean;

public class AttrOverrideSpecFluentImpl<A extends AttrOverrideSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements AttrOverrideSpecFluent<A> {

    private TimespecBuilder atime;
    private Long blocks;
    private TimespecBuilder ctime;
    private Long gid;
    private Long ino;
    private String kind;
    private TimespecBuilder mtime;
    private Long nlink;
    private Integer perm;
    private Long rdev;
    private Long size;
    private Long uid;

    public AttrOverrideSpecFluentImpl() {
    }

    public AttrOverrideSpecFluentImpl(AttrOverrideSpec instance) {
        this.withAtime(instance.getAtime()); 
        this.withBlocks(instance.getBlocks()); 
        this.withCtime(instance.getCtime()); 
        this.withGid(instance.getGid()); 
        this.withIno(instance.getIno()); 
        this.withKind(instance.getKind()); 
        this.withMtime(instance.getMtime()); 
        this.withNlink(instance.getNlink()); 
        this.withPerm(instance.getPerm()); 
        this.withRdev(instance.getRdev()); 
        this.withSize(instance.getSize()); 
        this.withUid(instance.getUid()); 
    }

    
/**
 * This method has been deprecated, please use method buildAtime instead.
 * @return The buildable object.
 */
@Deprecated public Timespec getAtime() {
        return this.atime!=null?this.atime.build():null;
    }

    public Timespec buildAtime() {
        return this.atime!=null?this.atime.build():null;
    }

    public A withAtime(Timespec atime) {
        _visitables.get("atime").remove(this.atime);
        if (atime!=null){ this.atime= new TimespecBuilder(atime); _visitables.get("atime").add(this.atime);} return (A) this;
    }

    public Boolean hasAtime() {
        return this.atime != null;
    }

    public A withNewAtime(Long nsec,Long sec) {
        return (A)withAtime(new Timespec(nsec, sec));
    }

    public io.fabric8.chaosmesh.v1alpha1.AttrOverrideSpecFluent.AtimeNested<A> withNewAtime() {
        return new AtimeNestedImpl();
    }

    public io.fabric8.chaosmesh.v1alpha1.AttrOverrideSpecFluent.AtimeNested<A> withNewAtimeLike(Timespec item) {
        return new AtimeNestedImpl(item);
    }

    public io.fabric8.chaosmesh.v1alpha1.AttrOverrideSpecFluent.AtimeNested<A> editAtime() {
        return withNewAtimeLike(getAtime());
    }

    public io.fabric8.chaosmesh.v1alpha1.AttrOverrideSpecFluent.AtimeNested<A> editOrNewAtime() {
        return withNewAtimeLike(getAtime() != null ? getAtime(): new TimespecBuilder().build());
    }

    public io.fabric8.chaosmesh.v1alpha1.AttrOverrideSpecFluent.AtimeNested<A> editOrNewAtimeLike(Timespec item) {
        return withNewAtimeLike(getAtime() != null ? getAtime(): item);
    }

    public Long getBlocks() {
        return this.blocks;
    }

    public A withBlocks(Long blocks) {
        this.blocks=blocks; return (A) this;
    }

    public Boolean hasBlocks() {
        return this.blocks != null;
    }

    public A withNewBlocks(long arg1) {
        return (A)withBlocks(new Long(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildCtime instead.
 * @return The buildable object.
 */
@Deprecated public Timespec getCtime() {
        return this.ctime!=null?this.ctime.build():null;
    }

    public Timespec buildCtime() {
        return this.ctime!=null?this.ctime.build():null;
    }

    public A withCtime(Timespec ctime) {
        _visitables.get("ctime").remove(this.ctime);
        if (ctime!=null){ this.ctime= new TimespecBuilder(ctime); _visitables.get("ctime").add(this.ctime);} return (A) this;
    }

    public Boolean hasCtime() {
        return this.ctime != null;
    }

    public A withNewCtime(Long nsec,Long sec) {
        return (A)withCtime(new Timespec(nsec, sec));
    }

    public io.fabric8.chaosmesh.v1alpha1.AttrOverrideSpecFluent.CtimeNested<A> withNewCtime() {
        return new CtimeNestedImpl();
    }

    public io.fabric8.chaosmesh.v1alpha1.AttrOverrideSpecFluent.CtimeNested<A> withNewCtimeLike(Timespec item) {
        return new CtimeNestedImpl(item);
    }

    public io.fabric8.chaosmesh.v1alpha1.AttrOverrideSpecFluent.CtimeNested<A> editCtime() {
        return withNewCtimeLike(getCtime());
    }

    public io.fabric8.chaosmesh.v1alpha1.AttrOverrideSpecFluent.CtimeNested<A> editOrNewCtime() {
        return withNewCtimeLike(getCtime() != null ? getCtime(): new TimespecBuilder().build());
    }

    public io.fabric8.chaosmesh.v1alpha1.AttrOverrideSpecFluent.CtimeNested<A> editOrNewCtimeLike(Timespec item) {
        return withNewCtimeLike(getCtime() != null ? getCtime(): item);
    }

    public Long getGid() {
        return this.gid;
    }

    public A withGid(Long gid) {
        this.gid=gid; return (A) this;
    }

    public Boolean hasGid() {
        return this.gid != null;
    }

    public A withNewGid(long arg1) {
        return (A)withGid(new Long(arg1));
    }

    public Long getIno() {
        return this.ino;
    }

    public A withIno(Long ino) {
        this.ino=ino; return (A) this;
    }

    public Boolean hasIno() {
        return this.ino != null;
    }

    public A withNewIno(long arg1) {
        return (A)withIno(new Long(arg1));
    }

    public String getKind() {
        return this.kind;
    }

    public A withKind(String kind) {
        this.kind=kind; return (A) this;
    }

    public Boolean hasKind() {
        return this.kind != null;
    }

    public A withNewKind(StringBuilder arg1) {
        return (A)withKind(new String(arg1));
    }

    public A withNewKind(int[] arg1,int arg2,int arg3) {
        return (A)withKind(new String(arg1, arg2, arg3));
    }

    public A withNewKind(char[] arg1) {
        return (A)withKind(new String(arg1));
    }

    public A withNewKind(StringBuffer arg1) {
        return (A)withKind(new String(arg1));
    }

    public A withNewKind(byte[] arg1,int arg2) {
        return (A)withKind(new String(arg1, arg2));
    }

    public A withNewKind(byte[] arg1) {
        return (A)withKind(new String(arg1));
    }

    public A withNewKind(char[] arg1,int arg2,int arg3) {
        return (A)withKind(new String(arg1, arg2, arg3));
    }

    public A withNewKind(byte[] arg1,int arg2,int arg3) {
        return (A)withKind(new String(arg1, arg2, arg3));
    }

    public A withNewKind(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withKind(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewKind(String arg1) {
        return (A)withKind(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildMtime instead.
 * @return The buildable object.
 */
@Deprecated public Timespec getMtime() {
        return this.mtime!=null?this.mtime.build():null;
    }

    public Timespec buildMtime() {
        return this.mtime!=null?this.mtime.build():null;
    }

    public A withMtime(Timespec mtime) {
        _visitables.get("mtime").remove(this.mtime);
        if (mtime!=null){ this.mtime= new TimespecBuilder(mtime); _visitables.get("mtime").add(this.mtime);} return (A) this;
    }

    public Boolean hasMtime() {
        return this.mtime != null;
    }

    public A withNewMtime(Long nsec,Long sec) {
        return (A)withMtime(new Timespec(nsec, sec));
    }

    public io.fabric8.chaosmesh.v1alpha1.AttrOverrideSpecFluent.MtimeNested<A> withNewMtime() {
        return new MtimeNestedImpl();
    }

    public io.fabric8.chaosmesh.v1alpha1.AttrOverrideSpecFluent.MtimeNested<A> withNewMtimeLike(Timespec item) {
        return new MtimeNestedImpl(item);
    }

    public io.fabric8.chaosmesh.v1alpha1.AttrOverrideSpecFluent.MtimeNested<A> editMtime() {
        return withNewMtimeLike(getMtime());
    }

    public io.fabric8.chaosmesh.v1alpha1.AttrOverrideSpecFluent.MtimeNested<A> editOrNewMtime() {
        return withNewMtimeLike(getMtime() != null ? getMtime(): new TimespecBuilder().build());
    }

    public io.fabric8.chaosmesh.v1alpha1.AttrOverrideSpecFluent.MtimeNested<A> editOrNewMtimeLike(Timespec item) {
        return withNewMtimeLike(getMtime() != null ? getMtime(): item);
    }

    public Long getNlink() {
        return this.nlink;
    }

    public A withNlink(Long nlink) {
        this.nlink=nlink; return (A) this;
    }

    public Boolean hasNlink() {
        return this.nlink != null;
    }

    public A withNewNlink(long arg1) {
        return (A)withNlink(new Long(arg1));
    }

    public Integer getPerm() {
        return this.perm;
    }

    public A withPerm(Integer perm) {
        this.perm=perm; return (A) this;
    }

    public Boolean hasPerm() {
        return this.perm != null;
    }

    public A withNewPerm(int arg0) {
        return (A)withPerm(new Integer(arg0));
    }

    public Long getRdev() {
        return this.rdev;
    }

    public A withRdev(Long rdev) {
        this.rdev=rdev; return (A) this;
    }

    public Boolean hasRdev() {
        return this.rdev != null;
    }

    public A withNewRdev(long arg1) {
        return (A)withRdev(new Long(arg1));
    }

    public Long getSize() {
        return this.size;
    }

    public A withSize(Long size) {
        this.size=size; return (A) this;
    }

    public Boolean hasSize() {
        return this.size != null;
    }

    public A withNewSize(long arg1) {
        return (A)withSize(new Long(arg1));
    }

    public Long getUid() {
        return this.uid;
    }

    public A withUid(Long uid) {
        this.uid=uid; return (A) this;
    }

    public Boolean hasUid() {
        return this.uid != null;
    }

    public A withNewUid(long arg1) {
        return (A)withUid(new Long(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        AttrOverrideSpecFluentImpl that = (AttrOverrideSpecFluentImpl) o;
        if (atime != null ? !atime.equals(that.atime) :that.atime != null) return false;
        if (blocks != null ? !blocks.equals(that.blocks) :that.blocks != null) return false;
        if (ctime != null ? !ctime.equals(that.ctime) :that.ctime != null) return false;
        if (gid != null ? !gid.equals(that.gid) :that.gid != null) return false;
        if (ino != null ? !ino.equals(that.ino) :that.ino != null) return false;
        if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
        if (mtime != null ? !mtime.equals(that.mtime) :that.mtime != null) return false;
        if (nlink != null ? !nlink.equals(that.nlink) :that.nlink != null) return false;
        if (perm != null ? !perm.equals(that.perm) :that.perm != null) return false;
        if (rdev != null ? !rdev.equals(that.rdev) :that.rdev != null) return false;
        if (size != null ? !size.equals(that.size) :that.size != null) return false;
        if (uid != null ? !uid.equals(that.uid) :that.uid != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(atime,  blocks,  ctime,  gid,  ino,  kind,  mtime,  nlink,  perm,  rdev,  size,  uid,  super.hashCode());
    }

    public class AtimeNestedImpl<N> extends TimespecFluentImpl<io.fabric8.chaosmesh.v1alpha1.AttrOverrideSpecFluent.AtimeNested<N>> implements io.fabric8.chaosmesh.v1alpha1.AttrOverrideSpecFluent.AtimeNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final TimespecBuilder builder;

            AtimeNestedImpl(Timespec item) {
                this.builder = new TimespecBuilder(this, item);
                        
            }

            AtimeNestedImpl() {
                this.builder = new TimespecBuilder(this);
                        
            }

            public N and() {
                return (N) AttrOverrideSpecFluentImpl.this.withAtime(builder.build());
            }

            public N endAtime() {
                return and();
            }
    }


    public class CtimeNestedImpl<N> extends TimespecFluentImpl<io.fabric8.chaosmesh.v1alpha1.AttrOverrideSpecFluent.CtimeNested<N>> implements io.fabric8.chaosmesh.v1alpha1.AttrOverrideSpecFluent.CtimeNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final TimespecBuilder builder;

            CtimeNestedImpl(Timespec item) {
                this.builder = new TimespecBuilder(this, item);
                        
            }

            CtimeNestedImpl() {
                this.builder = new TimespecBuilder(this);
                        
            }

            public N and() {
                return (N) AttrOverrideSpecFluentImpl.this.withCtime(builder.build());
            }

            public N endCtime() {
                return and();
            }
    }


    public class MtimeNestedImpl<N> extends TimespecFluentImpl<io.fabric8.chaosmesh.v1alpha1.AttrOverrideSpecFluent.MtimeNested<N>> implements io.fabric8.chaosmesh.v1alpha1.AttrOverrideSpecFluent.MtimeNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final TimespecBuilder builder;

            MtimeNestedImpl(Timespec item) {
                this.builder = new TimespecBuilder(this, item);
                        
            }

            MtimeNestedImpl() {
                this.builder = new TimespecBuilder(this);
                        
            }

            public N and() {
                return (N) AttrOverrideSpecFluentImpl.this.withMtime(builder.build());
            }

            public N endMtime() {
                return and();
            }
    }


}
