package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class StressInstanceBuilder extends StressInstanceFluentImpl<StressInstanceBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<StressInstance,StressInstanceBuilder> {

    StressInstanceFluent<?> fluent;
    Boolean validationEnabled;

    public StressInstanceBuilder() {
        this(true);
    }

    public StressInstanceBuilder(Boolean validationEnabled) {
        this(new StressInstance(), validationEnabled);
    }

    public StressInstanceBuilder(StressInstanceFluent<?> fluent) {
        this(fluent, true);
    }

    public StressInstanceBuilder(StressInstanceFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new StressInstance(), validationEnabled);
    }

    public StressInstanceBuilder(StressInstanceFluent<?> fluent,StressInstance instance) {
        this(fluent, instance, true);
    }

    public StressInstanceBuilder(StressInstanceFluent<?> fluent,StressInstance instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withStartTime(instance.getStartTime()); 
        fluent.withUid(instance.getUid()); 
        this.validationEnabled = validationEnabled; 
    }

    public StressInstanceBuilder(StressInstance instance) {
        this(instance,true);
    }

    public StressInstanceBuilder(StressInstance instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withStartTime(instance.getStartTime()); 
        this.withUid(instance.getUid()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.chaosmesh.v1alpha1.EditableStressInstance build() {
        EditableStressInstance buildable = new EditableStressInstance(fluent.getStartTime(),fluent.getUid());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        StressInstanceBuilder that = (StressInstanceBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
