package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class StressChaosListBuilder extends StressChaosListFluentImpl<StressChaosListBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<StressChaosList,StressChaosListBuilder> {

    StressChaosListFluent<?> fluent;
    Boolean validationEnabled;

    public StressChaosListBuilder() {
        this(true);
    }

    public StressChaosListBuilder(Boolean validationEnabled) {
        this(new StressChaosList(), validationEnabled);
    }

    public StressChaosListBuilder(StressChaosListFluent<?> fluent) {
        this(fluent, true);
    }

    public StressChaosListBuilder(StressChaosListFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new StressChaosList(), validationEnabled);
    }

    public StressChaosListBuilder(StressChaosListFluent<?> fluent,StressChaosList instance) {
        this(fluent, instance, true);
    }

    public StressChaosListBuilder(StressChaosListFluent<?> fluent,StressChaosList instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion()); 
        fluent.withItems(instance.getItems()); 
        fluent.withKind(instance.getKind()); 
        fluent.withMetadata(instance.getMetadata()); 
        this.validationEnabled = validationEnabled; 
    }

    public StressChaosListBuilder(StressChaosList instance) {
        this(instance,true);
    }

    public StressChaosListBuilder(StressChaosList instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion()); 
        this.withItems(instance.getItems()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.chaosmesh.v1alpha1.EditableStressChaosList build() {
        EditableStressChaosList buildable = new EditableStressChaosList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        StressChaosListBuilder that = (StressChaosListBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
