package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class RawIPSetBuilder extends RawIPSetFluentImpl<RawIPSetBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<RawIPSet,RawIPSetBuilder> {

    RawIPSetFluent<?> fluent;
    Boolean validationEnabled;

    public RawIPSetBuilder() {
        this(true);
    }

    public RawIPSetBuilder(Boolean validationEnabled) {
        this(new RawIPSet(), validationEnabled);
    }

    public RawIPSetBuilder(RawIPSetFluent<?> fluent) {
        this(fluent, true);
    }

    public RawIPSetBuilder(RawIPSetFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new RawIPSet(), validationEnabled);
    }

    public RawIPSetBuilder(RawIPSetFluent<?> fluent,RawIPSet instance) {
        this(fluent, instance, true);
    }

    public RawIPSetBuilder(RawIPSetFluent<?> fluent,RawIPSet instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withCidrs(instance.getCidrs()); 
        fluent.withName(instance.getName()); 
        fluent.withSource(instance.getSource()); 
        this.validationEnabled = validationEnabled; 
    }

    public RawIPSetBuilder(RawIPSet instance) {
        this(instance,true);
    }

    public RawIPSetBuilder(RawIPSet instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withCidrs(instance.getCidrs()); 
        this.withName(instance.getName()); 
        this.withSource(instance.getSource()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.chaosmesh.v1alpha1.EditableRawIPSet build() {
        EditableRawIPSet buildable = new EditableRawIPSet(fluent.getCidrs(),fluent.getName(),fluent.getSource());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        RawIPSetBuilder that = (RawIPSetBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
