package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class PodNetworkChaosListBuilder extends PodNetworkChaosListFluentImpl<PodNetworkChaosListBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<PodNetworkChaosList,PodNetworkChaosListBuilder> {

    PodNetworkChaosListFluent<?> fluent;
    Boolean validationEnabled;

    public PodNetworkChaosListBuilder() {
        this(true);
    }

    public PodNetworkChaosListBuilder(Boolean validationEnabled) {
        this(new PodNetworkChaosList(), validationEnabled);
    }

    public PodNetworkChaosListBuilder(PodNetworkChaosListFluent<?> fluent) {
        this(fluent, true);
    }

    public PodNetworkChaosListBuilder(PodNetworkChaosListFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new PodNetworkChaosList(), validationEnabled);
    }

    public PodNetworkChaosListBuilder(PodNetworkChaosListFluent<?> fluent,PodNetworkChaosList instance) {
        this(fluent, instance, true);
    }

    public PodNetworkChaosListBuilder(PodNetworkChaosListFluent<?> fluent,PodNetworkChaosList instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion()); 
        fluent.withItems(instance.getItems()); 
        fluent.withKind(instance.getKind()); 
        fluent.withMetadata(instance.getMetadata()); 
        this.validationEnabled = validationEnabled; 
    }

    public PodNetworkChaosListBuilder(PodNetworkChaosList instance) {
        this(instance,true);
    }

    public PodNetworkChaosListBuilder(PodNetworkChaosList instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion()); 
        this.withItems(instance.getItems()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.chaosmesh.v1alpha1.EditablePodNetworkChaosList build() {
        EditablePodNetworkChaosList buildable = new EditablePodNetworkChaosList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        PodNetworkChaosListBuilder that = (PodNetworkChaosListBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
