package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class NetworkChaosStatusBuilder extends NetworkChaosStatusFluentImpl<NetworkChaosStatusBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<NetworkChaosStatus,NetworkChaosStatusBuilder> {

    NetworkChaosStatusFluent<?> fluent;
    Boolean validationEnabled;

    public NetworkChaosStatusBuilder() {
        this(true);
    }

    public NetworkChaosStatusBuilder(Boolean validationEnabled) {
        this(new NetworkChaosStatus(), validationEnabled);
    }

    public NetworkChaosStatusBuilder(NetworkChaosStatusFluent<?> fluent) {
        this(fluent, true);
    }

    public NetworkChaosStatusBuilder(NetworkChaosStatusFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new NetworkChaosStatus(), validationEnabled);
    }

    public NetworkChaosStatusBuilder(NetworkChaosStatusFluent<?> fluent,NetworkChaosStatus instance) {
        this(fluent, instance, true);
    }

    public NetworkChaosStatusBuilder(NetworkChaosStatusFluent<?> fluent,NetworkChaosStatus instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withExperiment(instance.getExperiment()); 
        fluent.withFailedMessage(instance.getFailedMessage()); 
        fluent.withScheduler(instance.getScheduler()); 
        this.validationEnabled = validationEnabled; 
    }

    public NetworkChaosStatusBuilder(NetworkChaosStatus instance) {
        this(instance,true);
    }

    public NetworkChaosStatusBuilder(NetworkChaosStatus instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withExperiment(instance.getExperiment()); 
        this.withFailedMessage(instance.getFailedMessage()); 
        this.withScheduler(instance.getScheduler()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.chaosmesh.v1alpha1.EditableNetworkChaosStatus build() {
        EditableNetworkChaosStatus buildable = new EditableNetworkChaosStatus(fluent.getExperiment(),fluent.getFailedMessage(),fluent.getScheduler());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        NetworkChaosStatusBuilder that = (NetworkChaosStatusBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
