package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class KernelChaosListBuilder extends KernelChaosListFluentImpl<KernelChaosListBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<KernelChaosList,KernelChaosListBuilder> {

    KernelChaosListFluent<?> fluent;
    Boolean validationEnabled;

    public KernelChaosListBuilder() {
        this(true);
    }

    public KernelChaosListBuilder(Boolean validationEnabled) {
        this(new KernelChaosList(), validationEnabled);
    }

    public KernelChaosListBuilder(KernelChaosListFluent<?> fluent) {
        this(fluent, true);
    }

    public KernelChaosListBuilder(KernelChaosListFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new KernelChaosList(), validationEnabled);
    }

    public KernelChaosListBuilder(KernelChaosListFluent<?> fluent,KernelChaosList instance) {
        this(fluent, instance, true);
    }

    public KernelChaosListBuilder(KernelChaosListFluent<?> fluent,KernelChaosList instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion()); 
        fluent.withItems(instance.getItems()); 
        fluent.withKind(instance.getKind()); 
        fluent.withMetadata(instance.getMetadata()); 
        this.validationEnabled = validationEnabled; 
    }

    public KernelChaosListBuilder(KernelChaosList instance) {
        this(instance,true);
    }

    public KernelChaosListBuilder(KernelChaosList instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion()); 
        this.withItems(instance.getItems()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.chaosmesh.v1alpha1.EditableKernelChaosList build() {
        EditableKernelChaosList buildable = new EditableKernelChaosList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        KernelChaosListBuilder that = (KernelChaosListBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
