package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class JVMChaosListBuilder extends JVMChaosListFluentImpl<JVMChaosListBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<JVMChaosList,JVMChaosListBuilder> {

    JVMChaosListFluent<?> fluent;
    Boolean validationEnabled;

    public JVMChaosListBuilder() {
        this(true);
    }

    public JVMChaosListBuilder(Boolean validationEnabled) {
        this(new JVMChaosList(), validationEnabled);
    }

    public JVMChaosListBuilder(JVMChaosListFluent<?> fluent) {
        this(fluent, true);
    }

    public JVMChaosListBuilder(JVMChaosListFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new JVMChaosList(), validationEnabled);
    }

    public JVMChaosListBuilder(JVMChaosListFluent<?> fluent,JVMChaosList instance) {
        this(fluent, instance, true);
    }

    public JVMChaosListBuilder(JVMChaosListFluent<?> fluent,JVMChaosList instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion()); 
        fluent.withItems(instance.getItems()); 
        fluent.withKind(instance.getKind()); 
        fluent.withMetadata(instance.getMetadata()); 
        this.validationEnabled = validationEnabled; 
    }

    public JVMChaosListBuilder(JVMChaosList instance) {
        this(instance,true);
    }

    public JVMChaosListBuilder(JVMChaosList instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion()); 
        this.withItems(instance.getItems()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.chaosmesh.v1alpha1.EditableJVMChaosList build() {
        EditableJVMChaosList buildable = new EditableJVMChaosList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        JVMChaosListBuilder that = (JVMChaosListBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
