package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class IoFaultBuilder extends IoFaultFluentImpl<IoFaultBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<IoFault,IoFaultBuilder> {

    IoFaultFluent<?> fluent;
    Boolean validationEnabled;

    public IoFaultBuilder() {
        this(true);
    }

    public IoFaultBuilder(Boolean validationEnabled) {
        this(new IoFault(), validationEnabled);
    }

    public IoFaultBuilder(IoFaultFluent<?> fluent) {
        this(fluent, true);
    }

    public IoFaultBuilder(IoFaultFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new IoFault(), validationEnabled);
    }

    public IoFaultBuilder(IoFaultFluent<?> fluent,IoFault instance) {
        this(fluent, instance, true);
    }

    public IoFaultBuilder(IoFaultFluent<?> fluent,IoFault instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withErrno(instance.getErrno()); 
        fluent.withWeight(instance.getWeight()); 
        this.validationEnabled = validationEnabled; 
    }

    public IoFaultBuilder(IoFault instance) {
        this(instance,true);
    }

    public IoFaultBuilder(IoFault instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withErrno(instance.getErrno()); 
        this.withWeight(instance.getWeight()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.chaosmesh.v1alpha1.EditableIoFault build() {
        EditableIoFault buildable = new EditableIoFault(fluent.getErrno(),fluent.getWeight());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        IoFaultBuilder that = (IoFaultBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
