package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class HTTPChaosBuilder extends HTTPChaosFluentImpl<HTTPChaosBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<HTTPChaos,HTTPChaosBuilder> {

    HTTPChaosFluent<?> fluent;
    Boolean validationEnabled;

    public HTTPChaosBuilder() {
        this(true);
    }

    public HTTPChaosBuilder(Boolean validationEnabled) {
        this(new HTTPChaos(), validationEnabled);
    }

    public HTTPChaosBuilder(HTTPChaosFluent<?> fluent) {
        this(fluent, true);
    }

    public HTTPChaosBuilder(HTTPChaosFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new HTTPChaos(), validationEnabled);
    }

    public HTTPChaosBuilder(HTTPChaosFluent<?> fluent,HTTPChaos instance) {
        this(fluent, instance, true);
    }

    public HTTPChaosBuilder(HTTPChaosFluent<?> fluent,HTTPChaos instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion()); 
        fluent.withKind(instance.getKind()); 
        fluent.withMetadata(instance.getMetadata()); 
        fluent.withSpec(instance.getSpec()); 
        fluent.withStatus(instance.getStatus()); 
        this.validationEnabled = validationEnabled; 
    }

    public HTTPChaosBuilder(HTTPChaos instance) {
        this(instance,true);
    }

    public HTTPChaosBuilder(HTTPChaos instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.withSpec(instance.getSpec()); 
        this.withStatus(instance.getStatus()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.chaosmesh.v1alpha1.EditableHTTPChaos build() {
        EditableHTTPChaos buildable = new EditableHTTPChaos(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        HTTPChaosBuilder that = (HTTPChaosBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
