package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class FrameBuilder extends FrameFluentImpl<FrameBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<Frame,FrameBuilder> {

    FrameFluent<?> fluent;
    Boolean validationEnabled;

    public FrameBuilder() {
        this(true);
    }

    public FrameBuilder(Boolean validationEnabled) {
        this(new Frame(), validationEnabled);
    }

    public FrameBuilder(FrameFluent<?> fluent) {
        this(fluent, true);
    }

    public FrameBuilder(FrameFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new Frame(), validationEnabled);
    }

    public FrameBuilder(FrameFluent<?> fluent,Frame instance) {
        this(fluent, instance, true);
    }

    public FrameBuilder(FrameFluent<?> fluent,Frame instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withFuncname(instance.getFuncname()); 
        fluent.withParameters(instance.getParameters()); 
        fluent.withPredicate(instance.getPredicate()); 
        this.validationEnabled = validationEnabled; 
    }

    public FrameBuilder(Frame instance) {
        this(instance,true);
    }

    public FrameBuilder(Frame instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withFuncname(instance.getFuncname()); 
        this.withParameters(instance.getParameters()); 
        this.withPredicate(instance.getPredicate()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.chaosmesh.v1alpha1.EditableFrame build() {
        EditableFrame buildable = new EditableFrame(fluent.getFuncname(),fluent.getParameters(),fluent.getPredicate());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        FrameBuilder that = (FrameBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
