package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class DNSChaosListBuilder extends DNSChaosListFluentImpl<DNSChaosListBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<DNSChaosList,DNSChaosListBuilder> {

    DNSChaosListFluent<?> fluent;
    Boolean validationEnabled;

    public DNSChaosListBuilder() {
        this(true);
    }

    public DNSChaosListBuilder(Boolean validationEnabled) {
        this(new DNSChaosList(), validationEnabled);
    }

    public DNSChaosListBuilder(DNSChaosListFluent<?> fluent) {
        this(fluent, true);
    }

    public DNSChaosListBuilder(DNSChaosListFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new DNSChaosList(), validationEnabled);
    }

    public DNSChaosListBuilder(DNSChaosListFluent<?> fluent,DNSChaosList instance) {
        this(fluent, instance, true);
    }

    public DNSChaosListBuilder(DNSChaosListFluent<?> fluent,DNSChaosList instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion()); 
        fluent.withItems(instance.getItems()); 
        fluent.withKind(instance.getKind()); 
        fluent.withMetadata(instance.getMetadata()); 
        this.validationEnabled = validationEnabled; 
    }

    public DNSChaosListBuilder(DNSChaosList instance) {
        this(instance,true);
    }

    public DNSChaosListBuilder(DNSChaosList instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion()); 
        this.withItems(instance.getItems()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.chaosmesh.v1alpha1.EditableDNSChaosList build() {
        EditableDNSChaosList buildable = new EditableDNSChaosList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        DNSChaosListBuilder that = (DNSChaosListBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
