package io.fabric8.chaosmesh.v1alpha1;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import java.lang.StringBuffer;
import java.lang.Object;

public class DNSChaosFluentImpl<A extends DNSChaosFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements DNSChaosFluent<A> {

    private String apiVersion;
    private String kind;
    private ObjectMetaBuilder metadata;
    private DNSChaosSpecBuilder spec;
    private DNSChaosStatusBuilder status;

    public DNSChaosFluentImpl() {
    }

    public DNSChaosFluentImpl(DNSChaos instance) {
        this.withApiVersion(instance.getApiVersion()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.withSpec(instance.getSpec()); 
        this.withStatus(instance.getStatus()); 
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public A withApiVersion(String apiVersion) {
        this.apiVersion=apiVersion; return (A) this;
    }

    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    public A withNewApiVersion(StringBuilder arg1) {
        return (A)withApiVersion(new String(arg1));
    }

    public A withNewApiVersion(int[] arg1,int arg2,int arg3) {
        return (A)withApiVersion(new String(arg1, arg2, arg3));
    }

    public A withNewApiVersion(char[] arg1) {
        return (A)withApiVersion(new String(arg1));
    }

    public A withNewApiVersion(StringBuffer arg1) {
        return (A)withApiVersion(new String(arg1));
    }

    public A withNewApiVersion(byte[] arg1,int arg2) {
        return (A)withApiVersion(new String(arg1, arg2));
    }

    public A withNewApiVersion(byte[] arg1) {
        return (A)withApiVersion(new String(arg1));
    }

    public A withNewApiVersion(char[] arg1,int arg2,int arg3) {
        return (A)withApiVersion(new String(arg1, arg2, arg3));
    }

    public A withNewApiVersion(byte[] arg1,int arg2,int arg3) {
        return (A)withApiVersion(new String(arg1, arg2, arg3));
    }

    public A withNewApiVersion(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withApiVersion(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewApiVersion(String arg1) {
        return (A)withApiVersion(new String(arg1));
    }

    public String getKind() {
        return this.kind;
    }

    public A withKind(String kind) {
        this.kind=kind; return (A) this;
    }

    public Boolean hasKind() {
        return this.kind != null;
    }

    public A withNewKind(StringBuilder arg1) {
        return (A)withKind(new String(arg1));
    }

    public A withNewKind(int[] arg1,int arg2,int arg3) {
        return (A)withKind(new String(arg1, arg2, arg3));
    }

    public A withNewKind(char[] arg1) {
        return (A)withKind(new String(arg1));
    }

    public A withNewKind(StringBuffer arg1) {
        return (A)withKind(new String(arg1));
    }

    public A withNewKind(byte[] arg1,int arg2) {
        return (A)withKind(new String(arg1, arg2));
    }

    public A withNewKind(byte[] arg1) {
        return (A)withKind(new String(arg1));
    }

    public A withNewKind(char[] arg1,int arg2,int arg3) {
        return (A)withKind(new String(arg1, arg2, arg3));
    }

    public A withNewKind(byte[] arg1,int arg2,int arg3) {
        return (A)withKind(new String(arg1, arg2, arg3));
    }

    public A withNewKind(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withKind(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewKind(String arg1) {
        return (A)withKind(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildMetadata instead.
 * @return The buildable object.
 */
@Deprecated public ObjectMeta getMetadata() {
        return this.metadata!=null?this.metadata.build():null;
    }

    public ObjectMeta buildMetadata() {
        return this.metadata!=null?this.metadata.build():null;
    }

    public A withMetadata(ObjectMeta metadata) {
        _visitables.get("metadata").remove(this.metadata);
        if (metadata!=null){ this.metadata= new ObjectMetaBuilder(metadata); _visitables.get("metadata").add(this.metadata);} return (A) this;
    }

    public Boolean hasMetadata() {
        return this.metadata != null;
    }

    public io.fabric8.chaosmesh.v1alpha1.DNSChaosFluent.MetadataNested<A> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    public io.fabric8.chaosmesh.v1alpha1.DNSChaosFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNestedImpl(item);
    }

    public io.fabric8.chaosmesh.v1alpha1.DNSChaosFluent.MetadataNested<A> editMetadata() {
        return withNewMetadataLike(getMetadata());
    }

    public io.fabric8.chaosmesh.v1alpha1.DNSChaosFluent.MetadataNested<A> editOrNewMetadata() {
        return withNewMetadataLike(getMetadata() != null ? getMetadata(): new ObjectMetaBuilder().build());
    }

    public io.fabric8.chaosmesh.v1alpha1.DNSChaosFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
        return withNewMetadataLike(getMetadata() != null ? getMetadata(): item);
    }

    
/**
 * This method has been deprecated, please use method buildSpec instead.
 * @return The buildable object.
 */
@Deprecated public DNSChaosSpec getSpec() {
        return this.spec!=null?this.spec.build():null;
    }

    public DNSChaosSpec buildSpec() {
        return this.spec!=null?this.spec.build():null;
    }

    public A withSpec(DNSChaosSpec spec) {
        _visitables.get("spec").remove(this.spec);
        if (spec!=null){ this.spec= new DNSChaosSpecBuilder(spec); _visitables.get("spec").add(this.spec);} return (A) this;
    }

    public Boolean hasSpec() {
        return this.spec != null;
    }

    public io.fabric8.chaosmesh.v1alpha1.DNSChaosFluent.SpecNested<A> withNewSpec() {
        return new SpecNestedImpl();
    }

    public io.fabric8.chaosmesh.v1alpha1.DNSChaosFluent.SpecNested<A> withNewSpecLike(DNSChaosSpec item) {
        return new SpecNestedImpl(item);
    }

    public io.fabric8.chaosmesh.v1alpha1.DNSChaosFluent.SpecNested<A> editSpec() {
        return withNewSpecLike(getSpec());
    }

    public io.fabric8.chaosmesh.v1alpha1.DNSChaosFluent.SpecNested<A> editOrNewSpec() {
        return withNewSpecLike(getSpec() != null ? getSpec(): new DNSChaosSpecBuilder().build());
    }

    public io.fabric8.chaosmesh.v1alpha1.DNSChaosFluent.SpecNested<A> editOrNewSpecLike(DNSChaosSpec item) {
        return withNewSpecLike(getSpec() != null ? getSpec(): item);
    }

    
/**
 * This method has been deprecated, please use method buildStatus instead.
 * @return The buildable object.
 */
@Deprecated public DNSChaosStatus getStatus() {
        return this.status!=null?this.status.build():null;
    }

    public DNSChaosStatus buildStatus() {
        return this.status!=null?this.status.build():null;
    }

    public A withStatus(DNSChaosStatus status) {
        _visitables.get("status").remove(this.status);
        if (status!=null){ this.status= new DNSChaosStatusBuilder(status); _visitables.get("status").add(this.status);} return (A) this;
    }

    public Boolean hasStatus() {
        return this.status != null;
    }

    public io.fabric8.chaosmesh.v1alpha1.DNSChaosFluent.StatusNested<A> withNewStatus() {
        return new StatusNestedImpl();
    }

    public io.fabric8.chaosmesh.v1alpha1.DNSChaosFluent.StatusNested<A> withNewStatusLike(DNSChaosStatus item) {
        return new StatusNestedImpl(item);
    }

    public io.fabric8.chaosmesh.v1alpha1.DNSChaosFluent.StatusNested<A> editStatus() {
        return withNewStatusLike(getStatus());
    }

    public io.fabric8.chaosmesh.v1alpha1.DNSChaosFluent.StatusNested<A> editOrNewStatus() {
        return withNewStatusLike(getStatus() != null ? getStatus(): new DNSChaosStatusBuilder().build());
    }

    public io.fabric8.chaosmesh.v1alpha1.DNSChaosFluent.StatusNested<A> editOrNewStatusLike(DNSChaosStatus item) {
        return withNewStatusLike(getStatus() != null ? getStatus(): item);
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        DNSChaosFluentImpl that = (DNSChaosFluentImpl) o;
        if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
        if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
        if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
        if (spec != null ? !spec.equals(that.spec) :that.spec != null) return false;
        if (status != null ? !status.equals(that.status) :that.status != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(apiVersion,  kind,  metadata,  spec,  status,  super.hashCode());
    }

    public class MetadataNestedImpl<N> extends ObjectMetaFluentImpl<io.fabric8.chaosmesh.v1alpha1.DNSChaosFluent.MetadataNested<N>> implements io.fabric8.chaosmesh.v1alpha1.DNSChaosFluent.MetadataNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ObjectMetaBuilder builder;

            MetadataNestedImpl(ObjectMeta item) {
                this.builder = new ObjectMetaBuilder(this, item);
                        
            }

            MetadataNestedImpl() {
                this.builder = new ObjectMetaBuilder(this);
                        
            }

            public N and() {
                return (N) DNSChaosFluentImpl.this.withMetadata(builder.build());
            }

            public N endMetadata() {
                return and();
            }
    }


    public class SpecNestedImpl<N> extends DNSChaosSpecFluentImpl<io.fabric8.chaosmesh.v1alpha1.DNSChaosFluent.SpecNested<N>> implements io.fabric8.chaosmesh.v1alpha1.DNSChaosFluent.SpecNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final DNSChaosSpecBuilder builder;

            SpecNestedImpl(DNSChaosSpec item) {
                this.builder = new DNSChaosSpecBuilder(this, item);
                        
            }

            SpecNestedImpl() {
                this.builder = new DNSChaosSpecBuilder(this);
                        
            }

            public N and() {
                return (N) DNSChaosFluentImpl.this.withSpec(builder.build());
            }

            public N endSpec() {
                return and();
            }
    }


    public class StatusNestedImpl<N> extends DNSChaosStatusFluentImpl<io.fabric8.chaosmesh.v1alpha1.DNSChaosFluent.StatusNested<N>> implements io.fabric8.chaosmesh.v1alpha1.DNSChaosFluent.StatusNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final DNSChaosStatusBuilder builder;

            StatusNestedImpl(DNSChaosStatus item) {
                this.builder = new DNSChaosStatusBuilder(this, item);
                        
            }

            StatusNestedImpl() {
                this.builder = new DNSChaosStatusBuilder(this);
                        
            }

            public N and() {
                return (N) DNSChaosFluentImpl.this.withStatus(builder.build());
            }

            public N endStatus() {
                return and();
            }
    }


}
