package io.fabric8.chaosmesh.v1alpha1;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;

public class TimeChaosStatusFluentImpl<A extends TimeChaosStatusFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements TimeChaosStatusFluent<A> {

    private ExperimentStatusBuilder experiment;
    private String failedMessage;
    private ScheduleStatusBuilder scheduler;

    public TimeChaosStatusFluentImpl() {
    }

    public TimeChaosStatusFluentImpl(TimeChaosStatus instance) {
        this.withExperiment(instance.getExperiment()); 
        this.withFailedMessage(instance.getFailedMessage()); 
        this.withScheduler(instance.getScheduler()); 
    }

    
/**
 * This method has been deprecated, please use method buildExperiment instead.
 * @return The buildable object.
 */
@Deprecated public ExperimentStatus getExperiment() {
        return this.experiment!=null?this.experiment.build():null;
    }

    public ExperimentStatus buildExperiment() {
        return this.experiment!=null?this.experiment.build():null;
    }

    public A withExperiment(ExperimentStatus experiment) {
        _visitables.get("experiment").remove(this.experiment);
        if (experiment!=null){ this.experiment= new ExperimentStatusBuilder(experiment); _visitables.get("experiment").add(this.experiment);} return (A) this;
    }

    public Boolean hasExperiment() {
        return this.experiment != null;
    }

    public TimeChaosStatusFluent.ExperimentNested<A> withNewExperiment() {
        return new ExperimentNestedImpl();
    }

    public TimeChaosStatusFluent.ExperimentNested<A> withNewExperimentLike(ExperimentStatus item) {
        return new ExperimentNestedImpl(item);
    }

    public TimeChaosStatusFluent.ExperimentNested<A> editExperiment() {
        return withNewExperimentLike(getExperiment());
    }

    public TimeChaosStatusFluent.ExperimentNested<A> editOrNewExperiment() {
        return withNewExperimentLike(getExperiment() != null ? getExperiment(): new ExperimentStatusBuilder().build());
    }

    public TimeChaosStatusFluent.ExperimentNested<A> editOrNewExperimentLike(ExperimentStatus item) {
        return withNewExperimentLike(getExperiment() != null ? getExperiment(): item);
    }

    public String getFailedMessage() {
        return this.failedMessage;
    }

    public A withFailedMessage(String failedMessage) {
        this.failedMessage=failedMessage; return (A) this;
    }

    public Boolean hasFailedMessage() {
        return this.failedMessage != null;
    }

    public A withNewFailedMessage(StringBuilder arg1) {
        return (A)withFailedMessage(new String(arg1));
    }

    public A withNewFailedMessage(int[] arg1,int arg2,int arg3) {
        return (A)withFailedMessage(new String(arg1, arg2, arg3));
    }

    public A withNewFailedMessage(char[] arg1) {
        return (A)withFailedMessage(new String(arg1));
    }

    public A withNewFailedMessage(StringBuffer arg1) {
        return (A)withFailedMessage(new String(arg1));
    }

    public A withNewFailedMessage(byte[] arg1,int arg2) {
        return (A)withFailedMessage(new String(arg1, arg2));
    }

    public A withNewFailedMessage(byte[] arg1) {
        return (A)withFailedMessage(new String(arg1));
    }

    public A withNewFailedMessage(char[] arg1,int arg2,int arg3) {
        return (A)withFailedMessage(new String(arg1, arg2, arg3));
    }

    public A withNewFailedMessage(byte[] arg1,int arg2,int arg3) {
        return (A)withFailedMessage(new String(arg1, arg2, arg3));
    }

    public A withNewFailedMessage(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withFailedMessage(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewFailedMessage(String arg1) {
        return (A)withFailedMessage(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildScheduler instead.
 * @return The buildable object.
 */
@Deprecated public ScheduleStatus getScheduler() {
        return this.scheduler!=null?this.scheduler.build():null;
    }

    public ScheduleStatus buildScheduler() {
        return this.scheduler!=null?this.scheduler.build():null;
    }

    public A withScheduler(ScheduleStatus scheduler) {
        _visitables.get("scheduler").remove(this.scheduler);
        if (scheduler!=null){ this.scheduler= new ScheduleStatusBuilder(scheduler); _visitables.get("scheduler").add(this.scheduler);} return (A) this;
    }

    public Boolean hasScheduler() {
        return this.scheduler != null;
    }

    public A withNewScheduler(String nextRecover,String nextStart) {
        return (A)withScheduler(new ScheduleStatus(nextRecover, nextStart));
    }

    public TimeChaosStatusFluent.SchedulerNested<A> withNewScheduler() {
        return new SchedulerNestedImpl();
    }

    public TimeChaosStatusFluent.SchedulerNested<A> withNewSchedulerLike(ScheduleStatus item) {
        return new SchedulerNestedImpl(item);
    }

    public TimeChaosStatusFluent.SchedulerNested<A> editScheduler() {
        return withNewSchedulerLike(getScheduler());
    }

    public TimeChaosStatusFluent.SchedulerNested<A> editOrNewScheduler() {
        return withNewSchedulerLike(getScheduler() != null ? getScheduler(): new ScheduleStatusBuilder().build());
    }

    public TimeChaosStatusFluent.SchedulerNested<A> editOrNewSchedulerLike(ScheduleStatus item) {
        return withNewSchedulerLike(getScheduler() != null ? getScheduler(): item);
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        TimeChaosStatusFluentImpl that = (TimeChaosStatusFluentImpl) o;
        if (experiment != null ? !experiment.equals(that.experiment) :that.experiment != null) return false;
        if (failedMessage != null ? !failedMessage.equals(that.failedMessage) :that.failedMessage != null) return false;
        if (scheduler != null ? !scheduler.equals(that.scheduler) :that.scheduler != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(experiment,  failedMessage,  scheduler,  super.hashCode());
    }

    public class ExperimentNestedImpl<N> extends ExperimentStatusFluentImpl<TimeChaosStatusFluent.ExperimentNested<N>> implements TimeChaosStatusFluent.ExperimentNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ExperimentStatusBuilder builder;

            ExperimentNestedImpl(ExperimentStatus item) {
                this.builder = new ExperimentStatusBuilder(this, item);
                        
            }

            ExperimentNestedImpl() {
                this.builder = new ExperimentStatusBuilder(this);
                        
            }

            public N and() {
                return (N) TimeChaosStatusFluentImpl.this.withExperiment(builder.build());
            }

            public N endExperiment() {
                return and();
            }
    }


    public class SchedulerNestedImpl<N> extends ScheduleStatusFluentImpl<TimeChaosStatusFluent.SchedulerNested<N>> implements TimeChaosStatusFluent.SchedulerNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ScheduleStatusBuilder builder;

            SchedulerNestedImpl(ScheduleStatus item) {
                this.builder = new ScheduleStatusBuilder(this, item);
                        
            }

            SchedulerNestedImpl() {
                this.builder = new ScheduleStatusBuilder(this);
                        
            }

            public N and() {
                return (N) TimeChaosStatusFluentImpl.this.withScheduler(builder.build());
            }

            public N endScheduler() {
                return and();
            }
    }


}
