package io.fabric8.chaosmesh.v1alpha1;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Boolean;
import java.lang.Integer;
import java.lang.StringBuffer;
import java.lang.Long;
import java.lang.Object;

public class RawTrafficControlFluentImpl<A extends RawTrafficControlFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements RawTrafficControlFluent<A> {

    private BandwidthSpecBuilder bandwidth;
    private CorruptSpecBuilder corrupt;
    private DelaySpecBuilder delay;
    private DuplicateSpecBuilder duplicate;
    private String ipset;
    private LossSpecBuilder loss;
    private String source;
    private String type;

    public RawTrafficControlFluentImpl() {
    }

    public RawTrafficControlFluentImpl(RawTrafficControl instance) {
        this.withBandwidth(instance.getBandwidth()); 
        this.withCorrupt(instance.getCorrupt()); 
        this.withDelay(instance.getDelay()); 
        this.withDuplicate(instance.getDuplicate()); 
        this.withIpset(instance.getIpset()); 
        this.withLoss(instance.getLoss()); 
        this.withSource(instance.getSource()); 
        this.withType(instance.getType()); 
    }

    
/**
 * This method has been deprecated, please use method buildBandwidth instead.
 * @return The buildable object.
 */
@Deprecated public BandwidthSpec getBandwidth() {
        return this.bandwidth!=null?this.bandwidth.build():null;
    }

    public BandwidthSpec buildBandwidth() {
        return this.bandwidth!=null?this.bandwidth.build():null;
    }

    public A withBandwidth(BandwidthSpec bandwidth) {
        _visitables.get("bandwidth").remove(this.bandwidth);
        if (bandwidth!=null){ this.bandwidth= new BandwidthSpecBuilder(bandwidth); _visitables.get("bandwidth").add(this.bandwidth);} return (A) this;
    }

    public Boolean hasBandwidth() {
        return this.bandwidth != null;
    }

    public A withNewBandwidth(Integer buffer,Integer limit,Long minburst,Long peakrate,String rate) {
        return (A)withBandwidth(new BandwidthSpec(buffer, limit, minburst, peakrate, rate));
    }

    public RawTrafficControlFluent.BandwidthNested<A> withNewBandwidth() {
        return new BandwidthNestedImpl();
    }

    public RawTrafficControlFluent.BandwidthNested<A> withNewBandwidthLike(BandwidthSpec item) {
        return new BandwidthNestedImpl(item);
    }

    public RawTrafficControlFluent.BandwidthNested<A> editBandwidth() {
        return withNewBandwidthLike(getBandwidth());
    }

    public RawTrafficControlFluent.BandwidthNested<A> editOrNewBandwidth() {
        return withNewBandwidthLike(getBandwidth() != null ? getBandwidth(): new BandwidthSpecBuilder().build());
    }

    public RawTrafficControlFluent.BandwidthNested<A> editOrNewBandwidthLike(BandwidthSpec item) {
        return withNewBandwidthLike(getBandwidth() != null ? getBandwidth(): item);
    }

    
/**
 * This method has been deprecated, please use method buildCorrupt instead.
 * @return The buildable object.
 */
@Deprecated public CorruptSpec getCorrupt() {
        return this.corrupt!=null?this.corrupt.build():null;
    }

    public CorruptSpec buildCorrupt() {
        return this.corrupt!=null?this.corrupt.build():null;
    }

    public A withCorrupt(CorruptSpec corrupt) {
        _visitables.get("corrupt").remove(this.corrupt);
        if (corrupt!=null){ this.corrupt= new CorruptSpecBuilder(corrupt); _visitables.get("corrupt").add(this.corrupt);} return (A) this;
    }

    public Boolean hasCorrupt() {
        return this.corrupt != null;
    }

    public A withNewCorrupt(String correlation,String corrupt) {
        return (A)withCorrupt(new CorruptSpec(correlation, corrupt));
    }

    public RawTrafficControlFluent.CorruptNested<A> withNewCorrupt() {
        return new CorruptNestedImpl();
    }

    public RawTrafficControlFluent.CorruptNested<A> withNewCorruptLike(CorruptSpec item) {
        return new CorruptNestedImpl(item);
    }

    public RawTrafficControlFluent.CorruptNested<A> editCorrupt() {
        return withNewCorruptLike(getCorrupt());
    }

    public RawTrafficControlFluent.CorruptNested<A> editOrNewCorrupt() {
        return withNewCorruptLike(getCorrupt() != null ? getCorrupt(): new CorruptSpecBuilder().build());
    }

    public RawTrafficControlFluent.CorruptNested<A> editOrNewCorruptLike(CorruptSpec item) {
        return withNewCorruptLike(getCorrupt() != null ? getCorrupt(): item);
    }

    
/**
 * This method has been deprecated, please use method buildDelay instead.
 * @return The buildable object.
 */
@Deprecated public DelaySpec getDelay() {
        return this.delay!=null?this.delay.build():null;
    }

    public DelaySpec buildDelay() {
        return this.delay!=null?this.delay.build():null;
    }

    public A withDelay(DelaySpec delay) {
        _visitables.get("delay").remove(this.delay);
        if (delay!=null){ this.delay= new DelaySpecBuilder(delay); _visitables.get("delay").add(this.delay);} return (A) this;
    }

    public Boolean hasDelay() {
        return this.delay != null;
    }

    public RawTrafficControlFluent.DelayNested<A> withNewDelay() {
        return new DelayNestedImpl();
    }

    public RawTrafficControlFluent.DelayNested<A> withNewDelayLike(DelaySpec item) {
        return new DelayNestedImpl(item);
    }

    public RawTrafficControlFluent.DelayNested<A> editDelay() {
        return withNewDelayLike(getDelay());
    }

    public RawTrafficControlFluent.DelayNested<A> editOrNewDelay() {
        return withNewDelayLike(getDelay() != null ? getDelay(): new DelaySpecBuilder().build());
    }

    public RawTrafficControlFluent.DelayNested<A> editOrNewDelayLike(DelaySpec item) {
        return withNewDelayLike(getDelay() != null ? getDelay(): item);
    }

    
/**
 * This method has been deprecated, please use method buildDuplicate instead.
 * @return The buildable object.
 */
@Deprecated public DuplicateSpec getDuplicate() {
        return this.duplicate!=null?this.duplicate.build():null;
    }

    public DuplicateSpec buildDuplicate() {
        return this.duplicate!=null?this.duplicate.build():null;
    }

    public A withDuplicate(DuplicateSpec duplicate) {
        _visitables.get("duplicate").remove(this.duplicate);
        if (duplicate!=null){ this.duplicate= new DuplicateSpecBuilder(duplicate); _visitables.get("duplicate").add(this.duplicate);} return (A) this;
    }

    public Boolean hasDuplicate() {
        return this.duplicate != null;
    }

    public A withNewDuplicate(String correlation,String duplicate) {
        return (A)withDuplicate(new DuplicateSpec(correlation, duplicate));
    }

    public RawTrafficControlFluent.DuplicateNested<A> withNewDuplicate() {
        return new DuplicateNestedImpl();
    }

    public RawTrafficControlFluent.DuplicateNested<A> withNewDuplicateLike(DuplicateSpec item) {
        return new DuplicateNestedImpl(item);
    }

    public RawTrafficControlFluent.DuplicateNested<A> editDuplicate() {
        return withNewDuplicateLike(getDuplicate());
    }

    public RawTrafficControlFluent.DuplicateNested<A> editOrNewDuplicate() {
        return withNewDuplicateLike(getDuplicate() != null ? getDuplicate(): new DuplicateSpecBuilder().build());
    }

    public RawTrafficControlFluent.DuplicateNested<A> editOrNewDuplicateLike(DuplicateSpec item) {
        return withNewDuplicateLike(getDuplicate() != null ? getDuplicate(): item);
    }

    public String getIpset() {
        return this.ipset;
    }

    public A withIpset(String ipset) {
        this.ipset=ipset; return (A) this;
    }

    public Boolean hasIpset() {
        return this.ipset != null;
    }

    public A withNewIpset(StringBuilder arg1) {
        return (A)withIpset(new String(arg1));
    }

    public A withNewIpset(int[] arg1,int arg2,int arg3) {
        return (A)withIpset(new String(arg1, arg2, arg3));
    }

    public A withNewIpset(char[] arg1) {
        return (A)withIpset(new String(arg1));
    }

    public A withNewIpset(StringBuffer arg1) {
        return (A)withIpset(new String(arg1));
    }

    public A withNewIpset(byte[] arg1,int arg2) {
        return (A)withIpset(new String(arg1, arg2));
    }

    public A withNewIpset(byte[] arg1) {
        return (A)withIpset(new String(arg1));
    }

    public A withNewIpset(char[] arg1,int arg2,int arg3) {
        return (A)withIpset(new String(arg1, arg2, arg3));
    }

    public A withNewIpset(byte[] arg1,int arg2,int arg3) {
        return (A)withIpset(new String(arg1, arg2, arg3));
    }

    public A withNewIpset(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withIpset(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewIpset(String arg1) {
        return (A)withIpset(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildLoss instead.
 * @return The buildable object.
 */
@Deprecated public LossSpec getLoss() {
        return this.loss!=null?this.loss.build():null;
    }

    public LossSpec buildLoss() {
        return this.loss!=null?this.loss.build():null;
    }

    public A withLoss(LossSpec loss) {
        _visitables.get("loss").remove(this.loss);
        if (loss!=null){ this.loss= new LossSpecBuilder(loss); _visitables.get("loss").add(this.loss);} return (A) this;
    }

    public Boolean hasLoss() {
        return this.loss != null;
    }

    public A withNewLoss(String correlation,String loss) {
        return (A)withLoss(new LossSpec(correlation, loss));
    }

    public RawTrafficControlFluent.LossNested<A> withNewLoss() {
        return new LossNestedImpl();
    }

    public RawTrafficControlFluent.LossNested<A> withNewLossLike(LossSpec item) {
        return new LossNestedImpl(item);
    }

    public RawTrafficControlFluent.LossNested<A> editLoss() {
        return withNewLossLike(getLoss());
    }

    public RawTrafficControlFluent.LossNested<A> editOrNewLoss() {
        return withNewLossLike(getLoss() != null ? getLoss(): new LossSpecBuilder().build());
    }

    public RawTrafficControlFluent.LossNested<A> editOrNewLossLike(LossSpec item) {
        return withNewLossLike(getLoss() != null ? getLoss(): item);
    }

    public String getSource() {
        return this.source;
    }

    public A withSource(String source) {
        this.source=source; return (A) this;
    }

    public Boolean hasSource() {
        return this.source != null;
    }

    public A withNewSource(StringBuilder arg1) {
        return (A)withSource(new String(arg1));
    }

    public A withNewSource(int[] arg1,int arg2,int arg3) {
        return (A)withSource(new String(arg1, arg2, arg3));
    }

    public A withNewSource(char[] arg1) {
        return (A)withSource(new String(arg1));
    }

    public A withNewSource(StringBuffer arg1) {
        return (A)withSource(new String(arg1));
    }

    public A withNewSource(byte[] arg1,int arg2) {
        return (A)withSource(new String(arg1, arg2));
    }

    public A withNewSource(byte[] arg1) {
        return (A)withSource(new String(arg1));
    }

    public A withNewSource(char[] arg1,int arg2,int arg3) {
        return (A)withSource(new String(arg1, arg2, arg3));
    }

    public A withNewSource(byte[] arg1,int arg2,int arg3) {
        return (A)withSource(new String(arg1, arg2, arg3));
    }

    public A withNewSource(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withSource(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewSource(String arg1) {
        return (A)withSource(new String(arg1));
    }

    public String getType() {
        return this.type;
    }

    public A withType(String type) {
        this.type=type; return (A) this;
    }

    public Boolean hasType() {
        return this.type != null;
    }

    public A withNewType(StringBuilder arg1) {
        return (A)withType(new String(arg1));
    }

    public A withNewType(int[] arg1,int arg2,int arg3) {
        return (A)withType(new String(arg1, arg2, arg3));
    }

    public A withNewType(char[] arg1) {
        return (A)withType(new String(arg1));
    }

    public A withNewType(StringBuffer arg1) {
        return (A)withType(new String(arg1));
    }

    public A withNewType(byte[] arg1,int arg2) {
        return (A)withType(new String(arg1, arg2));
    }

    public A withNewType(byte[] arg1) {
        return (A)withType(new String(arg1));
    }

    public A withNewType(char[] arg1,int arg2,int arg3) {
        return (A)withType(new String(arg1, arg2, arg3));
    }

    public A withNewType(byte[] arg1,int arg2,int arg3) {
        return (A)withType(new String(arg1, arg2, arg3));
    }

    public A withNewType(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withType(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewType(String arg1) {
        return (A)withType(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        RawTrafficControlFluentImpl that = (RawTrafficControlFluentImpl) o;
        if (bandwidth != null ? !bandwidth.equals(that.bandwidth) :that.bandwidth != null) return false;
        if (corrupt != null ? !corrupt.equals(that.corrupt) :that.corrupt != null) return false;
        if (delay != null ? !delay.equals(that.delay) :that.delay != null) return false;
        if (duplicate != null ? !duplicate.equals(that.duplicate) :that.duplicate != null) return false;
        if (ipset != null ? !ipset.equals(that.ipset) :that.ipset != null) return false;
        if (loss != null ? !loss.equals(that.loss) :that.loss != null) return false;
        if (source != null ? !source.equals(that.source) :that.source != null) return false;
        if (type != null ? !type.equals(that.type) :that.type != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(bandwidth,  corrupt,  delay,  duplicate,  ipset,  loss,  source,  type,  super.hashCode());
    }

    public class BandwidthNestedImpl<N> extends BandwidthSpecFluentImpl<RawTrafficControlFluent.BandwidthNested<N>> implements RawTrafficControlFluent.BandwidthNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final BandwidthSpecBuilder builder;

            BandwidthNestedImpl(BandwidthSpec item) {
                this.builder = new BandwidthSpecBuilder(this, item);
                        
            }

            BandwidthNestedImpl() {
                this.builder = new BandwidthSpecBuilder(this);
                        
            }

            public N and() {
                return (N) RawTrafficControlFluentImpl.this.withBandwidth(builder.build());
            }

            public N endBandwidth() {
                return and();
            }
    }


    public class CorruptNestedImpl<N> extends CorruptSpecFluentImpl<RawTrafficControlFluent.CorruptNested<N>> implements RawTrafficControlFluent.CorruptNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final CorruptSpecBuilder builder;

            CorruptNestedImpl(CorruptSpec item) {
                this.builder = new CorruptSpecBuilder(this, item);
                        
            }

            CorruptNestedImpl() {
                this.builder = new CorruptSpecBuilder(this);
                        
            }

            public N and() {
                return (N) RawTrafficControlFluentImpl.this.withCorrupt(builder.build());
            }

            public N endCorrupt() {
                return and();
            }
    }


    public class DelayNestedImpl<N> extends DelaySpecFluentImpl<RawTrafficControlFluent.DelayNested<N>> implements RawTrafficControlFluent.DelayNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final DelaySpecBuilder builder;

            DelayNestedImpl(DelaySpec item) {
                this.builder = new DelaySpecBuilder(this, item);
                        
            }

            DelayNestedImpl() {
                this.builder = new DelaySpecBuilder(this);
                        
            }

            public N and() {
                return (N) RawTrafficControlFluentImpl.this.withDelay(builder.build());
            }

            public N endDelay() {
                return and();
            }
    }


    public class DuplicateNestedImpl<N> extends DuplicateSpecFluentImpl<RawTrafficControlFluent.DuplicateNested<N>> implements RawTrafficControlFluent.DuplicateNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final DuplicateSpecBuilder builder;

            DuplicateNestedImpl(DuplicateSpec item) {
                this.builder = new DuplicateSpecBuilder(this, item);
                        
            }

            DuplicateNestedImpl() {
                this.builder = new DuplicateSpecBuilder(this);
                        
            }

            public N and() {
                return (N) RawTrafficControlFluentImpl.this.withDuplicate(builder.build());
            }

            public N endDuplicate() {
                return and();
            }
    }


    public class LossNestedImpl<N> extends LossSpecFluentImpl<RawTrafficControlFluent.LossNested<N>> implements RawTrafficControlFluent.LossNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final LossSpecBuilder builder;

            LossNestedImpl(LossSpec item) {
                this.builder = new LossSpecBuilder(this, item);
                        
            }

            LossNestedImpl() {
                this.builder = new LossSpecBuilder(this);
                        
            }

            public N and() {
                return (N) RawTrafficControlFluentImpl.this.withLoss(builder.build());
            }

            public N endLoss() {
                return and();
            }
    }


}
