package io.fabric8.chaosmesh.v1alpha1;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.List;
import java.lang.Boolean;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.Deprecated;
import java.lang.Integer;
import java.lang.StringBuffer;

public class NetworkChaosSpecFluentImpl<A extends NetworkChaosSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements NetworkChaosSpecFluent<A> {

    private String action;
    private BandwidthSpecBuilder bandwidth;
    private CorruptSpecBuilder corrupt;
    private DelaySpecBuilder delay;
    private String direction;
    private DuplicateSpecBuilder duplicate;
    private String duration;
    private List<String> externalTargets;
    private LossSpecBuilder loss;
    private String mode;
    private SchedulerSpecBuilder scheduler;
    private SelectorSpecBuilder selector;
    private TargetBuilder target;
    private String value;

    public NetworkChaosSpecFluentImpl() {
    }

    public NetworkChaosSpecFluentImpl(NetworkChaosSpec instance) {
        this.withAction(instance.getAction()); 
        this.withBandwidth(instance.getBandwidth()); 
        this.withCorrupt(instance.getCorrupt()); 
        this.withDelay(instance.getDelay()); 
        this.withDirection(instance.getDirection()); 
        this.withDuplicate(instance.getDuplicate()); 
        this.withDuration(instance.getDuration()); 
        this.withExternalTargets(instance.getExternalTargets()); 
        this.withLoss(instance.getLoss()); 
        this.withMode(instance.getMode()); 
        this.withScheduler(instance.getScheduler()); 
        this.withSelector(instance.getSelector()); 
        this.withTarget(instance.getTarget()); 
        this.withValue(instance.getValue()); 
    }

    public String getAction() {
        return this.action;
    }

    public A withAction(String action) {
        this.action=action; return (A) this;
    }

    public Boolean hasAction() {
        return this.action != null;
    }

    public A withNewAction(StringBuilder arg1) {
        return (A)withAction(new String(arg1));
    }

    public A withNewAction(int[] arg1,int arg2,int arg3) {
        return (A)withAction(new String(arg1, arg2, arg3));
    }

    public A withNewAction(char[] arg1) {
        return (A)withAction(new String(arg1));
    }

    public A withNewAction(StringBuffer arg1) {
        return (A)withAction(new String(arg1));
    }

    public A withNewAction(byte[] arg1,int arg2) {
        return (A)withAction(new String(arg1, arg2));
    }

    public A withNewAction(byte[] arg1) {
        return (A)withAction(new String(arg1));
    }

    public A withNewAction(char[] arg1,int arg2,int arg3) {
        return (A)withAction(new String(arg1, arg2, arg3));
    }

    public A withNewAction(byte[] arg1,int arg2,int arg3) {
        return (A)withAction(new String(arg1, arg2, arg3));
    }

    public A withNewAction(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withAction(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewAction(String arg1) {
        return (A)withAction(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildBandwidth instead.
 * @return The buildable object.
 */
@Deprecated public BandwidthSpec getBandwidth() {
        return this.bandwidth!=null?this.bandwidth.build():null;
    }

    public BandwidthSpec buildBandwidth() {
        return this.bandwidth!=null?this.bandwidth.build():null;
    }

    public A withBandwidth(BandwidthSpec bandwidth) {
        _visitables.get("bandwidth").remove(this.bandwidth);
        if (bandwidth!=null){ this.bandwidth= new BandwidthSpecBuilder(bandwidth); _visitables.get("bandwidth").add(this.bandwidth);} return (A) this;
    }

    public Boolean hasBandwidth() {
        return this.bandwidth != null;
    }

    public A withNewBandwidth(Integer buffer,Integer limit,Long minburst,Long peakrate,String rate) {
        return (A)withBandwidth(new BandwidthSpec(buffer, limit, minburst, peakrate, rate));
    }

    public NetworkChaosSpecFluent.BandwidthNested<A> withNewBandwidth() {
        return new BandwidthNestedImpl();
    }

    public NetworkChaosSpecFluent.BandwidthNested<A> withNewBandwidthLike(BandwidthSpec item) {
        return new BandwidthNestedImpl(item);
    }

    public NetworkChaosSpecFluent.BandwidthNested<A> editBandwidth() {
        return withNewBandwidthLike(getBandwidth());
    }

    public NetworkChaosSpecFluent.BandwidthNested<A> editOrNewBandwidth() {
        return withNewBandwidthLike(getBandwidth() != null ? getBandwidth(): new BandwidthSpecBuilder().build());
    }

    public NetworkChaosSpecFluent.BandwidthNested<A> editOrNewBandwidthLike(BandwidthSpec item) {
        return withNewBandwidthLike(getBandwidth() != null ? getBandwidth(): item);
    }

    
/**
 * This method has been deprecated, please use method buildCorrupt instead.
 * @return The buildable object.
 */
@Deprecated public CorruptSpec getCorrupt() {
        return this.corrupt!=null?this.corrupt.build():null;
    }

    public CorruptSpec buildCorrupt() {
        return this.corrupt!=null?this.corrupt.build():null;
    }

    public A withCorrupt(CorruptSpec corrupt) {
        _visitables.get("corrupt").remove(this.corrupt);
        if (corrupt!=null){ this.corrupt= new CorruptSpecBuilder(corrupt); _visitables.get("corrupt").add(this.corrupt);} return (A) this;
    }

    public Boolean hasCorrupt() {
        return this.corrupt != null;
    }

    public A withNewCorrupt(String correlation,String corrupt) {
        return (A)withCorrupt(new CorruptSpec(correlation, corrupt));
    }

    public NetworkChaosSpecFluent.CorruptNested<A> withNewCorrupt() {
        return new CorruptNestedImpl();
    }

    public NetworkChaosSpecFluent.CorruptNested<A> withNewCorruptLike(CorruptSpec item) {
        return new CorruptNestedImpl(item);
    }

    public NetworkChaosSpecFluent.CorruptNested<A> editCorrupt() {
        return withNewCorruptLike(getCorrupt());
    }

    public NetworkChaosSpecFluent.CorruptNested<A> editOrNewCorrupt() {
        return withNewCorruptLike(getCorrupt() != null ? getCorrupt(): new CorruptSpecBuilder().build());
    }

    public NetworkChaosSpecFluent.CorruptNested<A> editOrNewCorruptLike(CorruptSpec item) {
        return withNewCorruptLike(getCorrupt() != null ? getCorrupt(): item);
    }

    
/**
 * This method has been deprecated, please use method buildDelay instead.
 * @return The buildable object.
 */
@Deprecated public DelaySpec getDelay() {
        return this.delay!=null?this.delay.build():null;
    }

    public DelaySpec buildDelay() {
        return this.delay!=null?this.delay.build():null;
    }

    public A withDelay(DelaySpec delay) {
        _visitables.get("delay").remove(this.delay);
        if (delay!=null){ this.delay= new DelaySpecBuilder(delay); _visitables.get("delay").add(this.delay);} return (A) this;
    }

    public Boolean hasDelay() {
        return this.delay != null;
    }

    public NetworkChaosSpecFluent.DelayNested<A> withNewDelay() {
        return new DelayNestedImpl();
    }

    public NetworkChaosSpecFluent.DelayNested<A> withNewDelayLike(DelaySpec item) {
        return new DelayNestedImpl(item);
    }

    public NetworkChaosSpecFluent.DelayNested<A> editDelay() {
        return withNewDelayLike(getDelay());
    }

    public NetworkChaosSpecFluent.DelayNested<A> editOrNewDelay() {
        return withNewDelayLike(getDelay() != null ? getDelay(): new DelaySpecBuilder().build());
    }

    public NetworkChaosSpecFluent.DelayNested<A> editOrNewDelayLike(DelaySpec item) {
        return withNewDelayLike(getDelay() != null ? getDelay(): item);
    }

    public String getDirection() {
        return this.direction;
    }

    public A withDirection(String direction) {
        this.direction=direction; return (A) this;
    }

    public Boolean hasDirection() {
        return this.direction != null;
    }

    public A withNewDirection(StringBuilder arg1) {
        return (A)withDirection(new String(arg1));
    }

    public A withNewDirection(int[] arg1,int arg2,int arg3) {
        return (A)withDirection(new String(arg1, arg2, arg3));
    }

    public A withNewDirection(char[] arg1) {
        return (A)withDirection(new String(arg1));
    }

    public A withNewDirection(StringBuffer arg1) {
        return (A)withDirection(new String(arg1));
    }

    public A withNewDirection(byte[] arg1,int arg2) {
        return (A)withDirection(new String(arg1, arg2));
    }

    public A withNewDirection(byte[] arg1) {
        return (A)withDirection(new String(arg1));
    }

    public A withNewDirection(char[] arg1,int arg2,int arg3) {
        return (A)withDirection(new String(arg1, arg2, arg3));
    }

    public A withNewDirection(byte[] arg1,int arg2,int arg3) {
        return (A)withDirection(new String(arg1, arg2, arg3));
    }

    public A withNewDirection(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withDirection(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewDirection(String arg1) {
        return (A)withDirection(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildDuplicate instead.
 * @return The buildable object.
 */
@Deprecated public DuplicateSpec getDuplicate() {
        return this.duplicate!=null?this.duplicate.build():null;
    }

    public DuplicateSpec buildDuplicate() {
        return this.duplicate!=null?this.duplicate.build():null;
    }

    public A withDuplicate(DuplicateSpec duplicate) {
        _visitables.get("duplicate").remove(this.duplicate);
        if (duplicate!=null){ this.duplicate= new DuplicateSpecBuilder(duplicate); _visitables.get("duplicate").add(this.duplicate);} return (A) this;
    }

    public Boolean hasDuplicate() {
        return this.duplicate != null;
    }

    public A withNewDuplicate(String correlation,String duplicate) {
        return (A)withDuplicate(new DuplicateSpec(correlation, duplicate));
    }

    public NetworkChaosSpecFluent.DuplicateNested<A> withNewDuplicate() {
        return new DuplicateNestedImpl();
    }

    public NetworkChaosSpecFluent.DuplicateNested<A> withNewDuplicateLike(DuplicateSpec item) {
        return new DuplicateNestedImpl(item);
    }

    public NetworkChaosSpecFluent.DuplicateNested<A> editDuplicate() {
        return withNewDuplicateLike(getDuplicate());
    }

    public NetworkChaosSpecFluent.DuplicateNested<A> editOrNewDuplicate() {
        return withNewDuplicateLike(getDuplicate() != null ? getDuplicate(): new DuplicateSpecBuilder().build());
    }

    public NetworkChaosSpecFluent.DuplicateNested<A> editOrNewDuplicateLike(DuplicateSpec item) {
        return withNewDuplicateLike(getDuplicate() != null ? getDuplicate(): item);
    }

    public String getDuration() {
        return this.duration;
    }

    public A withDuration(String duration) {
        this.duration=duration; return (A) this;
    }

    public Boolean hasDuration() {
        return this.duration != null;
    }

    public A withNewDuration(StringBuilder arg1) {
        return (A)withDuration(new String(arg1));
    }

    public A withNewDuration(int[] arg1,int arg2,int arg3) {
        return (A)withDuration(new String(arg1, arg2, arg3));
    }

    public A withNewDuration(char[] arg1) {
        return (A)withDuration(new String(arg1));
    }

    public A withNewDuration(StringBuffer arg1) {
        return (A)withDuration(new String(arg1));
    }

    public A withNewDuration(byte[] arg1,int arg2) {
        return (A)withDuration(new String(arg1, arg2));
    }

    public A withNewDuration(byte[] arg1) {
        return (A)withDuration(new String(arg1));
    }

    public A withNewDuration(char[] arg1,int arg2,int arg3) {
        return (A)withDuration(new String(arg1, arg2, arg3));
    }

    public A withNewDuration(byte[] arg1,int arg2,int arg3) {
        return (A)withDuration(new String(arg1, arg2, arg3));
    }

    public A withNewDuration(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withDuration(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewDuration(String arg1) {
        return (A)withDuration(new String(arg1));
    }

    public A addToExternalTargets(int index,String item) {
        if (this.externalTargets == null) {this.externalTargets = new ArrayList<String>();}
        this.externalTargets.add(index, item);
        return (A)this;
    }

    public A setToExternalTargets(int index,String item) {
        if (this.externalTargets == null) {this.externalTargets = new ArrayList<String>();}
        this.externalTargets.set(index, item); return (A)this;
    }

    public A addToExternalTargets(String... items) {
        if (this.externalTargets == null) {this.externalTargets = new ArrayList<String>();}
        for (String item : items) {this.externalTargets.add(item);} return (A)this;
    }

    public A addAllToExternalTargets(Collection<String> items) {
        if (this.externalTargets == null) {this.externalTargets = new ArrayList<String>();}
        for (String item : items) {this.externalTargets.add(item);} return (A)this;
    }

    public A removeFromExternalTargets(String... items) {
        for (String item : items) {if (this.externalTargets!= null){ this.externalTargets.remove(item);}} return (A)this;
    }

    public A removeAllFromExternalTargets(Collection<String> items) {
        for (String item : items) {if (this.externalTargets!= null){ this.externalTargets.remove(item);}} return (A)this;
    }

    public List<String> getExternalTargets() {
        return this.externalTargets;
    }

    public String getExternalTarget(int index) {
        return this.externalTargets.get(index);
    }

    public String getFirstExternalTarget() {
        return this.externalTargets.get(0);
    }

    public String getLastExternalTarget() {
        return this.externalTargets.get(externalTargets.size() - 1);
    }

    public String getMatchingExternalTarget(Predicate<String> predicate) {
        for (String item: externalTargets) { if(predicate.test(item)){ return item;} } return null;
    }

    public Boolean hasMatchingExternalTarget(Predicate<String> predicate) {
        for (String item: externalTargets) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withExternalTargets(List<String> externalTargets) {
        if (this.externalTargets != null) { _visitables.get("externalTargets").removeAll(this.externalTargets);}
        if (externalTargets != null) {this.externalTargets = new ArrayList<String>(); for (String item : externalTargets){this.addToExternalTargets(item);}} else { this.externalTargets = null;} return (A) this;
    }

    public A withExternalTargets(String... externalTargets) {
        if (this.externalTargets != null) {this.externalTargets.clear();}
        if (externalTargets != null) {for (String item :externalTargets){ this.addToExternalTargets(item);}} return (A) this;
    }

    public Boolean hasExternalTargets() {
        return externalTargets != null && !externalTargets.isEmpty();
    }

    public A addNewExternalTarget(StringBuilder arg1) {
        return (A)addToExternalTargets(new String(arg1));
    }

    public A addNewExternalTarget(int[] arg1,int arg2,int arg3) {
        return (A)addToExternalTargets(new String(arg1, arg2, arg3));
    }

    public A addNewExternalTarget(char[] arg1) {
        return (A)addToExternalTargets(new String(arg1));
    }

    public A addNewExternalTarget(StringBuffer arg1) {
        return (A)addToExternalTargets(new String(arg1));
    }

    public A addNewExternalTarget(byte[] arg1,int arg2) {
        return (A)addToExternalTargets(new String(arg1, arg2));
    }

    public A addNewExternalTarget(byte[] arg1) {
        return (A)addToExternalTargets(new String(arg1));
    }

    public A addNewExternalTarget(char[] arg1,int arg2,int arg3) {
        return (A)addToExternalTargets(new String(arg1, arg2, arg3));
    }

    public A addNewExternalTarget(byte[] arg1,int arg2,int arg3) {
        return (A)addToExternalTargets(new String(arg1, arg2, arg3));
    }

    public A addNewExternalTarget(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)addToExternalTargets(new String(arg1, arg2, arg3, arg4));
    }

    public A addNewExternalTarget(String arg1) {
        return (A)addToExternalTargets(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildLoss instead.
 * @return The buildable object.
 */
@Deprecated public LossSpec getLoss() {
        return this.loss!=null?this.loss.build():null;
    }

    public LossSpec buildLoss() {
        return this.loss!=null?this.loss.build():null;
    }

    public A withLoss(LossSpec loss) {
        _visitables.get("loss").remove(this.loss);
        if (loss!=null){ this.loss= new LossSpecBuilder(loss); _visitables.get("loss").add(this.loss);} return (A) this;
    }

    public Boolean hasLoss() {
        return this.loss != null;
    }

    public A withNewLoss(String correlation,String loss) {
        return (A)withLoss(new LossSpec(correlation, loss));
    }

    public NetworkChaosSpecFluent.LossNested<A> withNewLoss() {
        return new LossNestedImpl();
    }

    public NetworkChaosSpecFluent.LossNested<A> withNewLossLike(LossSpec item) {
        return new LossNestedImpl(item);
    }

    public NetworkChaosSpecFluent.LossNested<A> editLoss() {
        return withNewLossLike(getLoss());
    }

    public NetworkChaosSpecFluent.LossNested<A> editOrNewLoss() {
        return withNewLossLike(getLoss() != null ? getLoss(): new LossSpecBuilder().build());
    }

    public NetworkChaosSpecFluent.LossNested<A> editOrNewLossLike(LossSpec item) {
        return withNewLossLike(getLoss() != null ? getLoss(): item);
    }

    public String getMode() {
        return this.mode;
    }

    public A withMode(String mode) {
        this.mode=mode; return (A) this;
    }

    public Boolean hasMode() {
        return this.mode != null;
    }

    public A withNewMode(StringBuilder arg1) {
        return (A)withMode(new String(arg1));
    }

    public A withNewMode(int[] arg1,int arg2,int arg3) {
        return (A)withMode(new String(arg1, arg2, arg3));
    }

    public A withNewMode(char[] arg1) {
        return (A)withMode(new String(arg1));
    }

    public A withNewMode(StringBuffer arg1) {
        return (A)withMode(new String(arg1));
    }

    public A withNewMode(byte[] arg1,int arg2) {
        return (A)withMode(new String(arg1, arg2));
    }

    public A withNewMode(byte[] arg1) {
        return (A)withMode(new String(arg1));
    }

    public A withNewMode(char[] arg1,int arg2,int arg3) {
        return (A)withMode(new String(arg1, arg2, arg3));
    }

    public A withNewMode(byte[] arg1,int arg2,int arg3) {
        return (A)withMode(new String(arg1, arg2, arg3));
    }

    public A withNewMode(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withMode(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewMode(String arg1) {
        return (A)withMode(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildScheduler instead.
 * @return The buildable object.
 */
@Deprecated public SchedulerSpec getScheduler() {
        return this.scheduler!=null?this.scheduler.build():null;
    }

    public SchedulerSpec buildScheduler() {
        return this.scheduler!=null?this.scheduler.build():null;
    }

    public A withScheduler(SchedulerSpec scheduler) {
        _visitables.get("scheduler").remove(this.scheduler);
        if (scheduler!=null){ this.scheduler= new SchedulerSpecBuilder(scheduler); _visitables.get("scheduler").add(this.scheduler);} return (A) this;
    }

    public Boolean hasScheduler() {
        return this.scheduler != null;
    }

    public A withNewScheduler(String cron) {
        return (A)withScheduler(new SchedulerSpec(cron));
    }

    public NetworkChaosSpecFluent.SchedulerNested<A> withNewScheduler() {
        return new SchedulerNestedImpl();
    }

    public NetworkChaosSpecFluent.SchedulerNested<A> withNewSchedulerLike(SchedulerSpec item) {
        return new SchedulerNestedImpl(item);
    }

    public NetworkChaosSpecFluent.SchedulerNested<A> editScheduler() {
        return withNewSchedulerLike(getScheduler());
    }

    public NetworkChaosSpecFluent.SchedulerNested<A> editOrNewScheduler() {
        return withNewSchedulerLike(getScheduler() != null ? getScheduler(): new SchedulerSpecBuilder().build());
    }

    public NetworkChaosSpecFluent.SchedulerNested<A> editOrNewSchedulerLike(SchedulerSpec item) {
        return withNewSchedulerLike(getScheduler() != null ? getScheduler(): item);
    }

    
/**
 * This method has been deprecated, please use method buildSelector instead.
 * @return The buildable object.
 */
@Deprecated public SelectorSpec getSelector() {
        return this.selector!=null?this.selector.build():null;
    }

    public SelectorSpec buildSelector() {
        return this.selector!=null?this.selector.build():null;
    }

    public A withSelector(SelectorSpec selector) {
        _visitables.get("selector").remove(this.selector);
        if (selector!=null){ this.selector= new SelectorSpecBuilder(selector); _visitables.get("selector").add(this.selector);} return (A) this;
    }

    public Boolean hasSelector() {
        return this.selector != null;
    }

    public NetworkChaosSpecFluent.SelectorNested<A> withNewSelector() {
        return new SelectorNestedImpl();
    }

    public NetworkChaosSpecFluent.SelectorNested<A> withNewSelectorLike(SelectorSpec item) {
        return new SelectorNestedImpl(item);
    }

    public NetworkChaosSpecFluent.SelectorNested<A> editSelector() {
        return withNewSelectorLike(getSelector());
    }

    public NetworkChaosSpecFluent.SelectorNested<A> editOrNewSelector() {
        return withNewSelectorLike(getSelector() != null ? getSelector(): new SelectorSpecBuilder().build());
    }

    public NetworkChaosSpecFluent.SelectorNested<A> editOrNewSelectorLike(SelectorSpec item) {
        return withNewSelectorLike(getSelector() != null ? getSelector(): item);
    }

    
/**
 * This method has been deprecated, please use method buildTarget instead.
 * @return The buildable object.
 */
@Deprecated public Target getTarget() {
        return this.target!=null?this.target.build():null;
    }

    public Target buildTarget() {
        return this.target!=null?this.target.build():null;
    }

    public A withTarget(Target target) {
        _visitables.get("target").remove(this.target);
        if (target!=null){ this.target= new TargetBuilder(target); _visitables.get("target").add(this.target);} return (A) this;
    }

    public Boolean hasTarget() {
        return this.target != null;
    }

    public NetworkChaosSpecFluent.TargetNested<A> withNewTarget() {
        return new TargetNestedImpl();
    }

    public NetworkChaosSpecFluent.TargetNested<A> withNewTargetLike(Target item) {
        return new TargetNestedImpl(item);
    }

    public NetworkChaosSpecFluent.TargetNested<A> editTarget() {
        return withNewTargetLike(getTarget());
    }

    public NetworkChaosSpecFluent.TargetNested<A> editOrNewTarget() {
        return withNewTargetLike(getTarget() != null ? getTarget(): new TargetBuilder().build());
    }

    public NetworkChaosSpecFluent.TargetNested<A> editOrNewTargetLike(Target item) {
        return withNewTargetLike(getTarget() != null ? getTarget(): item);
    }

    public String getValue() {
        return this.value;
    }

    public A withValue(String value) {
        this.value=value; return (A) this;
    }

    public Boolean hasValue() {
        return this.value != null;
    }

    public A withNewValue(StringBuilder arg1) {
        return (A)withValue(new String(arg1));
    }

    public A withNewValue(int[] arg1,int arg2,int arg3) {
        return (A)withValue(new String(arg1, arg2, arg3));
    }

    public A withNewValue(char[] arg1) {
        return (A)withValue(new String(arg1));
    }

    public A withNewValue(StringBuffer arg1) {
        return (A)withValue(new String(arg1));
    }

    public A withNewValue(byte[] arg1,int arg2) {
        return (A)withValue(new String(arg1, arg2));
    }

    public A withNewValue(byte[] arg1) {
        return (A)withValue(new String(arg1));
    }

    public A withNewValue(char[] arg1,int arg2,int arg3) {
        return (A)withValue(new String(arg1, arg2, arg3));
    }

    public A withNewValue(byte[] arg1,int arg2,int arg3) {
        return (A)withValue(new String(arg1, arg2, arg3));
    }

    public A withNewValue(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withValue(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewValue(String arg1) {
        return (A)withValue(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        NetworkChaosSpecFluentImpl that = (NetworkChaosSpecFluentImpl) o;
        if (action != null ? !action.equals(that.action) :that.action != null) return false;
        if (bandwidth != null ? !bandwidth.equals(that.bandwidth) :that.bandwidth != null) return false;
        if (corrupt != null ? !corrupt.equals(that.corrupt) :that.corrupt != null) return false;
        if (delay != null ? !delay.equals(that.delay) :that.delay != null) return false;
        if (direction != null ? !direction.equals(that.direction) :that.direction != null) return false;
        if (duplicate != null ? !duplicate.equals(that.duplicate) :that.duplicate != null) return false;
        if (duration != null ? !duration.equals(that.duration) :that.duration != null) return false;
        if (externalTargets != null ? !externalTargets.equals(that.externalTargets) :that.externalTargets != null) return false;
        if (loss != null ? !loss.equals(that.loss) :that.loss != null) return false;
        if (mode != null ? !mode.equals(that.mode) :that.mode != null) return false;
        if (scheduler != null ? !scheduler.equals(that.scheduler) :that.scheduler != null) return false;
        if (selector != null ? !selector.equals(that.selector) :that.selector != null) return false;
        if (target != null ? !target.equals(that.target) :that.target != null) return false;
        if (value != null ? !value.equals(that.value) :that.value != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(action,  bandwidth,  corrupt,  delay,  direction,  duplicate,  duration,  externalTargets,  loss,  mode,  scheduler,  selector,  target,  value,  super.hashCode());
    }

    public class BandwidthNestedImpl<N> extends BandwidthSpecFluentImpl<NetworkChaosSpecFluent.BandwidthNested<N>> implements NetworkChaosSpecFluent.BandwidthNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final BandwidthSpecBuilder builder;

            BandwidthNestedImpl(BandwidthSpec item) {
                this.builder = new BandwidthSpecBuilder(this, item);
                        
            }

            BandwidthNestedImpl() {
                this.builder = new BandwidthSpecBuilder(this);
                        
            }

            public N and() {
                return (N) NetworkChaosSpecFluentImpl.this.withBandwidth(builder.build());
            }

            public N endBandwidth() {
                return and();
            }
    }


    public class CorruptNestedImpl<N> extends CorruptSpecFluentImpl<NetworkChaosSpecFluent.CorruptNested<N>> implements NetworkChaosSpecFluent.CorruptNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final CorruptSpecBuilder builder;

            CorruptNestedImpl(CorruptSpec item) {
                this.builder = new CorruptSpecBuilder(this, item);
                        
            }

            CorruptNestedImpl() {
                this.builder = new CorruptSpecBuilder(this);
                        
            }

            public N and() {
                return (N) NetworkChaosSpecFluentImpl.this.withCorrupt(builder.build());
            }

            public N endCorrupt() {
                return and();
            }
    }


    public class DelayNestedImpl<N> extends DelaySpecFluentImpl<NetworkChaosSpecFluent.DelayNested<N>> implements NetworkChaosSpecFluent.DelayNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final DelaySpecBuilder builder;

            DelayNestedImpl(DelaySpec item) {
                this.builder = new DelaySpecBuilder(this, item);
                        
            }

            DelayNestedImpl() {
                this.builder = new DelaySpecBuilder(this);
                        
            }

            public N and() {
                return (N) NetworkChaosSpecFluentImpl.this.withDelay(builder.build());
            }

            public N endDelay() {
                return and();
            }
    }


    public class DuplicateNestedImpl<N> extends DuplicateSpecFluentImpl<NetworkChaosSpecFluent.DuplicateNested<N>> implements NetworkChaosSpecFluent.DuplicateNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final DuplicateSpecBuilder builder;

            DuplicateNestedImpl(DuplicateSpec item) {
                this.builder = new DuplicateSpecBuilder(this, item);
                        
            }

            DuplicateNestedImpl() {
                this.builder = new DuplicateSpecBuilder(this);
                        
            }

            public N and() {
                return (N) NetworkChaosSpecFluentImpl.this.withDuplicate(builder.build());
            }

            public N endDuplicate() {
                return and();
            }
    }


    public class LossNestedImpl<N> extends LossSpecFluentImpl<NetworkChaosSpecFluent.LossNested<N>> implements NetworkChaosSpecFluent.LossNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final LossSpecBuilder builder;

            LossNestedImpl(LossSpec item) {
                this.builder = new LossSpecBuilder(this, item);
                        
            }

            LossNestedImpl() {
                this.builder = new LossSpecBuilder(this);
                        
            }

            public N and() {
                return (N) NetworkChaosSpecFluentImpl.this.withLoss(builder.build());
            }

            public N endLoss() {
                return and();
            }
    }


    public class SchedulerNestedImpl<N> extends SchedulerSpecFluentImpl<NetworkChaosSpecFluent.SchedulerNested<N>> implements NetworkChaosSpecFluent.SchedulerNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final SchedulerSpecBuilder builder;

            SchedulerNestedImpl(SchedulerSpec item) {
                this.builder = new SchedulerSpecBuilder(this, item);
                        
            }

            SchedulerNestedImpl() {
                this.builder = new SchedulerSpecBuilder(this);
                        
            }

            public N and() {
                return (N) NetworkChaosSpecFluentImpl.this.withScheduler(builder.build());
            }

            public N endScheduler() {
                return and();
            }
    }


    public class SelectorNestedImpl<N> extends SelectorSpecFluentImpl<NetworkChaosSpecFluent.SelectorNested<N>> implements NetworkChaosSpecFluent.SelectorNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final SelectorSpecBuilder builder;

            SelectorNestedImpl(SelectorSpec item) {
                this.builder = new SelectorSpecBuilder(this, item);
                        
            }

            SelectorNestedImpl() {
                this.builder = new SelectorSpecBuilder(this);
                        
            }

            public N and() {
                return (N) NetworkChaosSpecFluentImpl.this.withSelector(builder.build());
            }

            public N endSelector() {
                return and();
            }
    }


    public class TargetNestedImpl<N> extends TargetFluentImpl<NetworkChaosSpecFluent.TargetNested<N>> implements NetworkChaosSpecFluent.TargetNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final TargetBuilder builder;

            TargetNestedImpl(Target item) {
                this.builder = new TargetBuilder(this, item);
                        
            }

            TargetNestedImpl() {
                this.builder = new TargetBuilder(this);
                        
            }

            public N and() {
                return (N) NetworkChaosSpecFluentImpl.this.withTarget(builder.build());
            }

            public N endTarget() {
                return and();
            }
    }


}
