package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class NetworkChaosBuilder extends NetworkChaosFluentImpl<NetworkChaosBuilder> implements VisitableBuilder<NetworkChaos,NetworkChaosBuilder> {

    NetworkChaosFluent<?> fluent;
    Boolean validationEnabled;

    public NetworkChaosBuilder() {
        this(true);
    }

    public NetworkChaosBuilder(Boolean validationEnabled) {
        this(new NetworkChaos(), validationEnabled);
    }

    public NetworkChaosBuilder(NetworkChaosFluent<?> fluent) {
        this(fluent, true);
    }

    public NetworkChaosBuilder(NetworkChaosFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new NetworkChaos(), validationEnabled);
    }

    public NetworkChaosBuilder(NetworkChaosFluent<?> fluent,NetworkChaos instance) {
        this(fluent, instance, true);
    }

    public NetworkChaosBuilder(NetworkChaosFluent<?> fluent,NetworkChaos instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion()); 
        fluent.withKind(instance.getKind()); 
        fluent.withMetadata(instance.getMetadata()); 
        fluent.withSpec(instance.getSpec()); 
        fluent.withStatus(instance.getStatus()); 
        this.validationEnabled = validationEnabled; 
    }

    public NetworkChaosBuilder(NetworkChaos instance) {
        this(instance,true);
    }

    public NetworkChaosBuilder(NetworkChaos instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.withSpec(instance.getSpec()); 
        this.withStatus(instance.getStatus()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.chaosmesh.v1alpha1.EditableNetworkChaos build() {
        EditableNetworkChaos buildable = new EditableNetworkChaos(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        NetworkChaosBuilder that = (NetworkChaosBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
