package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class JVMScriptSpecBuilder extends JVMScriptSpecFluentImpl<JVMScriptSpecBuilder> implements VisitableBuilder<JVMScriptSpec,JVMScriptSpecBuilder> {

    JVMScriptSpecFluent<?> fluent;
    Boolean validationEnabled;

    public JVMScriptSpecBuilder() {
        this(true);
    }

    public JVMScriptSpecBuilder(Boolean validationEnabled) {
        this(new JVMScriptSpec(), validationEnabled);
    }

    public JVMScriptSpecBuilder(JVMScriptSpecFluent<?> fluent) {
        this(fluent, true);
    }

    public JVMScriptSpecBuilder(JVMScriptSpecFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new JVMScriptSpec(), validationEnabled);
    }

    public JVMScriptSpecBuilder(JVMScriptSpecFluent<?> fluent,JVMScriptSpec instance) {
        this(fluent, instance, true);
    }

    public JVMScriptSpecBuilder(JVMScriptSpecFluent<?> fluent,JVMScriptSpec instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withAfter(instance.getAfter()); 
        fluent.withClassname(instance.getClassname()); 
        fluent.withContent(instance.getContent()); 
        fluent.withFile(instance.getFile()); 
        fluent.withMethodname(instance.getMethodname()); 
        fluent.withName(instance.getName()); 
        fluent.withType(instance.getType()); 
        this.validationEnabled = validationEnabled; 
    }

    public JVMScriptSpecBuilder(JVMScriptSpec instance) {
        this(instance,true);
    }

    public JVMScriptSpecBuilder(JVMScriptSpec instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withAfter(instance.getAfter()); 
        this.withClassname(instance.getClassname()); 
        this.withContent(instance.getContent()); 
        this.withFile(instance.getFile()); 
        this.withMethodname(instance.getMethodname()); 
        this.withName(instance.getName()); 
        this.withType(instance.getType()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.chaosmesh.v1alpha1.EditableJVMScriptSpec build() {
        EditableJVMScriptSpec buildable = new EditableJVMScriptSpec(fluent.getAfter(),fluent.getClassname(),fluent.getContent(),fluent.getFile(),fluent.getMethodname(),fluent.getName(),fluent.getType());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        JVMScriptSpecBuilder that = (JVMScriptSpecBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
