package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class JVMDelaySpecBuilder extends JVMDelaySpecFluentImpl<JVMDelaySpecBuilder> implements VisitableBuilder<JVMDelaySpec,JVMDelaySpecBuilder> {

    JVMDelaySpecFluent<?> fluent;
    Boolean validationEnabled;

    public JVMDelaySpecBuilder() {
        this(true);
    }

    public JVMDelaySpecBuilder(Boolean validationEnabled) {
        this(new JVMDelaySpec(), validationEnabled);
    }

    public JVMDelaySpecBuilder(JVMDelaySpecFluent<?> fluent) {
        this(fluent, true);
    }

    public JVMDelaySpecBuilder(JVMDelaySpecFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new JVMDelaySpec(), validationEnabled);
    }

    public JVMDelaySpecBuilder(JVMDelaySpecFluent<?> fluent,JVMDelaySpec instance) {
        this(fluent, instance, true);
    }

    public JVMDelaySpecBuilder(JVMDelaySpecFluent<?> fluent,JVMDelaySpec instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withAfter(instance.getAfter()); 
        fluent.withClassname(instance.getClassname()); 
        fluent.withMethodname(instance.getMethodname()); 
        fluent.withOffset(instance.getOffset()); 
        fluent.withTime(instance.getTime()); 
        this.validationEnabled = validationEnabled; 
    }

    public JVMDelaySpecBuilder(JVMDelaySpec instance) {
        this(instance,true);
    }

    public JVMDelaySpecBuilder(JVMDelaySpec instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withAfter(instance.getAfter()); 
        this.withClassname(instance.getClassname()); 
        this.withMethodname(instance.getMethodname()); 
        this.withOffset(instance.getOffset()); 
        this.withTime(instance.getTime()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.chaosmesh.v1alpha1.EditableJVMDelaySpec build() {
        EditableJVMDelaySpec buildable = new EditableJVMDelaySpec(fluent.getAfter(),fluent.getClassname(),fluent.getMethodname(),fluent.getOffset(),fluent.getTime());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        JVMDelaySpecBuilder that = (JVMDelaySpecBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
