package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class IoChaosListBuilder extends IoChaosListFluentImpl<IoChaosListBuilder> implements VisitableBuilder<IoChaosList,IoChaosListBuilder> {

    IoChaosListFluent<?> fluent;
    Boolean validationEnabled;

    public IoChaosListBuilder() {
        this(true);
    }

    public IoChaosListBuilder(Boolean validationEnabled) {
        this(new IoChaosList(), validationEnabled);
    }

    public IoChaosListBuilder(IoChaosListFluent<?> fluent) {
        this(fluent, true);
    }

    public IoChaosListBuilder(IoChaosListFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new IoChaosList(), validationEnabled);
    }

    public IoChaosListBuilder(IoChaosListFluent<?> fluent,IoChaosList instance) {
        this(fluent, instance, true);
    }

    public IoChaosListBuilder(IoChaosListFluent<?> fluent,IoChaosList instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion()); 
        fluent.withItems(instance.getItems()); 
        fluent.withKind(instance.getKind()); 
        fluent.withMetadata(instance.getMetadata()); 
        this.validationEnabled = validationEnabled; 
    }

    public IoChaosListBuilder(IoChaosList instance) {
        this(instance,true);
    }

    public IoChaosListBuilder(IoChaosList instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion()); 
        this.withItems(instance.getItems()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.chaosmesh.v1alpha1.EditableIoChaosList build() {
        EditableIoChaosList buildable = new EditableIoChaosList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        IoChaosListBuilder that = (IoChaosListBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
