package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ListMeta;
import java.util.function.Predicate;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import java.lang.Long;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

public interface HTTPChaosListFluent<A extends HTTPChaosListFluent<A>> extends Fluent<A> {


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A withNewApiVersion(StringBuilder arg1);
    public A withNewApiVersion(int[] arg1,int arg2,int arg3);
    public A withNewApiVersion(char[] arg1);
    public A withNewApiVersion(StringBuffer arg1);
    public A withNewApiVersion(byte[] arg1,int arg2);
    public A withNewApiVersion(byte[] arg1);
    public A withNewApiVersion(char[] arg1,int arg2,int arg3);
    public A withNewApiVersion(byte[] arg1,int arg2,int arg3);
    public A withNewApiVersion(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewApiVersion(String arg1);
    public A addToItems(int index,HTTPChaos item);
    public A setToItems(int index,HTTPChaos item);
    public A addToItems(HTTPChaos... items);
    public A addAllToItems(Collection<HTTPChaos> items);
    public A removeFromItems(HTTPChaos... items);
    public A removeAllFromItems(Collection<HTTPChaos> items);
    public A removeMatchingFromItems(Predicate<HTTPChaosBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildItems instead.
 * @return The buildable object.
 */
@Deprecated public List<HTTPChaos> getItems();
    public List<HTTPChaos> buildItems();
    public HTTPChaos buildItem(int index);
    public HTTPChaos buildFirstItem();
    public HTTPChaos buildLastItem();
    public HTTPChaos buildMatchingItem(Predicate<HTTPChaosBuilder> predicate);
    public Boolean hasMatchingItem(Predicate<HTTPChaosBuilder> predicate);
    public A withItems(List<HTTPChaos> items);
    public A withItems(HTTPChaos... items);
    public Boolean hasItems();
    public HTTPChaosListFluent.ItemsNested<A> addNewItem();
    public HTTPChaosListFluent.ItemsNested<A> addNewItemLike(HTTPChaos item);
    public HTTPChaosListFluent.ItemsNested<A> setNewItemLike(int index,HTTPChaos item);
    public HTTPChaosListFluent.ItemsNested<A> editItem(int index);
    public HTTPChaosListFluent.ItemsNested<A> editFirstItem();
    public HTTPChaosListFluent.ItemsNested<A> editLastItem();
    public HTTPChaosListFluent.ItemsNested<A> editMatchingItem(Predicate<HTTPChaosBuilder> predicate);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public A withNewKind(StringBuilder arg1);
    public A withNewKind(int[] arg1,int arg2,int arg3);
    public A withNewKind(char[] arg1);
    public A withNewKind(StringBuffer arg1);
    public A withNewKind(byte[] arg1,int arg2);
    public A withNewKind(byte[] arg1);
    public A withNewKind(char[] arg1,int arg2,int arg3);
    public A withNewKind(byte[] arg1,int arg2,int arg3);
    public A withNewKind(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewKind(String arg1);
    public ListMeta getMetadata();
    public A withMetadata(ListMeta metadata);
    public Boolean hasMetadata();
    public A withNewMetadata(String _continue,Long remainingItemCount,String resourceVersion,String selfLink);
    public interface ItemsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,HTTPChaosFluent<HTTPChaosListFluent.ItemsNested<N>> {

            public N and();
            public N endItem();    }


}
