package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class DNSChaosSpecBuilder extends DNSChaosSpecFluentImpl<DNSChaosSpecBuilder> implements VisitableBuilder<DNSChaosSpec,DNSChaosSpecBuilder> {

    DNSChaosSpecFluent<?> fluent;
    Boolean validationEnabled;

    public DNSChaosSpecBuilder() {
        this(true);
    }

    public DNSChaosSpecBuilder(Boolean validationEnabled) {
        this(new DNSChaosSpec(), validationEnabled);
    }

    public DNSChaosSpecBuilder(DNSChaosSpecFluent<?> fluent) {
        this(fluent, true);
    }

    public DNSChaosSpecBuilder(DNSChaosSpecFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new DNSChaosSpec(), validationEnabled);
    }

    public DNSChaosSpecBuilder(DNSChaosSpecFluent<?> fluent,DNSChaosSpec instance) {
        this(fluent, instance, true);
    }

    public DNSChaosSpecBuilder(DNSChaosSpecFluent<?> fluent,DNSChaosSpec instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withAction(instance.getAction()); 
        fluent.withDuration(instance.getDuration()); 
        fluent.withMode(instance.getMode()); 
        fluent.withScheduler(instance.getScheduler()); 
        fluent.withScope(instance.getScope()); 
        fluent.withSelector(instance.getSelector()); 
        fluent.withValue(instance.getValue()); 
        this.validationEnabled = validationEnabled; 
    }

    public DNSChaosSpecBuilder(DNSChaosSpec instance) {
        this(instance,true);
    }

    public DNSChaosSpecBuilder(DNSChaosSpec instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withAction(instance.getAction()); 
        this.withDuration(instance.getDuration()); 
        this.withMode(instance.getMode()); 
        this.withScheduler(instance.getScheduler()); 
        this.withScope(instance.getScope()); 
        this.withSelector(instance.getSelector()); 
        this.withValue(instance.getValue()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.chaosmesh.v1alpha1.EditableDNSChaosSpec build() {
        EditableDNSChaosSpec buildable = new EditableDNSChaosSpec(fluent.getAction(),fluent.getDuration(),fluent.getMode(),fluent.getScheduler(),fluent.getScope(),fluent.getSelector(),fluent.getValue());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        DNSChaosSpecBuilder that = (DNSChaosSpecBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
