package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class DNSChaosBuilder extends DNSChaosFluentImpl<DNSChaosBuilder> implements VisitableBuilder<DNSChaos,DNSChaosBuilder> {

    DNSChaosFluent<?> fluent;
    Boolean validationEnabled;

    public DNSChaosBuilder() {
        this(true);
    }

    public DNSChaosBuilder(Boolean validationEnabled) {
        this(new DNSChaos(), validationEnabled);
    }

    public DNSChaosBuilder(DNSChaosFluent<?> fluent) {
        this(fluent, true);
    }

    public DNSChaosBuilder(DNSChaosFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new DNSChaos(), validationEnabled);
    }

    public DNSChaosBuilder(DNSChaosFluent<?> fluent,DNSChaos instance) {
        this(fluent, instance, true);
    }

    public DNSChaosBuilder(DNSChaosFluent<?> fluent,DNSChaos instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion()); 
        fluent.withKind(instance.getKind()); 
        fluent.withMetadata(instance.getMetadata()); 
        fluent.withSpec(instance.getSpec()); 
        fluent.withStatus(instance.getStatus()); 
        this.validationEnabled = validationEnabled; 
    }

    public DNSChaosBuilder(DNSChaos instance) {
        this(instance,true);
    }

    public DNSChaosBuilder(DNSChaos instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.withSpec(instance.getSpec()); 
        this.withStatus(instance.getStatus()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.chaosmesh.v1alpha1.EditableDNSChaos build() {
        EditableDNSChaos buildable = new EditableDNSChaos(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        DNSChaosBuilder that = (DNSChaosBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
