package io.fabric8.chaosmesh.v1alpha1;

import java.lang.Integer;
import java.lang.StringBuffer;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Long;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;

public class BandwidthSpecFluentImpl<A extends BandwidthSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements BandwidthSpecFluent<A> {

    private Integer buffer;
    private Integer limit;
    private Long minburst;
    private Long peakrate;
    private String rate;

    public BandwidthSpecFluentImpl() {
    }

    public BandwidthSpecFluentImpl(BandwidthSpec instance) {
        this.withBuffer(instance.getBuffer()); 
        this.withLimit(instance.getLimit()); 
        this.withMinburst(instance.getMinburst()); 
        this.withPeakrate(instance.getPeakrate()); 
        this.withRate(instance.getRate()); 
    }

    public Integer getBuffer() {
        return this.buffer;
    }

    public A withBuffer(Integer buffer) {
        this.buffer=buffer; return (A) this;
    }

    public Boolean hasBuffer() {
        return this.buffer != null;
    }

    public A withNewBuffer(int arg1) {
        return (A)withBuffer(new Integer(arg1));
    }

    public Integer getLimit() {
        return this.limit;
    }

    public A withLimit(Integer limit) {
        this.limit=limit; return (A) this;
    }

    public Boolean hasLimit() {
        return this.limit != null;
    }

    public A withNewLimit(int arg1) {
        return (A)withLimit(new Integer(arg1));
    }

    public Long getMinburst() {
        return this.minburst;
    }

    public A withMinburst(Long minburst) {
        this.minburst=minburst; return (A) this;
    }

    public Boolean hasMinburst() {
        return this.minburst != null;
    }

    public A withNewMinburst(long arg1) {
        return (A)withMinburst(new Long(arg1));
    }

    public Long getPeakrate() {
        return this.peakrate;
    }

    public A withPeakrate(Long peakrate) {
        this.peakrate=peakrate; return (A) this;
    }

    public Boolean hasPeakrate() {
        return this.peakrate != null;
    }

    public A withNewPeakrate(long arg1) {
        return (A)withPeakrate(new Long(arg1));
    }

    public String getRate() {
        return this.rate;
    }

    public A withRate(String rate) {
        this.rate=rate; return (A) this;
    }

    public Boolean hasRate() {
        return this.rate != null;
    }

    public A withNewRate(StringBuilder arg1) {
        return (A)withRate(new String(arg1));
    }

    public A withNewRate(int[] arg1,int arg2,int arg3) {
        return (A)withRate(new String(arg1, arg2, arg3));
    }

    public A withNewRate(char[] arg1) {
        return (A)withRate(new String(arg1));
    }

    public A withNewRate(StringBuffer arg1) {
        return (A)withRate(new String(arg1));
    }

    public A withNewRate(byte[] arg1,int arg2) {
        return (A)withRate(new String(arg1, arg2));
    }

    public A withNewRate(byte[] arg1) {
        return (A)withRate(new String(arg1));
    }

    public A withNewRate(char[] arg1,int arg2,int arg3) {
        return (A)withRate(new String(arg1, arg2, arg3));
    }

    public A withNewRate(byte[] arg1,int arg2,int arg3) {
        return (A)withRate(new String(arg1, arg2, arg3));
    }

    public A withNewRate(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withRate(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewRate(String arg1) {
        return (A)withRate(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        BandwidthSpecFluentImpl that = (BandwidthSpecFluentImpl) o;
        if (buffer != null ? !buffer.equals(that.buffer) :that.buffer != null) return false;
        if (limit != null ? !limit.equals(that.limit) :that.limit != null) return false;
        if (minburst != null ? !minburst.equals(that.minburst) :that.minburst != null) return false;
        if (peakrate != null ? !peakrate.equals(that.peakrate) :that.peakrate != null) return false;
        if (rate != null ? !rate.equals(that.rate) :that.rate != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(buffer,  limit,  minburst,  peakrate,  rate,  super.hashCode());
    }

}
