package io.fabric8.chaosmesh.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ChaosmeshSchemaBuilder extends ChaosmeshSchemaFluentImpl<ChaosmeshSchemaBuilder> implements VisitableBuilder<ChaosmeshSchema,ChaosmeshSchemaBuilder> {

    ChaosmeshSchemaFluent<?> fluent;
    Boolean validationEnabled;

    public ChaosmeshSchemaBuilder() {
        this(true);
    }

    public ChaosmeshSchemaBuilder(Boolean validationEnabled) {
        this(new ChaosmeshSchema(), validationEnabled);
    }

    public ChaosmeshSchemaBuilder(ChaosmeshSchemaFluent<?> fluent) {
        this(fluent, true);
    }

    public ChaosmeshSchemaBuilder(ChaosmeshSchemaFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new ChaosmeshSchema(), validationEnabled);
    }

    public ChaosmeshSchemaBuilder(ChaosmeshSchemaFluent<?> fluent,ChaosmeshSchema instance) {
        this(fluent, instance, true);
    }

    public ChaosmeshSchemaBuilder(ChaosmeshSchemaFluent<?> fluent,ChaosmeshSchema instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withGithubComChaosMeshChaosMeshApiV1alpha1AttrOverrideSpec(instance.getGithubComChaosMeshChaosMeshApiV1alpha1AttrOverrideSpec()); 
        fluent.withGithubComChaosMeshChaosMeshApiV1alpha1BandwidthSpec(instance.getGithubComChaosMeshChaosMeshApiV1alpha1BandwidthSpec()); 
        fluent.withGithubComChaosMeshChaosMeshApiV1alpha1CPUStressor(instance.getGithubComChaosMeshChaosMeshApiV1alpha1CPUStressor()); 
        fluent.withGithubComChaosMeshChaosMeshApiV1alpha1CorruptSpec(instance.getGithubComChaosMeshChaosMeshApiV1alpha1CorruptSpec()); 
        fluent.withGithubComChaosMeshChaosMeshApiV1alpha1DNSChaos(instance.getGithubComChaosMeshChaosMeshApiV1alpha1DNSChaos()); 
        fluent.withGithubComChaosMeshChaosMeshApiV1alpha1DNSChaosList(instance.getGithubComChaosMeshChaosMeshApiV1alpha1DNSChaosList()); 
        fluent.withGithubComChaosMeshChaosMeshApiV1alpha1DNSChaosSpec(instance.getGithubComChaosMeshChaosMeshApiV1alpha1DNSChaosSpec()); 
        fluent.withGithubComChaosMeshChaosMeshApiV1alpha1DNSChaosStatus(instance.getGithubComChaosMeshChaosMeshApiV1alpha1DNSChaosStatus()); 
        fluent.withGithubComChaosMeshChaosMeshApiV1alpha1DelaySpec(instance.getGithubComChaosMeshChaosMeshApiV1alpha1DelaySpec()); 
        fluent.withGithubComChaosMeshChaosMeshApiV1alpha1DuplicateSpec(instance.getGithubComChaosMeshChaosMeshApiV1alpha1DuplicateSpec()); 
        fluent.withGithubComChaosMeshChaosMeshApiV1alpha1ExperimentStatus(instance.getGithubComChaosMeshChaosMeshApiV1alpha1ExperimentStatus()); 
        fluent.withGithubComChaosMeshChaosMeshApiV1alpha1FailKernRequest(instance.getGithubComChaosMeshChaosMeshApiV1alpha1FailKernRequest()); 
        fluent.withGithubComChaosMeshChaosMeshApiV1alpha1Frame(instance.getGithubComChaosMeshChaosMeshApiV1alpha1Frame()); 
        fluent.withGithubComChaosMeshChaosMeshApiV1alpha1HTTPChaos(instance.getGithubComChaosMeshChaosMeshApiV1alpha1HTTPChaos()); 
        fluent.withGithubComChaosMeshChaosMeshApiV1alpha1HTTPChaosList(instance.getGithubComChaosMeshChaosMeshApiV1alpha1HTTPChaosList()); 
        fluent.withGithubComChaosMeshChaosMeshApiV1alpha1HTTPChaosSpec(instance.getGithubComChaosMeshChaosMeshApiV1alpha1HTTPChaosSpec()); 
        fluent.withGithubComChaosMeshChaosMeshApiV1alpha1HTTPChaosStatus(instance.getGithubComChaosMeshChaosMeshApiV1alpha1HTTPChaosStatus()); 
        fluent.withGithubComChaosMeshChaosMeshApiV1alpha1IoChaos(instance.getGithubComChaosMeshChaosMeshApiV1alpha1IoChaos()); 
        fluent.withGithubComChaosMeshChaosMeshApiV1alpha1IoChaosAction(instance.getGithubComChaosMeshChaosMeshApiV1alpha1IoChaosAction()); 
        fluent.withGithubComChaosMeshChaosMeshApiV1alpha1IoChaosList(instance.getGithubComChaosMeshChaosMeshApiV1alpha1IoChaosList()); 
        fluent.withGithubComChaosMeshChaosMeshApiV1alpha1IoChaosSpec(instance.getGithubComChaosMeshChaosMeshApiV1alpha1IoChaosSpec()); 
        fluent.withGithubComChaosMeshChaosMeshApiV1alpha1IoChaosStatus(instance.getGithubComChaosMeshChaosMeshApiV1alpha1IoChaosStatus()); 
        fluent.withGithubComChaosMeshChaosMeshApiV1alpha1IoFault(instance.getGithubComChaosMeshChaosMeshApiV1alpha1IoFault()); 
        fluent.withGithubComChaosMeshChaosMeshApiV1alpha1JVMChaos(instance.getGithubComChaosMeshChaosMeshApiV1alpha1JVMChaos()); 
        fluent.withGithubComChaosMeshChaosMeshApiV1alpha1JVMChaosList(instance.getGithubComChaosMeshChaosMeshApiV1alpha1JVMChaosList()); 
        fluent.withGithubComChaosMeshChaosMeshApiV1alpha1JVMChaosSpec(instance.getGithubComChaosMeshChaosMeshApiV1alpha1JVMChaosSpec()); 
        fluent.withGithubComChaosMeshChaosMeshApiV1alpha1JVMChaosStatus(instance.getGithubComChaosMeshChaosMeshApiV1alpha1JVMChaosStatus()); 
        fluent.withGithubComChaosMeshChaosMeshApiV1alpha1JVMCpufullloadSpec(instance.getGithubComChaosMeshChaosMeshApiV1alpha1JVMCpufullloadSpec()); 
        fluent.withGithubComChaosMeshChaosMeshApiV1alpha1JVMDelaySpec(instance.getGithubComChaosMeshChaosMeshApiV1alpha1JVMDelaySpec()); 
        fluent.withGithubComChaosMeshChaosMeshApiV1alpha1JVMExceptionSpec(instance.getGithubComChaosMeshChaosMeshApiV1alpha1JVMExceptionSpec()); 
        fluent.withGithubComChaosMeshChaosMeshApiV1alpha1JVMOOMSpec(instance.getGithubComChaosMeshChaosMeshApiV1alpha1JVMOOMSpec()); 
        fluent.withGithubComChaosMeshChaosMeshApiV1alpha1JVMReturnSpec(instance.getGithubComChaosMeshChaosMeshApiV1alpha1JVMReturnSpec()); 
        fluent.withGithubComChaosMeshChaosMeshApiV1alpha1JVMScriptSpec(instance.getGithubComChaosMeshChaosMeshApiV1alpha1JVMScriptSpec()); 
        fluent.withGithubComChaosMeshChaosMeshApiV1alpha1KernelChaos(instance.getGithubComChaosMeshChaosMeshApiV1alpha1KernelChaos()); 
        fluent.withGithubComChaosMeshChaosMeshApiV1alpha1KernelChaosList(instance.getGithubComChaosMeshChaosMeshApiV1alpha1KernelChaosList()); 
        fluent.withGithubComChaosMeshChaosMeshApiV1alpha1KernelChaosSpec(instance.getGithubComChaosMeshChaosMeshApiV1alpha1KernelChaosSpec()); 
        fluent.withGithubComChaosMeshChaosMeshApiV1alpha1KernelChaosStatus(instance.getGithubComChaosMeshChaosMeshApiV1alpha1KernelChaosStatus()); 
        fluent.withGithubComChaosMeshChaosMeshApiV1alpha1LossSpec(instance.getGithubComChaosMeshChaosMeshApiV1alpha1LossSpec()); 
        fluent.withGithubComChaosMeshChaosMeshApiV1alpha1Matcher(instance.getGithubComChaosMeshChaosMeshApiV1alpha1Matcher()); 
        fluent.withGithubComChaosMeshChaosMeshApiV1alpha1MemoryStressor(instance.getGithubComChaosMeshChaosMeshApiV1alpha1MemoryStressor()); 
        fluent.withGithubComChaosMeshChaosMeshApiV1alpha1NetworkChaos(instance.getGithubComChaosMeshChaosMeshApiV1alpha1NetworkChaos()); 
        fluent.withGithubComChaosMeshChaosMeshApiV1alpha1NetworkChaosList(instance.getGithubComChaosMeshChaosMeshApiV1alpha1NetworkChaosList()); 
        fluent.withGithubComChaosMeshChaosMeshApiV1alpha1NetworkChaosSpec(instance.getGithubComChaosMeshChaosMeshApiV1alpha1NetworkChaosSpec()); 
        fluent.withGithubComChaosMeshChaosMeshApiV1alpha1NetworkChaosStatus(instance.getGithubComChaosMeshChaosMeshApiV1alpha1NetworkChaosStatus()); 
        fluent.withGithubComChaosMeshChaosMeshApiV1alpha1PodChaos(instance.getGithubComChaosMeshChaosMeshApiV1alpha1PodChaos()); 
        fluent.withGithubComChaosMeshChaosMeshApiV1alpha1PodChaosList(instance.getGithubComChaosMeshChaosMeshApiV1alpha1PodChaosList()); 
        fluent.withGithubComChaosMeshChaosMeshApiV1alpha1PodChaosSpec(instance.getGithubComChaosMeshChaosMeshApiV1alpha1PodChaosSpec()); 
        fluent.withGithubComChaosMeshChaosMeshApiV1alpha1PodChaosStatus(instance.getGithubComChaosMeshChaosMeshApiV1alpha1PodChaosStatus()); 
        fluent.withGithubComChaosMeshChaosMeshApiV1alpha1PodIoChaos(instance.getGithubComChaosMeshChaosMeshApiV1alpha1PodIoChaos()); 
        fluent.withGithubComChaosMeshChaosMeshApiV1alpha1PodIoChaosList(instance.getGithubComChaosMeshChaosMeshApiV1alpha1PodIoChaosList()); 
        fluent.withGithubComChaosMeshChaosMeshApiV1alpha1PodIoChaosSpec(instance.getGithubComChaosMeshChaosMeshApiV1alpha1PodIoChaosSpec()); 
        fluent.withGithubComChaosMeshChaosMeshApiV1alpha1PodNetworkChaos(instance.getGithubComChaosMeshChaosMeshApiV1alpha1PodNetworkChaos()); 
        fluent.withGithubComChaosMeshChaosMeshApiV1alpha1PodNetworkChaosList(instance.getGithubComChaosMeshChaosMeshApiV1alpha1PodNetworkChaosList()); 
        fluent.withGithubComChaosMeshChaosMeshApiV1alpha1PodNetworkChaosSpec(instance.getGithubComChaosMeshChaosMeshApiV1alpha1PodNetworkChaosSpec()); 
        fluent.withGithubComChaosMeshChaosMeshApiV1alpha1PodNetworkChaosStatus(instance.getGithubComChaosMeshChaosMeshApiV1alpha1PodNetworkChaosStatus()); 
        fluent.withGithubComChaosMeshChaosMeshApiV1alpha1PodStatus(instance.getGithubComChaosMeshChaosMeshApiV1alpha1PodStatus()); 
        fluent.withGithubComChaosMeshChaosMeshApiV1alpha1RawIPSet(instance.getGithubComChaosMeshChaosMeshApiV1alpha1RawIPSet()); 
        fluent.withGithubComChaosMeshChaosMeshApiV1alpha1RawIptables(instance.getGithubComChaosMeshChaosMeshApiV1alpha1RawIptables()); 
        fluent.withGithubComChaosMeshChaosMeshApiV1alpha1RawTrafficControl(instance.getGithubComChaosMeshChaosMeshApiV1alpha1RawTrafficControl()); 
        fluent.withGithubComChaosMeshChaosMeshApiV1alpha1ReorderSpec(instance.getGithubComChaosMeshChaosMeshApiV1alpha1ReorderSpec()); 
        fluent.withGithubComChaosMeshChaosMeshApiV1alpha1ScheduleStatus(instance.getGithubComChaosMeshChaosMeshApiV1alpha1ScheduleStatus()); 
        fluent.withGithubComChaosMeshChaosMeshApiV1alpha1SchedulerSpec(instance.getGithubComChaosMeshChaosMeshApiV1alpha1SchedulerSpec()); 
        fluent.withGithubComChaosMeshChaosMeshApiV1alpha1SelectorSpec(instance.getGithubComChaosMeshChaosMeshApiV1alpha1SelectorSpec()); 
        fluent.withGithubComChaosMeshChaosMeshApiV1alpha1ServletDelaySpec(instance.getGithubComChaosMeshChaosMeshApiV1alpha1ServletDelaySpec()); 
        fluent.withGithubComChaosMeshChaosMeshApiV1alpha1ServletExceptionSpec(instance.getGithubComChaosMeshChaosMeshApiV1alpha1ServletExceptionSpec()); 
        fluent.withGithubComChaosMeshChaosMeshApiV1alpha1StressChaos(instance.getGithubComChaosMeshChaosMeshApiV1alpha1StressChaos()); 
        fluent.withGithubComChaosMeshChaosMeshApiV1alpha1StressChaosList(instance.getGithubComChaosMeshChaosMeshApiV1alpha1StressChaosList()); 
        fluent.withGithubComChaosMeshChaosMeshApiV1alpha1StressChaosSpec(instance.getGithubComChaosMeshChaosMeshApiV1alpha1StressChaosSpec()); 
        fluent.withGithubComChaosMeshChaosMeshApiV1alpha1StressChaosStatus(instance.getGithubComChaosMeshChaosMeshApiV1alpha1StressChaosStatus()); 
        fluent.withGithubComChaosMeshChaosMeshApiV1alpha1StressInstance(instance.getGithubComChaosMeshChaosMeshApiV1alpha1StressInstance()); 
        fluent.withGithubComChaosMeshChaosMeshApiV1alpha1Stressors(instance.getGithubComChaosMeshChaosMeshApiV1alpha1Stressors()); 
        fluent.withGithubComChaosMeshChaosMeshApiV1alpha1Target(instance.getGithubComChaosMeshChaosMeshApiV1alpha1Target()); 
        fluent.withGithubComChaosMeshChaosMeshApiV1alpha1TimeChaos(instance.getGithubComChaosMeshChaosMeshApiV1alpha1TimeChaos()); 
        fluent.withGithubComChaosMeshChaosMeshApiV1alpha1TimeChaosList(instance.getGithubComChaosMeshChaosMeshApiV1alpha1TimeChaosList()); 
        fluent.withGithubComChaosMeshChaosMeshApiV1alpha1TimeChaosSpec(instance.getGithubComChaosMeshChaosMeshApiV1alpha1TimeChaosSpec()); 
        fluent.withGithubComChaosMeshChaosMeshApiV1alpha1TimeChaosStatus(instance.getGithubComChaosMeshChaosMeshApiV1alpha1TimeChaosStatus()); 
        fluent.withGithubComChaosMeshChaosMeshApiV1alpha1Timespec(instance.getGithubComChaosMeshChaosMeshApiV1alpha1Timespec()); 
        this.validationEnabled = validationEnabled; 
    }

    public ChaosmeshSchemaBuilder(ChaosmeshSchema instance) {
        this(instance,true);
    }

    public ChaosmeshSchemaBuilder(ChaosmeshSchema instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withGithubComChaosMeshChaosMeshApiV1alpha1AttrOverrideSpec(instance.getGithubComChaosMeshChaosMeshApiV1alpha1AttrOverrideSpec()); 
        this.withGithubComChaosMeshChaosMeshApiV1alpha1BandwidthSpec(instance.getGithubComChaosMeshChaosMeshApiV1alpha1BandwidthSpec()); 
        this.withGithubComChaosMeshChaosMeshApiV1alpha1CPUStressor(instance.getGithubComChaosMeshChaosMeshApiV1alpha1CPUStressor()); 
        this.withGithubComChaosMeshChaosMeshApiV1alpha1CorruptSpec(instance.getGithubComChaosMeshChaosMeshApiV1alpha1CorruptSpec()); 
        this.withGithubComChaosMeshChaosMeshApiV1alpha1DNSChaos(instance.getGithubComChaosMeshChaosMeshApiV1alpha1DNSChaos()); 
        this.withGithubComChaosMeshChaosMeshApiV1alpha1DNSChaosList(instance.getGithubComChaosMeshChaosMeshApiV1alpha1DNSChaosList()); 
        this.withGithubComChaosMeshChaosMeshApiV1alpha1DNSChaosSpec(instance.getGithubComChaosMeshChaosMeshApiV1alpha1DNSChaosSpec()); 
        this.withGithubComChaosMeshChaosMeshApiV1alpha1DNSChaosStatus(instance.getGithubComChaosMeshChaosMeshApiV1alpha1DNSChaosStatus()); 
        this.withGithubComChaosMeshChaosMeshApiV1alpha1DelaySpec(instance.getGithubComChaosMeshChaosMeshApiV1alpha1DelaySpec()); 
        this.withGithubComChaosMeshChaosMeshApiV1alpha1DuplicateSpec(instance.getGithubComChaosMeshChaosMeshApiV1alpha1DuplicateSpec()); 
        this.withGithubComChaosMeshChaosMeshApiV1alpha1ExperimentStatus(instance.getGithubComChaosMeshChaosMeshApiV1alpha1ExperimentStatus()); 
        this.withGithubComChaosMeshChaosMeshApiV1alpha1FailKernRequest(instance.getGithubComChaosMeshChaosMeshApiV1alpha1FailKernRequest()); 
        this.withGithubComChaosMeshChaosMeshApiV1alpha1Frame(instance.getGithubComChaosMeshChaosMeshApiV1alpha1Frame()); 
        this.withGithubComChaosMeshChaosMeshApiV1alpha1HTTPChaos(instance.getGithubComChaosMeshChaosMeshApiV1alpha1HTTPChaos()); 
        this.withGithubComChaosMeshChaosMeshApiV1alpha1HTTPChaosList(instance.getGithubComChaosMeshChaosMeshApiV1alpha1HTTPChaosList()); 
        this.withGithubComChaosMeshChaosMeshApiV1alpha1HTTPChaosSpec(instance.getGithubComChaosMeshChaosMeshApiV1alpha1HTTPChaosSpec()); 
        this.withGithubComChaosMeshChaosMeshApiV1alpha1HTTPChaosStatus(instance.getGithubComChaosMeshChaosMeshApiV1alpha1HTTPChaosStatus()); 
        this.withGithubComChaosMeshChaosMeshApiV1alpha1IoChaos(instance.getGithubComChaosMeshChaosMeshApiV1alpha1IoChaos()); 
        this.withGithubComChaosMeshChaosMeshApiV1alpha1IoChaosAction(instance.getGithubComChaosMeshChaosMeshApiV1alpha1IoChaosAction()); 
        this.withGithubComChaosMeshChaosMeshApiV1alpha1IoChaosList(instance.getGithubComChaosMeshChaosMeshApiV1alpha1IoChaosList()); 
        this.withGithubComChaosMeshChaosMeshApiV1alpha1IoChaosSpec(instance.getGithubComChaosMeshChaosMeshApiV1alpha1IoChaosSpec()); 
        this.withGithubComChaosMeshChaosMeshApiV1alpha1IoChaosStatus(instance.getGithubComChaosMeshChaosMeshApiV1alpha1IoChaosStatus()); 
        this.withGithubComChaosMeshChaosMeshApiV1alpha1IoFault(instance.getGithubComChaosMeshChaosMeshApiV1alpha1IoFault()); 
        this.withGithubComChaosMeshChaosMeshApiV1alpha1JVMChaos(instance.getGithubComChaosMeshChaosMeshApiV1alpha1JVMChaos()); 
        this.withGithubComChaosMeshChaosMeshApiV1alpha1JVMChaosList(instance.getGithubComChaosMeshChaosMeshApiV1alpha1JVMChaosList()); 
        this.withGithubComChaosMeshChaosMeshApiV1alpha1JVMChaosSpec(instance.getGithubComChaosMeshChaosMeshApiV1alpha1JVMChaosSpec()); 
        this.withGithubComChaosMeshChaosMeshApiV1alpha1JVMChaosStatus(instance.getGithubComChaosMeshChaosMeshApiV1alpha1JVMChaosStatus()); 
        this.withGithubComChaosMeshChaosMeshApiV1alpha1JVMCpufullloadSpec(instance.getGithubComChaosMeshChaosMeshApiV1alpha1JVMCpufullloadSpec()); 
        this.withGithubComChaosMeshChaosMeshApiV1alpha1JVMDelaySpec(instance.getGithubComChaosMeshChaosMeshApiV1alpha1JVMDelaySpec()); 
        this.withGithubComChaosMeshChaosMeshApiV1alpha1JVMExceptionSpec(instance.getGithubComChaosMeshChaosMeshApiV1alpha1JVMExceptionSpec()); 
        this.withGithubComChaosMeshChaosMeshApiV1alpha1JVMOOMSpec(instance.getGithubComChaosMeshChaosMeshApiV1alpha1JVMOOMSpec()); 
        this.withGithubComChaosMeshChaosMeshApiV1alpha1JVMReturnSpec(instance.getGithubComChaosMeshChaosMeshApiV1alpha1JVMReturnSpec()); 
        this.withGithubComChaosMeshChaosMeshApiV1alpha1JVMScriptSpec(instance.getGithubComChaosMeshChaosMeshApiV1alpha1JVMScriptSpec()); 
        this.withGithubComChaosMeshChaosMeshApiV1alpha1KernelChaos(instance.getGithubComChaosMeshChaosMeshApiV1alpha1KernelChaos()); 
        this.withGithubComChaosMeshChaosMeshApiV1alpha1KernelChaosList(instance.getGithubComChaosMeshChaosMeshApiV1alpha1KernelChaosList()); 
        this.withGithubComChaosMeshChaosMeshApiV1alpha1KernelChaosSpec(instance.getGithubComChaosMeshChaosMeshApiV1alpha1KernelChaosSpec()); 
        this.withGithubComChaosMeshChaosMeshApiV1alpha1KernelChaosStatus(instance.getGithubComChaosMeshChaosMeshApiV1alpha1KernelChaosStatus()); 
        this.withGithubComChaosMeshChaosMeshApiV1alpha1LossSpec(instance.getGithubComChaosMeshChaosMeshApiV1alpha1LossSpec()); 
        this.withGithubComChaosMeshChaosMeshApiV1alpha1Matcher(instance.getGithubComChaosMeshChaosMeshApiV1alpha1Matcher()); 
        this.withGithubComChaosMeshChaosMeshApiV1alpha1MemoryStressor(instance.getGithubComChaosMeshChaosMeshApiV1alpha1MemoryStressor()); 
        this.withGithubComChaosMeshChaosMeshApiV1alpha1NetworkChaos(instance.getGithubComChaosMeshChaosMeshApiV1alpha1NetworkChaos()); 
        this.withGithubComChaosMeshChaosMeshApiV1alpha1NetworkChaosList(instance.getGithubComChaosMeshChaosMeshApiV1alpha1NetworkChaosList()); 
        this.withGithubComChaosMeshChaosMeshApiV1alpha1NetworkChaosSpec(instance.getGithubComChaosMeshChaosMeshApiV1alpha1NetworkChaosSpec()); 
        this.withGithubComChaosMeshChaosMeshApiV1alpha1NetworkChaosStatus(instance.getGithubComChaosMeshChaosMeshApiV1alpha1NetworkChaosStatus()); 
        this.withGithubComChaosMeshChaosMeshApiV1alpha1PodChaos(instance.getGithubComChaosMeshChaosMeshApiV1alpha1PodChaos()); 
        this.withGithubComChaosMeshChaosMeshApiV1alpha1PodChaosList(instance.getGithubComChaosMeshChaosMeshApiV1alpha1PodChaosList()); 
        this.withGithubComChaosMeshChaosMeshApiV1alpha1PodChaosSpec(instance.getGithubComChaosMeshChaosMeshApiV1alpha1PodChaosSpec()); 
        this.withGithubComChaosMeshChaosMeshApiV1alpha1PodChaosStatus(instance.getGithubComChaosMeshChaosMeshApiV1alpha1PodChaosStatus()); 
        this.withGithubComChaosMeshChaosMeshApiV1alpha1PodIoChaos(instance.getGithubComChaosMeshChaosMeshApiV1alpha1PodIoChaos()); 
        this.withGithubComChaosMeshChaosMeshApiV1alpha1PodIoChaosList(instance.getGithubComChaosMeshChaosMeshApiV1alpha1PodIoChaosList()); 
        this.withGithubComChaosMeshChaosMeshApiV1alpha1PodIoChaosSpec(instance.getGithubComChaosMeshChaosMeshApiV1alpha1PodIoChaosSpec()); 
        this.withGithubComChaosMeshChaosMeshApiV1alpha1PodNetworkChaos(instance.getGithubComChaosMeshChaosMeshApiV1alpha1PodNetworkChaos()); 
        this.withGithubComChaosMeshChaosMeshApiV1alpha1PodNetworkChaosList(instance.getGithubComChaosMeshChaosMeshApiV1alpha1PodNetworkChaosList()); 
        this.withGithubComChaosMeshChaosMeshApiV1alpha1PodNetworkChaosSpec(instance.getGithubComChaosMeshChaosMeshApiV1alpha1PodNetworkChaosSpec()); 
        this.withGithubComChaosMeshChaosMeshApiV1alpha1PodNetworkChaosStatus(instance.getGithubComChaosMeshChaosMeshApiV1alpha1PodNetworkChaosStatus()); 
        this.withGithubComChaosMeshChaosMeshApiV1alpha1PodStatus(instance.getGithubComChaosMeshChaosMeshApiV1alpha1PodStatus()); 
        this.withGithubComChaosMeshChaosMeshApiV1alpha1RawIPSet(instance.getGithubComChaosMeshChaosMeshApiV1alpha1RawIPSet()); 
        this.withGithubComChaosMeshChaosMeshApiV1alpha1RawIptables(instance.getGithubComChaosMeshChaosMeshApiV1alpha1RawIptables()); 
        this.withGithubComChaosMeshChaosMeshApiV1alpha1RawTrafficControl(instance.getGithubComChaosMeshChaosMeshApiV1alpha1RawTrafficControl()); 
        this.withGithubComChaosMeshChaosMeshApiV1alpha1ReorderSpec(instance.getGithubComChaosMeshChaosMeshApiV1alpha1ReorderSpec()); 
        this.withGithubComChaosMeshChaosMeshApiV1alpha1ScheduleStatus(instance.getGithubComChaosMeshChaosMeshApiV1alpha1ScheduleStatus()); 
        this.withGithubComChaosMeshChaosMeshApiV1alpha1SchedulerSpec(instance.getGithubComChaosMeshChaosMeshApiV1alpha1SchedulerSpec()); 
        this.withGithubComChaosMeshChaosMeshApiV1alpha1SelectorSpec(instance.getGithubComChaosMeshChaosMeshApiV1alpha1SelectorSpec()); 
        this.withGithubComChaosMeshChaosMeshApiV1alpha1ServletDelaySpec(instance.getGithubComChaosMeshChaosMeshApiV1alpha1ServletDelaySpec()); 
        this.withGithubComChaosMeshChaosMeshApiV1alpha1ServletExceptionSpec(instance.getGithubComChaosMeshChaosMeshApiV1alpha1ServletExceptionSpec()); 
        this.withGithubComChaosMeshChaosMeshApiV1alpha1StressChaos(instance.getGithubComChaosMeshChaosMeshApiV1alpha1StressChaos()); 
        this.withGithubComChaosMeshChaosMeshApiV1alpha1StressChaosList(instance.getGithubComChaosMeshChaosMeshApiV1alpha1StressChaosList()); 
        this.withGithubComChaosMeshChaosMeshApiV1alpha1StressChaosSpec(instance.getGithubComChaosMeshChaosMeshApiV1alpha1StressChaosSpec()); 
        this.withGithubComChaosMeshChaosMeshApiV1alpha1StressChaosStatus(instance.getGithubComChaosMeshChaosMeshApiV1alpha1StressChaosStatus()); 
        this.withGithubComChaosMeshChaosMeshApiV1alpha1StressInstance(instance.getGithubComChaosMeshChaosMeshApiV1alpha1StressInstance()); 
        this.withGithubComChaosMeshChaosMeshApiV1alpha1Stressors(instance.getGithubComChaosMeshChaosMeshApiV1alpha1Stressors()); 
        this.withGithubComChaosMeshChaosMeshApiV1alpha1Target(instance.getGithubComChaosMeshChaosMeshApiV1alpha1Target()); 
        this.withGithubComChaosMeshChaosMeshApiV1alpha1TimeChaos(instance.getGithubComChaosMeshChaosMeshApiV1alpha1TimeChaos()); 
        this.withGithubComChaosMeshChaosMeshApiV1alpha1TimeChaosList(instance.getGithubComChaosMeshChaosMeshApiV1alpha1TimeChaosList()); 
        this.withGithubComChaosMeshChaosMeshApiV1alpha1TimeChaosSpec(instance.getGithubComChaosMeshChaosMeshApiV1alpha1TimeChaosSpec()); 
        this.withGithubComChaosMeshChaosMeshApiV1alpha1TimeChaosStatus(instance.getGithubComChaosMeshChaosMeshApiV1alpha1TimeChaosStatus()); 
        this.withGithubComChaosMeshChaosMeshApiV1alpha1Timespec(instance.getGithubComChaosMeshChaosMeshApiV1alpha1Timespec()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.chaosmesh.api.model.EditableChaosmeshSchema build() {
        EditableChaosmeshSchema buildable = new EditableChaosmeshSchema(fluent.getGithubComChaosMeshChaosMeshApiV1alpha1AttrOverrideSpec(),fluent.getGithubComChaosMeshChaosMeshApiV1alpha1BandwidthSpec(),fluent.getGithubComChaosMeshChaosMeshApiV1alpha1CPUStressor(),fluent.getGithubComChaosMeshChaosMeshApiV1alpha1CorruptSpec(),fluent.getGithubComChaosMeshChaosMeshApiV1alpha1DNSChaos(),fluent.getGithubComChaosMeshChaosMeshApiV1alpha1DNSChaosList(),fluent.getGithubComChaosMeshChaosMeshApiV1alpha1DNSChaosSpec(),fluent.getGithubComChaosMeshChaosMeshApiV1alpha1DNSChaosStatus(),fluent.getGithubComChaosMeshChaosMeshApiV1alpha1DelaySpec(),fluent.getGithubComChaosMeshChaosMeshApiV1alpha1DuplicateSpec(),fluent.getGithubComChaosMeshChaosMeshApiV1alpha1ExperimentStatus(),fluent.getGithubComChaosMeshChaosMeshApiV1alpha1FailKernRequest(),fluent.getGithubComChaosMeshChaosMeshApiV1alpha1Frame(),fluent.getGithubComChaosMeshChaosMeshApiV1alpha1HTTPChaos(),fluent.getGithubComChaosMeshChaosMeshApiV1alpha1HTTPChaosList(),fluent.getGithubComChaosMeshChaosMeshApiV1alpha1HTTPChaosSpec(),fluent.getGithubComChaosMeshChaosMeshApiV1alpha1HTTPChaosStatus(),fluent.getGithubComChaosMeshChaosMeshApiV1alpha1IoChaos(),fluent.getGithubComChaosMeshChaosMeshApiV1alpha1IoChaosAction(),fluent.getGithubComChaosMeshChaosMeshApiV1alpha1IoChaosList(),fluent.getGithubComChaosMeshChaosMeshApiV1alpha1IoChaosSpec(),fluent.getGithubComChaosMeshChaosMeshApiV1alpha1IoChaosStatus(),fluent.getGithubComChaosMeshChaosMeshApiV1alpha1IoFault(),fluent.getGithubComChaosMeshChaosMeshApiV1alpha1JVMChaos(),fluent.getGithubComChaosMeshChaosMeshApiV1alpha1JVMChaosList(),fluent.getGithubComChaosMeshChaosMeshApiV1alpha1JVMChaosSpec(),fluent.getGithubComChaosMeshChaosMeshApiV1alpha1JVMChaosStatus(),fluent.getGithubComChaosMeshChaosMeshApiV1alpha1JVMCpufullloadSpec(),fluent.getGithubComChaosMeshChaosMeshApiV1alpha1JVMDelaySpec(),fluent.getGithubComChaosMeshChaosMeshApiV1alpha1JVMExceptionSpec(),fluent.getGithubComChaosMeshChaosMeshApiV1alpha1JVMOOMSpec(),fluent.getGithubComChaosMeshChaosMeshApiV1alpha1JVMReturnSpec(),fluent.getGithubComChaosMeshChaosMeshApiV1alpha1JVMScriptSpec(),fluent.getGithubComChaosMeshChaosMeshApiV1alpha1KernelChaos(),fluent.getGithubComChaosMeshChaosMeshApiV1alpha1KernelChaosList(),fluent.getGithubComChaosMeshChaosMeshApiV1alpha1KernelChaosSpec(),fluent.getGithubComChaosMeshChaosMeshApiV1alpha1KernelChaosStatus(),fluent.getGithubComChaosMeshChaosMeshApiV1alpha1LossSpec(),fluent.getGithubComChaosMeshChaosMeshApiV1alpha1Matcher(),fluent.getGithubComChaosMeshChaosMeshApiV1alpha1MemoryStressor(),fluent.getGithubComChaosMeshChaosMeshApiV1alpha1NetworkChaos(),fluent.getGithubComChaosMeshChaosMeshApiV1alpha1NetworkChaosList(),fluent.getGithubComChaosMeshChaosMeshApiV1alpha1NetworkChaosSpec(),fluent.getGithubComChaosMeshChaosMeshApiV1alpha1NetworkChaosStatus(),fluent.getGithubComChaosMeshChaosMeshApiV1alpha1PodChaos(),fluent.getGithubComChaosMeshChaosMeshApiV1alpha1PodChaosList(),fluent.getGithubComChaosMeshChaosMeshApiV1alpha1PodChaosSpec(),fluent.getGithubComChaosMeshChaosMeshApiV1alpha1PodChaosStatus(),fluent.getGithubComChaosMeshChaosMeshApiV1alpha1PodIoChaos(),fluent.getGithubComChaosMeshChaosMeshApiV1alpha1PodIoChaosList(),fluent.getGithubComChaosMeshChaosMeshApiV1alpha1PodIoChaosSpec(),fluent.getGithubComChaosMeshChaosMeshApiV1alpha1PodNetworkChaos(),fluent.getGithubComChaosMeshChaosMeshApiV1alpha1PodNetworkChaosList(),fluent.getGithubComChaosMeshChaosMeshApiV1alpha1PodNetworkChaosSpec(),fluent.getGithubComChaosMeshChaosMeshApiV1alpha1PodNetworkChaosStatus(),fluent.getGithubComChaosMeshChaosMeshApiV1alpha1PodStatus(),fluent.getGithubComChaosMeshChaosMeshApiV1alpha1RawIPSet(),fluent.getGithubComChaosMeshChaosMeshApiV1alpha1RawIptables(),fluent.getGithubComChaosMeshChaosMeshApiV1alpha1RawTrafficControl(),fluent.getGithubComChaosMeshChaosMeshApiV1alpha1ReorderSpec(),fluent.getGithubComChaosMeshChaosMeshApiV1alpha1ScheduleStatus(),fluent.getGithubComChaosMeshChaosMeshApiV1alpha1SchedulerSpec(),fluent.getGithubComChaosMeshChaosMeshApiV1alpha1SelectorSpec(),fluent.getGithubComChaosMeshChaosMeshApiV1alpha1ServletDelaySpec(),fluent.getGithubComChaosMeshChaosMeshApiV1alpha1ServletExceptionSpec(),fluent.getGithubComChaosMeshChaosMeshApiV1alpha1StressChaos(),fluent.getGithubComChaosMeshChaosMeshApiV1alpha1StressChaosList(),fluent.getGithubComChaosMeshChaosMeshApiV1alpha1StressChaosSpec(),fluent.getGithubComChaosMeshChaosMeshApiV1alpha1StressChaosStatus(),fluent.getGithubComChaosMeshChaosMeshApiV1alpha1StressInstance(),fluent.getGithubComChaosMeshChaosMeshApiV1alpha1Stressors(),fluent.getGithubComChaosMeshChaosMeshApiV1alpha1Target(),fluent.getGithubComChaosMeshChaosMeshApiV1alpha1TimeChaos(),fluent.getGithubComChaosMeshChaosMeshApiV1alpha1TimeChaosList(),fluent.getGithubComChaosMeshChaosMeshApiV1alpha1TimeChaosSpec(),fluent.getGithubComChaosMeshChaosMeshApiV1alpha1TimeChaosStatus(),fluent.getGithubComChaosMeshChaosMeshApiV1alpha1Timespec());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        ChaosmeshSchemaBuilder that = (ChaosmeshSchemaBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
