package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class TimeChaosBuilder extends TimeChaosFluentImpl<TimeChaosBuilder> implements VisitableBuilder<TimeChaos,TimeChaosBuilder> {

    TimeChaosFluent<?> fluent;
    Boolean validationEnabled;

    public TimeChaosBuilder() {
        this(true);
    }

    public TimeChaosBuilder(Boolean validationEnabled) {
        this(new TimeChaos(), validationEnabled);
    }

    public TimeChaosBuilder(TimeChaosFluent<?> fluent) {
        this(fluent, true);
    }

    public TimeChaosBuilder(TimeChaosFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new TimeChaos(), validationEnabled);
    }

    public TimeChaosBuilder(TimeChaosFluent<?> fluent,TimeChaos instance) {
        this(fluent, instance, true);
    }

    public TimeChaosBuilder(TimeChaosFluent<?> fluent,TimeChaos instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion()); 
        fluent.withKind(instance.getKind()); 
        fluent.withMetadata(instance.getMetadata()); 
        fluent.withSpec(instance.getSpec()); 
        fluent.withStatus(instance.getStatus()); 
        this.validationEnabled = validationEnabled; 
    }

    public TimeChaosBuilder(TimeChaos instance) {
        this(instance,true);
    }

    public TimeChaosBuilder(TimeChaos instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.withSpec(instance.getSpec()); 
        this.withStatus(instance.getStatus()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.chaosmesh.v1alpha1.EditableTimeChaos build() {
        EditableTimeChaos buildable = new EditableTimeChaos(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        TimeChaosBuilder that = (TimeChaosBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
