package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ServletDelaySpecBuilder extends ServletDelaySpecFluentImpl<ServletDelaySpecBuilder> implements VisitableBuilder<ServletDelaySpec,ServletDelaySpecBuilder> {

    ServletDelaySpecFluent<?> fluent;
    Boolean validationEnabled;

    public ServletDelaySpecBuilder() {
        this(true);
    }

    public ServletDelaySpecBuilder(Boolean validationEnabled) {
        this(new ServletDelaySpec(), validationEnabled);
    }

    public ServletDelaySpecBuilder(ServletDelaySpecFluent<?> fluent) {
        this(fluent, true);
    }

    public ServletDelaySpecBuilder(ServletDelaySpecFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new ServletDelaySpec(), validationEnabled);
    }

    public ServletDelaySpecBuilder(ServletDelaySpecFluent<?> fluent,ServletDelaySpec instance) {
        this(fluent, instance, true);
    }

    public ServletDelaySpecBuilder(ServletDelaySpecFluent<?> fluent,ServletDelaySpec instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withMethod(instance.getMethod()); 
        fluent.withOffset(instance.getOffset()); 
        fluent.withQuerystring(instance.getQuerystring()); 
        fluent.withRequestpath(instance.getRequestpath()); 
        fluent.withTime(instance.getTime()); 
        this.validationEnabled = validationEnabled; 
    }

    public ServletDelaySpecBuilder(ServletDelaySpec instance) {
        this(instance,true);
    }

    public ServletDelaySpecBuilder(ServletDelaySpec instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withMethod(instance.getMethod()); 
        this.withOffset(instance.getOffset()); 
        this.withQuerystring(instance.getQuerystring()); 
        this.withRequestpath(instance.getRequestpath()); 
        this.withTime(instance.getTime()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.chaosmesh.v1alpha1.EditableServletDelaySpec build() {
        EditableServletDelaySpec buildable = new EditableServletDelaySpec(fluent.getMethod(),fluent.getOffset(),fluent.getQuerystring(),fluent.getRequestpath(),fluent.getTime());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        ServletDelaySpecBuilder that = (ServletDelaySpecBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
