package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.StringBuffer;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

public interface HTTPChaosSpecFluent<A extends HTTPChaosSpecFluent<A>> extends Fluent<A> {


    public String getAction();
    public A withAction(String action);
    public Boolean hasAction();
    public A withNewAction(StringBuilder arg1);
    public A withNewAction(int[] arg1,int arg2,int arg3);
    public A withNewAction(char[] arg1);
    public A withNewAction(StringBuffer arg1);
    public A withNewAction(byte[] arg1,int arg2);
    public A withNewAction(byte[] arg1);
    public A withNewAction(char[] arg1,int arg2,int arg3);
    public A withNewAction(byte[] arg1,int arg2,int arg3);
    public A withNewAction(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewAction(String arg1);
    public String getDuration();
    public A withDuration(String duration);
    public Boolean hasDuration();
    public A withNewDuration(StringBuilder arg1);
    public A withNewDuration(int[] arg1,int arg2,int arg3);
    public A withNewDuration(char[] arg1);
    public A withNewDuration(StringBuffer arg1);
    public A withNewDuration(byte[] arg1,int arg2);
    public A withNewDuration(byte[] arg1);
    public A withNewDuration(char[] arg1,int arg2,int arg3);
    public A withNewDuration(byte[] arg1,int arg2,int arg3);
    public A withNewDuration(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewDuration(String arg1);
    public A addToHeaders(int index,Matcher item);
    public A setToHeaders(int index,Matcher item);
    public A addToHeaders(Matcher... items);
    public A addAllToHeaders(Collection<Matcher> items);
    public A removeFromHeaders(Matcher... items);
    public A removeAllFromHeaders(Collection<Matcher> items);
    public A removeMatchingFromHeaders(Predicate<MatcherBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildHeaders instead.
 * @return The buildable object.
 */
@Deprecated public List<Matcher> getHeaders();
    public List<Matcher> buildHeaders();
    public Matcher buildHeader(int index);
    public Matcher buildFirstHeader();
    public Matcher buildLastHeader();
    public Matcher buildMatchingHeader(Predicate<MatcherBuilder> predicate);
    public Boolean hasMatchingHeader(Predicate<MatcherBuilder> predicate);
    public A withHeaders(List<Matcher> headers);
    public A withHeaders(Matcher... headers);
    public Boolean hasHeaders();
    public HTTPChaosSpecFluent.HeadersNested<A> addNewHeader();
    public HTTPChaosSpecFluent.HeadersNested<A> addNewHeaderLike(Matcher item);
    public HTTPChaosSpecFluent.HeadersNested<A> setNewHeaderLike(int index,Matcher item);
    public HTTPChaosSpecFluent.HeadersNested<A> editHeader(int index);
    public HTTPChaosSpecFluent.HeadersNested<A> editFirstHeader();
    public HTTPChaosSpecFluent.HeadersNested<A> editLastHeader();
    public HTTPChaosSpecFluent.HeadersNested<A> editMatchingHeader(Predicate<MatcherBuilder> predicate);
    public String getMode();
    public A withMode(String mode);
    public Boolean hasMode();
    public A withNewMode(StringBuilder arg1);
    public A withNewMode(int[] arg1,int arg2,int arg3);
    public A withNewMode(char[] arg1);
    public A withNewMode(StringBuffer arg1);
    public A withNewMode(byte[] arg1,int arg2);
    public A withNewMode(byte[] arg1);
    public A withNewMode(char[] arg1,int arg2,int arg3);
    public A withNewMode(byte[] arg1,int arg2,int arg3);
    public A withNewMode(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewMode(String arg1);
    public String getPercent();
    public A withPercent(String percent);
    public Boolean hasPercent();
    public A withNewPercent(StringBuilder arg1);
    public A withNewPercent(int[] arg1,int arg2,int arg3);
    public A withNewPercent(char[] arg1);
    public A withNewPercent(StringBuffer arg1);
    public A withNewPercent(byte[] arg1,int arg2);
    public A withNewPercent(byte[] arg1);
    public A withNewPercent(char[] arg1,int arg2,int arg3);
    public A withNewPercent(byte[] arg1,int arg2,int arg3);
    public A withNewPercent(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewPercent(String arg1);
    
/**
 * This method has been deprecated, please use method buildScheduler instead.
 * @return The buildable object.
 */
@Deprecated public SchedulerSpec getScheduler();
    public SchedulerSpec buildScheduler();
    public A withScheduler(SchedulerSpec scheduler);
    public Boolean hasScheduler();
    public A withNewScheduler(String cron);
    public HTTPChaosSpecFluent.SchedulerNested<A> withNewScheduler();
    public HTTPChaosSpecFluent.SchedulerNested<A> withNewSchedulerLike(SchedulerSpec item);
    public HTTPChaosSpecFluent.SchedulerNested<A> editScheduler();
    public HTTPChaosSpecFluent.SchedulerNested<A> editOrNewScheduler();
    public HTTPChaosSpecFluent.SchedulerNested<A> editOrNewSchedulerLike(SchedulerSpec item);
    
/**
 * This method has been deprecated, please use method buildSelector instead.
 * @return The buildable object.
 */
@Deprecated public SelectorSpec getSelector();
    public SelectorSpec buildSelector();
    public A withSelector(SelectorSpec selector);
    public Boolean hasSelector();
    public HTTPChaosSpecFluent.SelectorNested<A> withNewSelector();
    public HTTPChaosSpecFluent.SelectorNested<A> withNewSelectorLike(SelectorSpec item);
    public HTTPChaosSpecFluent.SelectorNested<A> editSelector();
    public HTTPChaosSpecFluent.SelectorNested<A> editOrNewSelector();
    public HTTPChaosSpecFluent.SelectorNested<A> editOrNewSelectorLike(SelectorSpec item);
    public String getValue();
    public A withValue(String value);
    public Boolean hasValue();
    public A withNewValue(StringBuilder arg1);
    public A withNewValue(int[] arg1,int arg2,int arg3);
    public A withNewValue(char[] arg1);
    public A withNewValue(StringBuffer arg1);
    public A withNewValue(byte[] arg1,int arg2);
    public A withNewValue(byte[] arg1);
    public A withNewValue(char[] arg1,int arg2,int arg3);
    public A withNewValue(byte[] arg1,int arg2,int arg3);
    public A withNewValue(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewValue(String arg1);
    public interface HeadersNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,MatcherFluent<HTTPChaosSpecFluent.HeadersNested<N>> {

            public N and();
            public N endHeader();    }


    public interface SchedulerNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,SchedulerSpecFluent<HTTPChaosSpecFluent.SchedulerNested<N>> {

            public N and();
            public N endScheduler();    }


    public interface SelectorNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,SelectorSpecFluent<HTTPChaosSpecFluent.SelectorNested<N>> {

            public N and();
            public N endSelector();    }


}
