package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class ExperimentStatusFluentImpl<A extends ExperimentStatusFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements ExperimentStatusFluent<A> {

    private String duration;
    private String endTime;
    private String phase;
    private List<PodStatusBuilder> podRecords;
    private String reason;
    private String startTime;

    public ExperimentStatusFluentImpl() {
    }

    public ExperimentStatusFluentImpl(ExperimentStatus instance) {
        this.withDuration(instance.getDuration()); 
        this.withEndTime(instance.getEndTime()); 
        this.withPhase(instance.getPhase()); 
        this.withPodRecords(instance.getPodRecords()); 
        this.withReason(instance.getReason()); 
        this.withStartTime(instance.getStartTime()); 
    }

    public String getDuration() {
        return this.duration;
    }

    public A withDuration(String duration) {
        this.duration=duration; return (A) this;
    }

    public Boolean hasDuration() {
        return this.duration != null;
    }

    public A withNewDuration(StringBuilder arg1) {
        return (A)withDuration(new String(arg1));
    }

    public A withNewDuration(int[] arg1,int arg2,int arg3) {
        return (A)withDuration(new String(arg1, arg2, arg3));
    }

    public A withNewDuration(char[] arg1) {
        return (A)withDuration(new String(arg1));
    }

    public A withNewDuration(StringBuffer arg1) {
        return (A)withDuration(new String(arg1));
    }

    public A withNewDuration(byte[] arg1,int arg2) {
        return (A)withDuration(new String(arg1, arg2));
    }

    public A withNewDuration(byte[] arg1) {
        return (A)withDuration(new String(arg1));
    }

    public A withNewDuration(char[] arg1,int arg2,int arg3) {
        return (A)withDuration(new String(arg1, arg2, arg3));
    }

    public A withNewDuration(byte[] arg1,int arg2,int arg3) {
        return (A)withDuration(new String(arg1, arg2, arg3));
    }

    public A withNewDuration(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withDuration(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewDuration(String arg1) {
        return (A)withDuration(new String(arg1));
    }

    public String getEndTime() {
        return this.endTime;
    }

    public A withEndTime(String endTime) {
        this.endTime=endTime; return (A) this;
    }

    public Boolean hasEndTime() {
        return this.endTime != null;
    }

    public A withNewEndTime(StringBuilder arg1) {
        return (A)withEndTime(new String(arg1));
    }

    public A withNewEndTime(int[] arg1,int arg2,int arg3) {
        return (A)withEndTime(new String(arg1, arg2, arg3));
    }

    public A withNewEndTime(char[] arg1) {
        return (A)withEndTime(new String(arg1));
    }

    public A withNewEndTime(StringBuffer arg1) {
        return (A)withEndTime(new String(arg1));
    }

    public A withNewEndTime(byte[] arg1,int arg2) {
        return (A)withEndTime(new String(arg1, arg2));
    }

    public A withNewEndTime(byte[] arg1) {
        return (A)withEndTime(new String(arg1));
    }

    public A withNewEndTime(char[] arg1,int arg2,int arg3) {
        return (A)withEndTime(new String(arg1, arg2, arg3));
    }

    public A withNewEndTime(byte[] arg1,int arg2,int arg3) {
        return (A)withEndTime(new String(arg1, arg2, arg3));
    }

    public A withNewEndTime(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withEndTime(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewEndTime(String arg1) {
        return (A)withEndTime(new String(arg1));
    }

    public String getPhase() {
        return this.phase;
    }

    public A withPhase(String phase) {
        this.phase=phase; return (A) this;
    }

    public Boolean hasPhase() {
        return this.phase != null;
    }

    public A withNewPhase(StringBuilder arg1) {
        return (A)withPhase(new String(arg1));
    }

    public A withNewPhase(int[] arg1,int arg2,int arg3) {
        return (A)withPhase(new String(arg1, arg2, arg3));
    }

    public A withNewPhase(char[] arg1) {
        return (A)withPhase(new String(arg1));
    }

    public A withNewPhase(StringBuffer arg1) {
        return (A)withPhase(new String(arg1));
    }

    public A withNewPhase(byte[] arg1,int arg2) {
        return (A)withPhase(new String(arg1, arg2));
    }

    public A withNewPhase(byte[] arg1) {
        return (A)withPhase(new String(arg1));
    }

    public A withNewPhase(char[] arg1,int arg2,int arg3) {
        return (A)withPhase(new String(arg1, arg2, arg3));
    }

    public A withNewPhase(byte[] arg1,int arg2,int arg3) {
        return (A)withPhase(new String(arg1, arg2, arg3));
    }

    public A withNewPhase(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withPhase(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewPhase(String arg1) {
        return (A)withPhase(new String(arg1));
    }

    public A addToPodRecords(int index,PodStatus item) {
        if (this.podRecords == null) {this.podRecords = new ArrayList<PodStatusBuilder>();}
        PodStatusBuilder builder = new PodStatusBuilder(item);_visitables.get("podRecords").add(index >= 0 ? index : _visitables.get("podRecords").size(), builder);this.podRecords.add(index >= 0 ? index : podRecords.size(), builder); return (A)this;
    }

    public A setToPodRecords(int index,PodStatus item) {
        if (this.podRecords == null) {this.podRecords = new ArrayList<PodStatusBuilder>();}
        PodStatusBuilder builder = new PodStatusBuilder(item);
        if (index < 0 || index >= _visitables.get("podRecords").size()) { _visitables.get("podRecords").add(builder); } else { _visitables.get("podRecords").set(index, builder);}
        if (index < 0 || index >= podRecords.size()) { podRecords.add(builder); } else { podRecords.set(index, builder);}
         return (A)this;
    }

    public A addToPodRecords(PodStatus... items) {
        if (this.podRecords == null) {this.podRecords = new ArrayList<PodStatusBuilder>();}
        for (PodStatus item : items) {PodStatusBuilder builder = new PodStatusBuilder(item);_visitables.get("podRecords").add(builder);this.podRecords.add(builder);} return (A)this;
    }

    public A addAllToPodRecords(Collection<PodStatus> items) {
        if (this.podRecords == null) {this.podRecords = new ArrayList<PodStatusBuilder>();}
        for (PodStatus item : items) {PodStatusBuilder builder = new PodStatusBuilder(item);_visitables.get("podRecords").add(builder);this.podRecords.add(builder);} return (A)this;
    }

    public A removeFromPodRecords(PodStatus... items) {
        for (PodStatus item : items) {PodStatusBuilder builder = new PodStatusBuilder(item);_visitables.get("podRecords").remove(builder);if (this.podRecords != null) {this.podRecords.remove(builder);}} return (A)this;
    }

    public A removeAllFromPodRecords(Collection<PodStatus> items) {
        for (PodStatus item : items) {PodStatusBuilder builder = new PodStatusBuilder(item);_visitables.get("podRecords").remove(builder);if (this.podRecords != null) {this.podRecords.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromPodRecords(Predicate<PodStatusBuilder> predicate) {
        if (podRecords == null) return (A) this;
        final Iterator<PodStatusBuilder> each = podRecords.iterator();
        final List visitables = _visitables.get("podRecords");
        while (each.hasNext()) {
          PodStatusBuilder builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildPodRecords instead.
 * @return The buildable object.
 */
@Deprecated public List<PodStatus> getPodRecords() {
        return build(podRecords);
    }

    public List<PodStatus> buildPodRecords() {
        return build(podRecords);
    }

    public PodStatus buildPodRecord(int index) {
        return this.podRecords.get(index).build();
    }

    public PodStatus buildFirstPodRecord() {
        return this.podRecords.get(0).build();
    }

    public PodStatus buildLastPodRecord() {
        return this.podRecords.get(podRecords.size() - 1).build();
    }

    public PodStatus buildMatchingPodRecord(Predicate<PodStatusBuilder> predicate) {
        for (PodStatusBuilder item: podRecords) { if(predicate.test(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingPodRecord(Predicate<PodStatusBuilder> predicate) {
        for (PodStatusBuilder item: podRecords) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withPodRecords(List<PodStatus> podRecords) {
        if (this.podRecords != null) { _visitables.get("podRecords").removeAll(this.podRecords);}
        if (podRecords != null) {this.podRecords = new ArrayList<PodStatusBuilder>(); for (PodStatus item : podRecords){this.addToPodRecords(item);}} else { this.podRecords = null;} return (A) this;
    }

    public A withPodRecords(PodStatus... podRecords) {
        if (this.podRecords != null) {this.podRecords.clear();}
        if (podRecords != null) {for (PodStatus item :podRecords){ this.addToPodRecords(item);}} return (A) this;
    }

    public Boolean hasPodRecords() {
        return podRecords != null && !podRecords.isEmpty();
    }

    public ExperimentStatusFluent.PodRecordsNested<A> addNewPodRecord() {
        return new PodRecordsNestedImpl();
    }

    public ExperimentStatusFluent.PodRecordsNested<A> addNewPodRecordLike(PodStatus item) {
        return new PodRecordsNestedImpl(-1, item);
    }

    public ExperimentStatusFluent.PodRecordsNested<A> setNewPodRecordLike(int index,PodStatus item) {
        return new PodRecordsNestedImpl(index, item);
    }

    public ExperimentStatusFluent.PodRecordsNested<A> editPodRecord(int index) {
        if (podRecords.size() <= index) throw new RuntimeException("Can't edit podRecords. Index exceeds size.");
        return setNewPodRecordLike(index, buildPodRecord(index));
    }

    public ExperimentStatusFluent.PodRecordsNested<A> editFirstPodRecord() {
        if (podRecords.size() == 0) throw new RuntimeException("Can't edit first podRecords. The list is empty.");
        return setNewPodRecordLike(0, buildPodRecord(0));
    }

    public ExperimentStatusFluent.PodRecordsNested<A> editLastPodRecord() {
        int index = podRecords.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last podRecords. The list is empty.");
        return setNewPodRecordLike(index, buildPodRecord(index));
    }

    public ExperimentStatusFluent.PodRecordsNested<A> editMatchingPodRecord(Predicate<PodStatusBuilder> predicate) {
        int index = -1;
        for (int i=0;i<podRecords.size();i++) { 
        if (predicate.test(podRecords.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching podRecords. No match found.");
        return setNewPodRecordLike(index, buildPodRecord(index));
    }

    public String getReason() {
        return this.reason;
    }

    public A withReason(String reason) {
        this.reason=reason; return (A) this;
    }

    public Boolean hasReason() {
        return this.reason != null;
    }

    public A withNewReason(StringBuilder arg1) {
        return (A)withReason(new String(arg1));
    }

    public A withNewReason(int[] arg1,int arg2,int arg3) {
        return (A)withReason(new String(arg1, arg2, arg3));
    }

    public A withNewReason(char[] arg1) {
        return (A)withReason(new String(arg1));
    }

    public A withNewReason(StringBuffer arg1) {
        return (A)withReason(new String(arg1));
    }

    public A withNewReason(byte[] arg1,int arg2) {
        return (A)withReason(new String(arg1, arg2));
    }

    public A withNewReason(byte[] arg1) {
        return (A)withReason(new String(arg1));
    }

    public A withNewReason(char[] arg1,int arg2,int arg3) {
        return (A)withReason(new String(arg1, arg2, arg3));
    }

    public A withNewReason(byte[] arg1,int arg2,int arg3) {
        return (A)withReason(new String(arg1, arg2, arg3));
    }

    public A withNewReason(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withReason(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewReason(String arg1) {
        return (A)withReason(new String(arg1));
    }

    public String getStartTime() {
        return this.startTime;
    }

    public A withStartTime(String startTime) {
        this.startTime=startTime; return (A) this;
    }

    public Boolean hasStartTime() {
        return this.startTime != null;
    }

    public A withNewStartTime(StringBuilder arg1) {
        return (A)withStartTime(new String(arg1));
    }

    public A withNewStartTime(int[] arg1,int arg2,int arg3) {
        return (A)withStartTime(new String(arg1, arg2, arg3));
    }

    public A withNewStartTime(char[] arg1) {
        return (A)withStartTime(new String(arg1));
    }

    public A withNewStartTime(StringBuffer arg1) {
        return (A)withStartTime(new String(arg1));
    }

    public A withNewStartTime(byte[] arg1,int arg2) {
        return (A)withStartTime(new String(arg1, arg2));
    }

    public A withNewStartTime(byte[] arg1) {
        return (A)withStartTime(new String(arg1));
    }

    public A withNewStartTime(char[] arg1,int arg2,int arg3) {
        return (A)withStartTime(new String(arg1, arg2, arg3));
    }

    public A withNewStartTime(byte[] arg1,int arg2,int arg3) {
        return (A)withStartTime(new String(arg1, arg2, arg3));
    }

    public A withNewStartTime(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withStartTime(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewStartTime(String arg1) {
        return (A)withStartTime(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        ExperimentStatusFluentImpl that = (ExperimentStatusFluentImpl) o;
        if (duration != null ? !duration.equals(that.duration) :that.duration != null) return false;
        if (endTime != null ? !endTime.equals(that.endTime) :that.endTime != null) return false;
        if (phase != null ? !phase.equals(that.phase) :that.phase != null) return false;
        if (podRecords != null ? !podRecords.equals(that.podRecords) :that.podRecords != null) return false;
        if (reason != null ? !reason.equals(that.reason) :that.reason != null) return false;
        if (startTime != null ? !startTime.equals(that.startTime) :that.startTime != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(duration,  endTime,  phase,  podRecords,  reason,  startTime,  super.hashCode());
    }

    public class PodRecordsNestedImpl<N> extends PodStatusFluentImpl<ExperimentStatusFluent.PodRecordsNested<N>> implements ExperimentStatusFluent.PodRecordsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final PodStatusBuilder builder;
        private final int index;

            PodRecordsNestedImpl(int index,PodStatus item) {
                this.index = index;
                this.builder = new PodStatusBuilder(this, item);
                        
            }

            PodRecordsNestedImpl() {
                this.index = -1;
                this.builder = new PodStatusBuilder(this);
                        
            }

            public N and() {
                return (N) ExperimentStatusFluentImpl.this.setToPodRecords(index,builder.build());
            }

            public N endPodRecord() {
                return and();
            }
    }


}
