package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ScheduleStatusBuilder extends ScheduleStatusFluentImpl<ScheduleStatusBuilder> implements VisitableBuilder<ScheduleStatus,ScheduleStatusBuilder> {

    ScheduleStatusFluent<?> fluent;
    Boolean validationEnabled;

    public ScheduleStatusBuilder() {
        this(true);
    }

    public ScheduleStatusBuilder(Boolean validationEnabled) {
        this(new ScheduleStatus(), validationEnabled);
    }

    public ScheduleStatusBuilder(ScheduleStatusFluent<?> fluent) {
        this(fluent, true);
    }

    public ScheduleStatusBuilder(ScheduleStatusFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new ScheduleStatus(), validationEnabled);
    }

    public ScheduleStatusBuilder(ScheduleStatusFluent<?> fluent,ScheduleStatus instance) {
        this(fluent, instance, true);
    }

    public ScheduleStatusBuilder(ScheduleStatusFluent<?> fluent,ScheduleStatus instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withNextRecover(instance.getNextRecover()); 
        fluent.withNextStart(instance.getNextStart()); 
        this.validationEnabled = validationEnabled; 
    }

    public ScheduleStatusBuilder(ScheduleStatus instance) {
        this(instance,true);
    }

    public ScheduleStatusBuilder(ScheduleStatus instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withNextRecover(instance.getNextRecover()); 
        this.withNextStart(instance.getNextStart()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.chaosmesh.v1alpha1.EditableScheduleStatus build() {
        EditableScheduleStatus buildable = new EditableScheduleStatus(fluent.getNextRecover(),fluent.getNextStart());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        ScheduleStatusBuilder that = (ScheduleStatusBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
