package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.lang.StringBuffer;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;

public class PodIoChaosSpecFluentImpl<A extends PodIoChaosSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements PodIoChaosSpecFluent<A> {

    private List<IoChaosActionBuilder> actions;
    private String container;
    private Long pid;
    private Long startTime;
    private String volumeMountPath;

    public PodIoChaosSpecFluentImpl() {
    }

    public PodIoChaosSpecFluentImpl(PodIoChaosSpec instance) {
        this.withActions(instance.getActions()); 
        this.withContainer(instance.getContainer()); 
        this.withPid(instance.getPid()); 
        this.withStartTime(instance.getStartTime()); 
        this.withVolumeMountPath(instance.getVolumeMountPath()); 
    }

    public A addToActions(int index,IoChaosAction item) {
        if (this.actions == null) {this.actions = new ArrayList<IoChaosActionBuilder>();}
        IoChaosActionBuilder builder = new IoChaosActionBuilder(item);_visitables.get("actions").add(index >= 0 ? index : _visitables.get("actions").size(), builder);this.actions.add(index >= 0 ? index : actions.size(), builder); return (A)this;
    }

    public A setToActions(int index,IoChaosAction item) {
        if (this.actions == null) {this.actions = new ArrayList<IoChaosActionBuilder>();}
        IoChaosActionBuilder builder = new IoChaosActionBuilder(item);
        if (index < 0 || index >= _visitables.get("actions").size()) { _visitables.get("actions").add(builder); } else { _visitables.get("actions").set(index, builder);}
        if (index < 0 || index >= actions.size()) { actions.add(builder); } else { actions.set(index, builder);}
         return (A)this;
    }

    public A addToActions(IoChaosAction... items) {
        if (this.actions == null) {this.actions = new ArrayList<IoChaosActionBuilder>();}
        for (IoChaosAction item : items) {IoChaosActionBuilder builder = new IoChaosActionBuilder(item);_visitables.get("actions").add(builder);this.actions.add(builder);} return (A)this;
    }

    public A addAllToActions(Collection<IoChaosAction> items) {
        if (this.actions == null) {this.actions = new ArrayList<IoChaosActionBuilder>();}
        for (IoChaosAction item : items) {IoChaosActionBuilder builder = new IoChaosActionBuilder(item);_visitables.get("actions").add(builder);this.actions.add(builder);} return (A)this;
    }

    public A removeFromActions(IoChaosAction... items) {
        for (IoChaosAction item : items) {IoChaosActionBuilder builder = new IoChaosActionBuilder(item);_visitables.get("actions").remove(builder);if (this.actions != null) {this.actions.remove(builder);}} return (A)this;
    }

    public A removeAllFromActions(Collection<IoChaosAction> items) {
        for (IoChaosAction item : items) {IoChaosActionBuilder builder = new IoChaosActionBuilder(item);_visitables.get("actions").remove(builder);if (this.actions != null) {this.actions.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromActions(Predicate<IoChaosActionBuilder> predicate) {
        if (actions == null) return (A) this;
        final Iterator<IoChaosActionBuilder> each = actions.iterator();
        final List visitables = _visitables.get("actions");
        while (each.hasNext()) {
          IoChaosActionBuilder builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildActions instead.
 * @return The buildable object.
 */
@Deprecated public List<IoChaosAction> getActions() {
        return build(actions);
    }

    public List<IoChaosAction> buildActions() {
        return build(actions);
    }

    public IoChaosAction buildAction(int index) {
        return this.actions.get(index).build();
    }

    public IoChaosAction buildFirstAction() {
        return this.actions.get(0).build();
    }

    public IoChaosAction buildLastAction() {
        return this.actions.get(actions.size() - 1).build();
    }

    public IoChaosAction buildMatchingAction(Predicate<IoChaosActionBuilder> predicate) {
        for (IoChaosActionBuilder item: actions) { if(predicate.test(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingAction(Predicate<IoChaosActionBuilder> predicate) {
        for (IoChaosActionBuilder item: actions) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withActions(List<IoChaosAction> actions) {
        if (this.actions != null) { _visitables.get("actions").removeAll(this.actions);}
        if (actions != null) {this.actions = new ArrayList<IoChaosActionBuilder>(); for (IoChaosAction item : actions){this.addToActions(item);}} else { this.actions = null;} return (A) this;
    }

    public A withActions(IoChaosAction... actions) {
        if (this.actions != null) {this.actions.clear();}
        if (actions != null) {for (IoChaosAction item :actions){ this.addToActions(item);}} return (A) this;
    }

    public Boolean hasActions() {
        return actions != null && !actions.isEmpty();
    }

    public PodIoChaosSpecFluent.ActionsNested<A> addNewAction() {
        return new ActionsNestedImpl();
    }

    public PodIoChaosSpecFluent.ActionsNested<A> addNewActionLike(IoChaosAction item) {
        return new ActionsNestedImpl(-1, item);
    }

    public PodIoChaosSpecFluent.ActionsNested<A> setNewActionLike(int index,IoChaosAction item) {
        return new ActionsNestedImpl(index, item);
    }

    public PodIoChaosSpecFluent.ActionsNested<A> editAction(int index) {
        if (actions.size() <= index) throw new RuntimeException("Can't edit actions. Index exceeds size.");
        return setNewActionLike(index, buildAction(index));
    }

    public PodIoChaosSpecFluent.ActionsNested<A> editFirstAction() {
        if (actions.size() == 0) throw new RuntimeException("Can't edit first actions. The list is empty.");
        return setNewActionLike(0, buildAction(0));
    }

    public PodIoChaosSpecFluent.ActionsNested<A> editLastAction() {
        int index = actions.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last actions. The list is empty.");
        return setNewActionLike(index, buildAction(index));
    }

    public PodIoChaosSpecFluent.ActionsNested<A> editMatchingAction(Predicate<IoChaosActionBuilder> predicate) {
        int index = -1;
        for (int i=0;i<actions.size();i++) { 
        if (predicate.test(actions.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching actions. No match found.");
        return setNewActionLike(index, buildAction(index));
    }

    public String getContainer() {
        return this.container;
    }

    public A withContainer(String container) {
        this.container=container; return (A) this;
    }

    public Boolean hasContainer() {
        return this.container != null;
    }

    public A withNewContainer(String arg1) {
        return (A)withContainer(new String(arg1));
    }

    public A withNewContainer(StringBuilder arg1) {
        return (A)withContainer(new String(arg1));
    }

    public A withNewContainer(StringBuffer arg1) {
        return (A)withContainer(new String(arg1));
    }

    public Long getPid() {
        return this.pid;
    }

    public A withPid(Long pid) {
        this.pid=pid; return (A) this;
    }

    public Boolean hasPid() {
        return this.pid != null;
    }

    public A withNewPid(String arg1) {
        return (A)withPid(new Long(arg1));
    }

    public A withNewPid(long arg1) {
        return (A)withPid(new Long(arg1));
    }

    public Long getStartTime() {
        return this.startTime;
    }

    public A withStartTime(Long startTime) {
        this.startTime=startTime; return (A) this;
    }

    public Boolean hasStartTime() {
        return this.startTime != null;
    }

    public A withNewStartTime(String arg1) {
        return (A)withStartTime(new Long(arg1));
    }

    public A withNewStartTime(long arg1) {
        return (A)withStartTime(new Long(arg1));
    }

    public String getVolumeMountPath() {
        return this.volumeMountPath;
    }

    public A withVolumeMountPath(String volumeMountPath) {
        this.volumeMountPath=volumeMountPath; return (A) this;
    }

    public Boolean hasVolumeMountPath() {
        return this.volumeMountPath != null;
    }

    public A withNewVolumeMountPath(String arg1) {
        return (A)withVolumeMountPath(new String(arg1));
    }

    public A withNewVolumeMountPath(StringBuilder arg1) {
        return (A)withVolumeMountPath(new String(arg1));
    }

    public A withNewVolumeMountPath(StringBuffer arg1) {
        return (A)withVolumeMountPath(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        PodIoChaosSpecFluentImpl that = (PodIoChaosSpecFluentImpl) o;
        if (actions != null ? !actions.equals(that.actions) :that.actions != null) return false;
        if (container != null ? !container.equals(that.container) :that.container != null) return false;
        if (pid != null ? !pid.equals(that.pid) :that.pid != null) return false;
        if (startTime != null ? !startTime.equals(that.startTime) :that.startTime != null) return false;
        if (volumeMountPath != null ? !volumeMountPath.equals(that.volumeMountPath) :that.volumeMountPath != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(actions,  container,  pid,  startTime,  volumeMountPath,  super.hashCode());
    }

    public class ActionsNestedImpl<N> extends IoChaosActionFluentImpl<PodIoChaosSpecFluent.ActionsNested<N>> implements PodIoChaosSpecFluent.ActionsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final IoChaosActionBuilder builder;
        private final int index;

            ActionsNestedImpl(int index,IoChaosAction item) {
                this.index = index;
                this.builder = new IoChaosActionBuilder(this, item);
                        
            }

            ActionsNestedImpl() {
                this.index = -1;
                this.builder = new IoChaosActionBuilder(this);
                        
            }

            public N and() {
                return (N) PodIoChaosSpecFluentImpl.this.setToActions(index,builder.build());
            }

            public N endAction() {
                return and();
            }
    }


}
