package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import java.lang.Long;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

public interface PodIoChaosSpecFluent<A extends PodIoChaosSpecFluent<A>> extends Fluent<A> {


    public A addToActions(int index,IoChaosAction item);
    public A setToActions(int index,IoChaosAction item);
    public A addToActions(IoChaosAction... items);
    public A addAllToActions(Collection<IoChaosAction> items);
    public A removeFromActions(IoChaosAction... items);
    public A removeAllFromActions(Collection<IoChaosAction> items);
    public A removeMatchingFromActions(Predicate<IoChaosActionBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildActions instead.
 * @return The buildable object.
 */
@Deprecated public List<IoChaosAction> getActions();
    public List<IoChaosAction> buildActions();
    public IoChaosAction buildAction(int index);
    public IoChaosAction buildFirstAction();
    public IoChaosAction buildLastAction();
    public IoChaosAction buildMatchingAction(Predicate<IoChaosActionBuilder> predicate);
    public Boolean hasMatchingAction(Predicate<IoChaosActionBuilder> predicate);
    public A withActions(List<IoChaosAction> actions);
    public A withActions(IoChaosAction... actions);
    public Boolean hasActions();
    public PodIoChaosSpecFluent.ActionsNested<A> addNewAction();
    public PodIoChaosSpecFluent.ActionsNested<A> addNewActionLike(IoChaosAction item);
    public PodIoChaosSpecFluent.ActionsNested<A> setNewActionLike(int index,IoChaosAction item);
    public PodIoChaosSpecFluent.ActionsNested<A> editAction(int index);
    public PodIoChaosSpecFluent.ActionsNested<A> editFirstAction();
    public PodIoChaosSpecFluent.ActionsNested<A> editLastAction();
    public PodIoChaosSpecFluent.ActionsNested<A> editMatchingAction(Predicate<IoChaosActionBuilder> predicate);
    public String getContainer();
    public A withContainer(String container);
    public Boolean hasContainer();
    public A withNewContainer(String arg1);
    public A withNewContainer(StringBuilder arg1);
    public A withNewContainer(StringBuffer arg1);
    public Long getPid();
    public A withPid(Long pid);
    public Boolean hasPid();
    public A withNewPid(String arg1);
    public A withNewPid(long arg1);
    public Long getStartTime();
    public A withStartTime(Long startTime);
    public Boolean hasStartTime();
    public A withNewStartTime(String arg1);
    public A withNewStartTime(long arg1);
    public String getVolumeMountPath();
    public A withVolumeMountPath(String volumeMountPath);
    public Boolean hasVolumeMountPath();
    public A withNewVolumeMountPath(String arg1);
    public A withNewVolumeMountPath(StringBuilder arg1);
    public A withNewVolumeMountPath(StringBuffer arg1);
    public interface ActionsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,IoChaosActionFluent<PodIoChaosSpecFluent.ActionsNested<N>> {

            public N and();
            public N endAction();    }


}
