package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class PodIoChaosBuilder extends PodIoChaosFluentImpl<PodIoChaosBuilder> implements VisitableBuilder<PodIoChaos,PodIoChaosBuilder> {

    PodIoChaosFluent<?> fluent;
    Boolean validationEnabled;

    public PodIoChaosBuilder() {
        this(true);
    }

    public PodIoChaosBuilder(Boolean validationEnabled) {
        this(new PodIoChaos(), validationEnabled);
    }

    public PodIoChaosBuilder(PodIoChaosFluent<?> fluent) {
        this(fluent, true);
    }

    public PodIoChaosBuilder(PodIoChaosFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new PodIoChaos(), validationEnabled);
    }

    public PodIoChaosBuilder(PodIoChaosFluent<?> fluent,PodIoChaos instance) {
        this(fluent, instance, true);
    }

    public PodIoChaosBuilder(PodIoChaosFluent<?> fluent,PodIoChaos instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion()); 
        fluent.withKind(instance.getKind()); 
        fluent.withMetadata(instance.getMetadata()); 
        fluent.withSpec(instance.getSpec()); 
        this.validationEnabled = validationEnabled; 
    }

    public PodIoChaosBuilder(PodIoChaos instance) {
        this(instance,true);
    }

    public PodIoChaosBuilder(PodIoChaos instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.withSpec(instance.getSpec()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.chaosmesh.v1alpha1.EditablePodIoChaos build() {
        EditablePodIoChaos buildable = new EditablePodIoChaos(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        PodIoChaosBuilder that = (PodIoChaosBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
