
package io.fabric8.chaosmesh.v1alpha1;

import java.util.HashMap;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.ContainerPort;
import io.fabric8.kubernetes.api.model.EnvVar;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import io.fabric8.kubernetes.api.model.LabelSelector;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.Volume;
import io.fabric8.kubernetes.api.model.VolumeMount;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import lombok.EqualsAndHashCode;
import lombok.ToString;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "after",
    "area",
    "block",
    "classname",
    "interval",
    "methodname",
    "wildmode"
})
@JsonDeserialize(using = com.fasterxml.jackson.databind.JsonDeserializer.None.class)
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = true, validationEnabled = false, generateBuilderPackage = false, builderPackage = "io.fabric8.kubernetes.api.builder", refs = {
    @BuildableReference(ObjectMeta.class),
    @BuildableReference(LabelSelector.class),
    @BuildableReference(Container.class),
    @BuildableReference(EnvVar.class),
    @BuildableReference(ContainerPort.class),
    @BuildableReference(Volume.class),
    @BuildableReference(VolumeMount.class)
})
public class JVMOOMSpec implements KubernetesResource
{

    @JsonProperty("after")
    private Boolean after;
    @JsonProperty("area")
    private String area;
    @JsonProperty("block")
    private String block;
    @JsonProperty("classname")
    private String classname;
    @JsonProperty("interval")
    private Integer interval;
    @JsonProperty("methodname")
    private String methodname;
    @JsonProperty("wildmode")
    private Boolean wildmode;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    /**
     * No args constructor for use in serialization
     * 
     */
    public JVMOOMSpec() {
    }

    /**
     * 
     * @param area
     * @param classname
     * @param wildmode
     * @param block
     * @param interval
     * @param after
     * @param methodname
     */
    public JVMOOMSpec(Boolean after, String area, String block, String classname, Integer interval, String methodname, Boolean wildmode) {
        super();
        this.after = after;
        this.area = area;
        this.block = block;
        this.classname = classname;
        this.interval = interval;
        this.methodname = methodname;
        this.wildmode = wildmode;
    }

    @JsonProperty("after")
    public Boolean getAfter() {
        return after;
    }

    @JsonProperty("after")
    public void setAfter(Boolean after) {
        this.after = after;
    }

    @JsonProperty("area")
    public String getArea() {
        return area;
    }

    @JsonProperty("area")
    public void setArea(String area) {
        this.area = area;
    }

    @JsonProperty("block")
    public String getBlock() {
        return block;
    }

    @JsonProperty("block")
    public void setBlock(String block) {
        this.block = block;
    }

    @JsonProperty("classname")
    public String getClassname() {
        return classname;
    }

    @JsonProperty("classname")
    public void setClassname(String classname) {
        this.classname = classname;
    }

    @JsonProperty("interval")
    public Integer getInterval() {
        return interval;
    }

    @JsonProperty("interval")
    public void setInterval(Integer interval) {
        this.interval = interval;
    }

    @JsonProperty("methodname")
    public String getMethodname() {
        return methodname;
    }

    @JsonProperty("methodname")
    public void setMethodname(String methodname) {
        this.methodname = methodname;
    }

    @JsonProperty("wildmode")
    public Boolean getWildmode() {
        return wildmode;
    }

    @JsonProperty("wildmode")
    public void setWildmode(Boolean wildmode) {
        this.wildmode = wildmode;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

}
