package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class JVMCpufullloadSpecBuilder extends JVMCpufullloadSpecFluentImpl<JVMCpufullloadSpecBuilder> implements VisitableBuilder<JVMCpufullloadSpec,JVMCpufullloadSpecBuilder> {

    JVMCpufullloadSpecFluent<?> fluent;
    Boolean validationEnabled;

    public JVMCpufullloadSpecBuilder() {
        this(true);
    }

    public JVMCpufullloadSpecBuilder(Boolean validationEnabled) {
        this(new JVMCpufullloadSpec(), validationEnabled);
    }

    public JVMCpufullloadSpecBuilder(JVMCpufullloadSpecFluent<?> fluent) {
        this(fluent, true);
    }

    public JVMCpufullloadSpecBuilder(JVMCpufullloadSpecFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new JVMCpufullloadSpec(), validationEnabled);
    }

    public JVMCpufullloadSpecBuilder(JVMCpufullloadSpecFluent<?> fluent,JVMCpufullloadSpec instance) {
        this(fluent, instance, true);
    }

    public JVMCpufullloadSpecBuilder(JVMCpufullloadSpecFluent<?> fluent,JVMCpufullloadSpec instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withAfter(instance.getAfter()); 
        fluent.withClassname(instance.getClassname()); 
        fluent.withCpucount(instance.getCpucount()); 
        fluent.withMethodname(instance.getMethodname()); 
        this.validationEnabled = validationEnabled; 
    }

    public JVMCpufullloadSpecBuilder(JVMCpufullloadSpec instance) {
        this(instance,true);
    }

    public JVMCpufullloadSpecBuilder(JVMCpufullloadSpec instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withAfter(instance.getAfter()); 
        this.withClassname(instance.getClassname()); 
        this.withCpucount(instance.getCpucount()); 
        this.withMethodname(instance.getMethodname()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.chaosmesh.v1alpha1.EditableJVMCpufullloadSpec build() {
        EditableJVMCpufullloadSpec buildable = new EditableJVMCpufullloadSpec(fluent.isAfter(),fluent.getClassname(),fluent.getCpucount(),fluent.getMethodname());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        JVMCpufullloadSpecBuilder that = (JVMCpufullloadSpecBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
