package io.fabric8.chaosmesh.v1alpha1;

import java.lang.Integer;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;

public class IoFaultFluentImpl<A extends IoFaultFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements IoFaultFluent<A> {

    private Integer errno;
    private Integer weight;

    public IoFaultFluentImpl() {
    }

    public IoFaultFluentImpl(IoFault instance) {
        this.withErrno(instance.getErrno()); 
        this.withWeight(instance.getWeight()); 
    }

    public Integer getErrno() {
        return this.errno;
    }

    public A withErrno(Integer errno) {
        this.errno=errno; return (A) this;
    }

    public Boolean hasErrno() {
        return this.errno != null;
    }

    public A withNewErrno(String arg1) {
        return (A)withErrno(new Integer(arg1));
    }

    public A withNewErrno(int arg1) {
        return (A)withErrno(new Integer(arg1));
    }

    public Integer getWeight() {
        return this.weight;
    }

    public A withWeight(Integer weight) {
        this.weight=weight; return (A) this;
    }

    public Boolean hasWeight() {
        return this.weight != null;
    }

    public A withNewWeight(String arg1) {
        return (A)withWeight(new Integer(arg1));
    }

    public A withNewWeight(int arg1) {
        return (A)withWeight(new Integer(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        IoFaultFluentImpl that = (IoFaultFluentImpl) o;
        if (errno != null ? !errno.equals(that.errno) :that.errno != null) return false;
        if (weight != null ? !weight.equals(that.weight) :that.weight != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(errno,  weight,  super.hashCode());
    }

}
