package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.lang.Integer;
import java.lang.StringBuffer;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;

public class IoChaosActionFluentImpl<A extends IoChaosActionFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements IoChaosActionFluent<A> {

    private TimespecBuilder atime;
    private Long blocks;
    private TimespecBuilder ctime;
    private List<IoFaultBuilder> faults;
    private Long gid;
    private Long ino;
    private String kind;
    private String latency;
    private List<String> methods;
    private TimespecBuilder mtime;
    private Long nlink;
    private String path;
    private Integer percent;
    private Integer perm;
    private Long rdev;
    private Long size;
    private String source;
    private String type;
    private Long uid;

    public IoChaosActionFluentImpl() {
    }

    public IoChaosActionFluentImpl(IoChaosAction instance) {
        this.withAtime(instance.getAtime()); 
        this.withBlocks(instance.getBlocks()); 
        this.withCtime(instance.getCtime()); 
        this.withFaults(instance.getFaults()); 
        this.withGid(instance.getGid()); 
        this.withIno(instance.getIno()); 
        this.withKind(instance.getKind()); 
        this.withLatency(instance.getLatency()); 
        this.withMethods(instance.getMethods()); 
        this.withMtime(instance.getMtime()); 
        this.withNlink(instance.getNlink()); 
        this.withPath(instance.getPath()); 
        this.withPercent(instance.getPercent()); 
        this.withPerm(instance.getPerm()); 
        this.withRdev(instance.getRdev()); 
        this.withSize(instance.getSize()); 
        this.withSource(instance.getSource()); 
        this.withType(instance.getType()); 
        this.withUid(instance.getUid()); 
    }

    
/**
 * This method has been deprecated, please use method buildAtime instead.
 * @return The buildable object.
 */
@Deprecated public Timespec getAtime() {
        return this.atime!=null?this.atime.build():null;
    }

    public Timespec buildAtime() {
        return this.atime!=null?this.atime.build():null;
    }

    public A withAtime(Timespec atime) {
        _visitables.get("atime").remove(this.atime);
        if (atime!=null){ this.atime= new TimespecBuilder(atime); _visitables.get("atime").add(this.atime);} return (A) this;
    }

    public Boolean hasAtime() {
        return this.atime != null;
    }

    public A withNewAtime(Long nsec,Long sec) {
        return (A)withAtime(new Timespec(nsec, sec));
    }

    public IoChaosActionFluent.AtimeNested<A> withNewAtime() {
        return new AtimeNestedImpl();
    }

    public IoChaosActionFluent.AtimeNested<A> withNewAtimeLike(Timespec item) {
        return new AtimeNestedImpl(item);
    }

    public IoChaosActionFluent.AtimeNested<A> editAtime() {
        return withNewAtimeLike(getAtime());
    }

    public IoChaosActionFluent.AtimeNested<A> editOrNewAtime() {
        return withNewAtimeLike(getAtime() != null ? getAtime(): new TimespecBuilder().build());
    }

    public IoChaosActionFluent.AtimeNested<A> editOrNewAtimeLike(Timespec item) {
        return withNewAtimeLike(getAtime() != null ? getAtime(): item);
    }

    public Long getBlocks() {
        return this.blocks;
    }

    public A withBlocks(Long blocks) {
        this.blocks=blocks; return (A) this;
    }

    public Boolean hasBlocks() {
        return this.blocks != null;
    }

    public A withNewBlocks(String arg1) {
        return (A)withBlocks(new Long(arg1));
    }

    public A withNewBlocks(long arg1) {
        return (A)withBlocks(new Long(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildCtime instead.
 * @return The buildable object.
 */
@Deprecated public Timespec getCtime() {
        return this.ctime!=null?this.ctime.build():null;
    }

    public Timespec buildCtime() {
        return this.ctime!=null?this.ctime.build():null;
    }

    public A withCtime(Timespec ctime) {
        _visitables.get("ctime").remove(this.ctime);
        if (ctime!=null){ this.ctime= new TimespecBuilder(ctime); _visitables.get("ctime").add(this.ctime);} return (A) this;
    }

    public Boolean hasCtime() {
        return this.ctime != null;
    }

    public A withNewCtime(Long nsec,Long sec) {
        return (A)withCtime(new Timespec(nsec, sec));
    }

    public IoChaosActionFluent.CtimeNested<A> withNewCtime() {
        return new CtimeNestedImpl();
    }

    public IoChaosActionFluent.CtimeNested<A> withNewCtimeLike(Timespec item) {
        return new CtimeNestedImpl(item);
    }

    public IoChaosActionFluent.CtimeNested<A> editCtime() {
        return withNewCtimeLike(getCtime());
    }

    public IoChaosActionFluent.CtimeNested<A> editOrNewCtime() {
        return withNewCtimeLike(getCtime() != null ? getCtime(): new TimespecBuilder().build());
    }

    public IoChaosActionFluent.CtimeNested<A> editOrNewCtimeLike(Timespec item) {
        return withNewCtimeLike(getCtime() != null ? getCtime(): item);
    }

    public A addToFaults(int index,IoFault item) {
        if (this.faults == null) {this.faults = new ArrayList<IoFaultBuilder>();}
        IoFaultBuilder builder = new IoFaultBuilder(item);_visitables.get("faults").add(index >= 0 ? index : _visitables.get("faults").size(), builder);this.faults.add(index >= 0 ? index : faults.size(), builder); return (A)this;
    }

    public A setToFaults(int index,IoFault item) {
        if (this.faults == null) {this.faults = new ArrayList<IoFaultBuilder>();}
        IoFaultBuilder builder = new IoFaultBuilder(item);
        if (index < 0 || index >= _visitables.get("faults").size()) { _visitables.get("faults").add(builder); } else { _visitables.get("faults").set(index, builder);}
        if (index < 0 || index >= faults.size()) { faults.add(builder); } else { faults.set(index, builder);}
         return (A)this;
    }

    public A addToFaults(IoFault... items) {
        if (this.faults == null) {this.faults = new ArrayList<IoFaultBuilder>();}
        for (IoFault item : items) {IoFaultBuilder builder = new IoFaultBuilder(item);_visitables.get("faults").add(builder);this.faults.add(builder);} return (A)this;
    }

    public A addAllToFaults(Collection<IoFault> items) {
        if (this.faults == null) {this.faults = new ArrayList<IoFaultBuilder>();}
        for (IoFault item : items) {IoFaultBuilder builder = new IoFaultBuilder(item);_visitables.get("faults").add(builder);this.faults.add(builder);} return (A)this;
    }

    public A removeFromFaults(IoFault... items) {
        for (IoFault item : items) {IoFaultBuilder builder = new IoFaultBuilder(item);_visitables.get("faults").remove(builder);if (this.faults != null) {this.faults.remove(builder);}} return (A)this;
    }

    public A removeAllFromFaults(Collection<IoFault> items) {
        for (IoFault item : items) {IoFaultBuilder builder = new IoFaultBuilder(item);_visitables.get("faults").remove(builder);if (this.faults != null) {this.faults.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromFaults(Predicate<IoFaultBuilder> predicate) {
        if (faults == null) return (A) this;
        final Iterator<IoFaultBuilder> each = faults.iterator();
        final List visitables = _visitables.get("faults");
        while (each.hasNext()) {
          IoFaultBuilder builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildFaults instead.
 * @return The buildable object.
 */
@Deprecated public List<IoFault> getFaults() {
        return build(faults);
    }

    public List<IoFault> buildFaults() {
        return build(faults);
    }

    public IoFault buildFault(int index) {
        return this.faults.get(index).build();
    }

    public IoFault buildFirstFault() {
        return this.faults.get(0).build();
    }

    public IoFault buildLastFault() {
        return this.faults.get(faults.size() - 1).build();
    }

    public IoFault buildMatchingFault(Predicate<IoFaultBuilder> predicate) {
        for (IoFaultBuilder item: faults) { if(predicate.test(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingFault(Predicate<IoFaultBuilder> predicate) {
        for (IoFaultBuilder item: faults) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withFaults(List<IoFault> faults) {
        if (this.faults != null) { _visitables.get("faults").removeAll(this.faults);}
        if (faults != null) {this.faults = new ArrayList<IoFaultBuilder>(); for (IoFault item : faults){this.addToFaults(item);}} else { this.faults = null;} return (A) this;
    }

    public A withFaults(IoFault... faults) {
        if (this.faults != null) {this.faults.clear();}
        if (faults != null) {for (IoFault item :faults){ this.addToFaults(item);}} return (A) this;
    }

    public Boolean hasFaults() {
        return faults != null && !faults.isEmpty();
    }

    public A addNewFault(Integer errno,Integer weight) {
        return (A)addToFaults(new IoFault(errno, weight));
    }

    public IoChaosActionFluent.FaultsNested<A> addNewFault() {
        return new FaultsNestedImpl();
    }

    public IoChaosActionFluent.FaultsNested<A> addNewFaultLike(IoFault item) {
        return new FaultsNestedImpl(-1, item);
    }

    public IoChaosActionFluent.FaultsNested<A> setNewFaultLike(int index,IoFault item) {
        return new FaultsNestedImpl(index, item);
    }

    public IoChaosActionFluent.FaultsNested<A> editFault(int index) {
        if (faults.size() <= index) throw new RuntimeException("Can't edit faults. Index exceeds size.");
        return setNewFaultLike(index, buildFault(index));
    }

    public IoChaosActionFluent.FaultsNested<A> editFirstFault() {
        if (faults.size() == 0) throw new RuntimeException("Can't edit first faults. The list is empty.");
        return setNewFaultLike(0, buildFault(0));
    }

    public IoChaosActionFluent.FaultsNested<A> editLastFault() {
        int index = faults.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last faults. The list is empty.");
        return setNewFaultLike(index, buildFault(index));
    }

    public IoChaosActionFluent.FaultsNested<A> editMatchingFault(Predicate<IoFaultBuilder> predicate) {
        int index = -1;
        for (int i=0;i<faults.size();i++) { 
        if (predicate.test(faults.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching faults. No match found.");
        return setNewFaultLike(index, buildFault(index));
    }

    public Long getGid() {
        return this.gid;
    }

    public A withGid(Long gid) {
        this.gid=gid; return (A) this;
    }

    public Boolean hasGid() {
        return this.gid != null;
    }

    public A withNewGid(String arg1) {
        return (A)withGid(new Long(arg1));
    }

    public A withNewGid(long arg1) {
        return (A)withGid(new Long(arg1));
    }

    public Long getIno() {
        return this.ino;
    }

    public A withIno(Long ino) {
        this.ino=ino; return (A) this;
    }

    public Boolean hasIno() {
        return this.ino != null;
    }

    public A withNewIno(String arg1) {
        return (A)withIno(new Long(arg1));
    }

    public A withNewIno(long arg1) {
        return (A)withIno(new Long(arg1));
    }

    public String getKind() {
        return this.kind;
    }

    public A withKind(String kind) {
        this.kind=kind; return (A) this;
    }

    public Boolean hasKind() {
        return this.kind != null;
    }

    public A withNewKind(String arg1) {
        return (A)withKind(new String(arg1));
    }

    public A withNewKind(StringBuilder arg1) {
        return (A)withKind(new String(arg1));
    }

    public A withNewKind(StringBuffer arg1) {
        return (A)withKind(new String(arg1));
    }

    public String getLatency() {
        return this.latency;
    }

    public A withLatency(String latency) {
        this.latency=latency; return (A) this;
    }

    public Boolean hasLatency() {
        return this.latency != null;
    }

    public A withNewLatency(String arg1) {
        return (A)withLatency(new String(arg1));
    }

    public A withNewLatency(StringBuilder arg1) {
        return (A)withLatency(new String(arg1));
    }

    public A withNewLatency(StringBuffer arg1) {
        return (A)withLatency(new String(arg1));
    }

    public A addToMethods(int index,String item) {
        if (this.methods == null) {this.methods = new ArrayList<String>();}
        this.methods.add(index, item);
        return (A)this;
    }

    public A setToMethods(int index,String item) {
        if (this.methods == null) {this.methods = new ArrayList<String>();}
        this.methods.set(index, item); return (A)this;
    }

    public A addToMethods(String... items) {
        if (this.methods == null) {this.methods = new ArrayList<String>();}
        for (String item : items) {this.methods.add(item);} return (A)this;
    }

    public A addAllToMethods(Collection<String> items) {
        if (this.methods == null) {this.methods = new ArrayList<String>();}
        for (String item : items) {this.methods.add(item);} return (A)this;
    }

    public A removeFromMethods(String... items) {
        for (String item : items) {if (this.methods!= null){ this.methods.remove(item);}} return (A)this;
    }

    public A removeAllFromMethods(Collection<String> items) {
        for (String item : items) {if (this.methods!= null){ this.methods.remove(item);}} return (A)this;
    }

    public List<String> getMethods() {
        return this.methods;
    }

    public String getMethod(int index) {
        return this.methods.get(index);
    }

    public String getFirstMethod() {
        return this.methods.get(0);
    }

    public String getLastMethod() {
        return this.methods.get(methods.size() - 1);
    }

    public String getMatchingMethod(Predicate<String> predicate) {
        for (String item: methods) { if(predicate.test(item)){ return item;} } return null;
    }

    public Boolean hasMatchingMethod(Predicate<String> predicate) {
        for (String item: methods) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withMethods(List<String> methods) {
        if (this.methods != null) { _visitables.get("methods").removeAll(this.methods);}
        if (methods != null) {this.methods = new ArrayList<String>(); for (String item : methods){this.addToMethods(item);}} else { this.methods = null;} return (A) this;
    }

    public A withMethods(String... methods) {
        if (this.methods != null) {this.methods.clear();}
        if (methods != null) {for (String item :methods){ this.addToMethods(item);}} return (A) this;
    }

    public Boolean hasMethods() {
        return methods != null && !methods.isEmpty();
    }

    public A addNewMethod(String arg1) {
        return (A)addToMethods(new String(arg1));
    }

    public A addNewMethod(StringBuilder arg1) {
        return (A)addToMethods(new String(arg1));
    }

    public A addNewMethod(StringBuffer arg1) {
        return (A)addToMethods(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildMtime instead.
 * @return The buildable object.
 */
@Deprecated public Timespec getMtime() {
        return this.mtime!=null?this.mtime.build():null;
    }

    public Timespec buildMtime() {
        return this.mtime!=null?this.mtime.build():null;
    }

    public A withMtime(Timespec mtime) {
        _visitables.get("mtime").remove(this.mtime);
        if (mtime!=null){ this.mtime= new TimespecBuilder(mtime); _visitables.get("mtime").add(this.mtime);} return (A) this;
    }

    public Boolean hasMtime() {
        return this.mtime != null;
    }

    public A withNewMtime(Long nsec,Long sec) {
        return (A)withMtime(new Timespec(nsec, sec));
    }

    public IoChaosActionFluent.MtimeNested<A> withNewMtime() {
        return new MtimeNestedImpl();
    }

    public IoChaosActionFluent.MtimeNested<A> withNewMtimeLike(Timespec item) {
        return new MtimeNestedImpl(item);
    }

    public IoChaosActionFluent.MtimeNested<A> editMtime() {
        return withNewMtimeLike(getMtime());
    }

    public IoChaosActionFluent.MtimeNested<A> editOrNewMtime() {
        return withNewMtimeLike(getMtime() != null ? getMtime(): new TimespecBuilder().build());
    }

    public IoChaosActionFluent.MtimeNested<A> editOrNewMtimeLike(Timespec item) {
        return withNewMtimeLike(getMtime() != null ? getMtime(): item);
    }

    public Long getNlink() {
        return this.nlink;
    }

    public A withNlink(Long nlink) {
        this.nlink=nlink; return (A) this;
    }

    public Boolean hasNlink() {
        return this.nlink != null;
    }

    public A withNewNlink(String arg1) {
        return (A)withNlink(new Long(arg1));
    }

    public A withNewNlink(long arg1) {
        return (A)withNlink(new Long(arg1));
    }

    public String getPath() {
        return this.path;
    }

    public A withPath(String path) {
        this.path=path; return (A) this;
    }

    public Boolean hasPath() {
        return this.path != null;
    }

    public A withNewPath(String arg1) {
        return (A)withPath(new String(arg1));
    }

    public A withNewPath(StringBuilder arg1) {
        return (A)withPath(new String(arg1));
    }

    public A withNewPath(StringBuffer arg1) {
        return (A)withPath(new String(arg1));
    }

    public Integer getPercent() {
        return this.percent;
    }

    public A withPercent(Integer percent) {
        this.percent=percent; return (A) this;
    }

    public Boolean hasPercent() {
        return this.percent != null;
    }

    public A withNewPercent(String arg1) {
        return (A)withPercent(new Integer(arg1));
    }

    public A withNewPercent(int arg1) {
        return (A)withPercent(new Integer(arg1));
    }

    public Integer getPerm() {
        return this.perm;
    }

    public A withPerm(Integer perm) {
        this.perm=perm; return (A) this;
    }

    public Boolean hasPerm() {
        return this.perm != null;
    }

    public A withNewPerm(String arg1) {
        return (A)withPerm(new Integer(arg1));
    }

    public A withNewPerm(int arg1) {
        return (A)withPerm(new Integer(arg1));
    }

    public Long getRdev() {
        return this.rdev;
    }

    public A withRdev(Long rdev) {
        this.rdev=rdev; return (A) this;
    }

    public Boolean hasRdev() {
        return this.rdev != null;
    }

    public A withNewRdev(String arg1) {
        return (A)withRdev(new Long(arg1));
    }

    public A withNewRdev(long arg1) {
        return (A)withRdev(new Long(arg1));
    }

    public Long getSize() {
        return this.size;
    }

    public A withSize(Long size) {
        this.size=size; return (A) this;
    }

    public Boolean hasSize() {
        return this.size != null;
    }

    public A withNewSize(String arg1) {
        return (A)withSize(new Long(arg1));
    }

    public A withNewSize(long arg1) {
        return (A)withSize(new Long(arg1));
    }

    public String getSource() {
        return this.source;
    }

    public A withSource(String source) {
        this.source=source; return (A) this;
    }

    public Boolean hasSource() {
        return this.source != null;
    }

    public A withNewSource(String arg1) {
        return (A)withSource(new String(arg1));
    }

    public A withNewSource(StringBuilder arg1) {
        return (A)withSource(new String(arg1));
    }

    public A withNewSource(StringBuffer arg1) {
        return (A)withSource(new String(arg1));
    }

    public String getType() {
        return this.type;
    }

    public A withType(String type) {
        this.type=type; return (A) this;
    }

    public Boolean hasType() {
        return this.type != null;
    }

    public A withNewType(String arg1) {
        return (A)withType(new String(arg1));
    }

    public A withNewType(StringBuilder arg1) {
        return (A)withType(new String(arg1));
    }

    public A withNewType(StringBuffer arg1) {
        return (A)withType(new String(arg1));
    }

    public Long getUid() {
        return this.uid;
    }

    public A withUid(Long uid) {
        this.uid=uid; return (A) this;
    }

    public Boolean hasUid() {
        return this.uid != null;
    }

    public A withNewUid(String arg1) {
        return (A)withUid(new Long(arg1));
    }

    public A withNewUid(long arg1) {
        return (A)withUid(new Long(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        IoChaosActionFluentImpl that = (IoChaosActionFluentImpl) o;
        if (atime != null ? !atime.equals(that.atime) :that.atime != null) return false;
        if (blocks != null ? !blocks.equals(that.blocks) :that.blocks != null) return false;
        if (ctime != null ? !ctime.equals(that.ctime) :that.ctime != null) return false;
        if (faults != null ? !faults.equals(that.faults) :that.faults != null) return false;
        if (gid != null ? !gid.equals(that.gid) :that.gid != null) return false;
        if (ino != null ? !ino.equals(that.ino) :that.ino != null) return false;
        if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
        if (latency != null ? !latency.equals(that.latency) :that.latency != null) return false;
        if (methods != null ? !methods.equals(that.methods) :that.methods != null) return false;
        if (mtime != null ? !mtime.equals(that.mtime) :that.mtime != null) return false;
        if (nlink != null ? !nlink.equals(that.nlink) :that.nlink != null) return false;
        if (path != null ? !path.equals(that.path) :that.path != null) return false;
        if (percent != null ? !percent.equals(that.percent) :that.percent != null) return false;
        if (perm != null ? !perm.equals(that.perm) :that.perm != null) return false;
        if (rdev != null ? !rdev.equals(that.rdev) :that.rdev != null) return false;
        if (size != null ? !size.equals(that.size) :that.size != null) return false;
        if (source != null ? !source.equals(that.source) :that.source != null) return false;
        if (type != null ? !type.equals(that.type) :that.type != null) return false;
        if (uid != null ? !uid.equals(that.uid) :that.uid != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(atime,  blocks,  ctime,  faults,  gid,  ino,  kind,  latency,  methods,  mtime,  nlink,  path,  percent,  perm,  rdev,  size,  source,  type,  uid,  super.hashCode());
    }

    public class AtimeNestedImpl<N> extends TimespecFluentImpl<IoChaosActionFluent.AtimeNested<N>> implements IoChaosActionFluent.AtimeNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final TimespecBuilder builder;

            AtimeNestedImpl(Timespec item) {
                this.builder = new TimespecBuilder(this, item);
                        
            }

            AtimeNestedImpl() {
                this.builder = new TimespecBuilder(this);
                        
            }

            public N and() {
                return (N) IoChaosActionFluentImpl.this.withAtime(builder.build());
            }

            public N endAtime() {
                return and();
            }
    }


    public class CtimeNestedImpl<N> extends TimespecFluentImpl<IoChaosActionFluent.CtimeNested<N>> implements IoChaosActionFluent.CtimeNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final TimespecBuilder builder;

            CtimeNestedImpl(Timespec item) {
                this.builder = new TimespecBuilder(this, item);
                        
            }

            CtimeNestedImpl() {
                this.builder = new TimespecBuilder(this);
                        
            }

            public N and() {
                return (N) IoChaosActionFluentImpl.this.withCtime(builder.build());
            }

            public N endCtime() {
                return and();
            }
    }


    public class FaultsNestedImpl<N> extends IoFaultFluentImpl<IoChaosActionFluent.FaultsNested<N>> implements IoChaosActionFluent.FaultsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final IoFaultBuilder builder;
        private final int index;

            FaultsNestedImpl(int index,IoFault item) {
                this.index = index;
                this.builder = new IoFaultBuilder(this, item);
                        
            }

            FaultsNestedImpl() {
                this.index = -1;
                this.builder = new IoFaultBuilder(this);
                        
            }

            public N and() {
                return (N) IoChaosActionFluentImpl.this.setToFaults(index,builder.build());
            }

            public N endFault() {
                return and();
            }
    }


    public class MtimeNestedImpl<N> extends TimespecFluentImpl<IoChaosActionFluent.MtimeNested<N>> implements IoChaosActionFluent.MtimeNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final TimespecBuilder builder;

            MtimeNestedImpl(Timespec item) {
                this.builder = new TimespecBuilder(this, item);
                        
            }

            MtimeNestedImpl() {
                this.builder = new TimespecBuilder(this);
                        
            }

            public N and() {
                return (N) IoChaosActionFluentImpl.this.withMtime(builder.build());
            }

            public N endMtime() {
                return and();
            }
    }


}
