package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.lang.StringBuffer;
import java.util.Collection;
import java.lang.Object;

public class HTTPChaosSpecFluentImpl<A extends HTTPChaosSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements HTTPChaosSpecFluent<A> {

    private String action;
    private String duration;
    private List<MatcherBuilder> headers;
    private String mode;
    private String percent;
    private SchedulerSpecBuilder scheduler;
    private SelectorSpecBuilder selector;
    private String value;

    public HTTPChaosSpecFluentImpl() {
    }

    public HTTPChaosSpecFluentImpl(HTTPChaosSpec instance) {
        this.withAction(instance.getAction()); 
        this.withDuration(instance.getDuration()); 
        this.withHeaders(instance.getHeaders()); 
        this.withMode(instance.getMode()); 
        this.withPercent(instance.getPercent()); 
        this.withScheduler(instance.getScheduler()); 
        this.withSelector(instance.getSelector()); 
        this.withValue(instance.getValue()); 
    }

    public String getAction() {
        return this.action;
    }

    public A withAction(String action) {
        this.action=action; return (A) this;
    }

    public Boolean hasAction() {
        return this.action != null;
    }

    public A withNewAction(String arg1) {
        return (A)withAction(new String(arg1));
    }

    public A withNewAction(StringBuilder arg1) {
        return (A)withAction(new String(arg1));
    }

    public A withNewAction(StringBuffer arg1) {
        return (A)withAction(new String(arg1));
    }

    public String getDuration() {
        return this.duration;
    }

    public A withDuration(String duration) {
        this.duration=duration; return (A) this;
    }

    public Boolean hasDuration() {
        return this.duration != null;
    }

    public A withNewDuration(String arg1) {
        return (A)withDuration(new String(arg1));
    }

    public A withNewDuration(StringBuilder arg1) {
        return (A)withDuration(new String(arg1));
    }

    public A withNewDuration(StringBuffer arg1) {
        return (A)withDuration(new String(arg1));
    }

    public A addToHeaders(int index,Matcher item) {
        if (this.headers == null) {this.headers = new ArrayList<MatcherBuilder>();}
        MatcherBuilder builder = new MatcherBuilder(item);_visitables.get("headers").add(index >= 0 ? index : _visitables.get("headers").size(), builder);this.headers.add(index >= 0 ? index : headers.size(), builder); return (A)this;
    }

    public A setToHeaders(int index,Matcher item) {
        if (this.headers == null) {this.headers = new ArrayList<MatcherBuilder>();}
        MatcherBuilder builder = new MatcherBuilder(item);
        if (index < 0 || index >= _visitables.get("headers").size()) { _visitables.get("headers").add(builder); } else { _visitables.get("headers").set(index, builder);}
        if (index < 0 || index >= headers.size()) { headers.add(builder); } else { headers.set(index, builder);}
         return (A)this;
    }

    public A addToHeaders(Matcher... items) {
        if (this.headers == null) {this.headers = new ArrayList<MatcherBuilder>();}
        for (Matcher item : items) {MatcherBuilder builder = new MatcherBuilder(item);_visitables.get("headers").add(builder);this.headers.add(builder);} return (A)this;
    }

    public A addAllToHeaders(Collection<Matcher> items) {
        if (this.headers == null) {this.headers = new ArrayList<MatcherBuilder>();}
        for (Matcher item : items) {MatcherBuilder builder = new MatcherBuilder(item);_visitables.get("headers").add(builder);this.headers.add(builder);} return (A)this;
    }

    public A removeFromHeaders(Matcher... items) {
        for (Matcher item : items) {MatcherBuilder builder = new MatcherBuilder(item);_visitables.get("headers").remove(builder);if (this.headers != null) {this.headers.remove(builder);}} return (A)this;
    }

    public A removeAllFromHeaders(Collection<Matcher> items) {
        for (Matcher item : items) {MatcherBuilder builder = new MatcherBuilder(item);_visitables.get("headers").remove(builder);if (this.headers != null) {this.headers.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromHeaders(Predicate<MatcherBuilder> predicate) {
        if (headers == null) return (A) this;
        final Iterator<MatcherBuilder> each = headers.iterator();
        final List visitables = _visitables.get("headers");
        while (each.hasNext()) {
          MatcherBuilder builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildHeaders instead.
 * @return The buildable object.
 */
@Deprecated public List<Matcher> getHeaders() {
        return build(headers);
    }

    public List<Matcher> buildHeaders() {
        return build(headers);
    }

    public Matcher buildHeader(int index) {
        return this.headers.get(index).build();
    }

    public Matcher buildFirstHeader() {
        return this.headers.get(0).build();
    }

    public Matcher buildLastHeader() {
        return this.headers.get(headers.size() - 1).build();
    }

    public Matcher buildMatchingHeader(Predicate<MatcherBuilder> predicate) {
        for (MatcherBuilder item: headers) { if(predicate.test(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingHeader(Predicate<MatcherBuilder> predicate) {
        for (MatcherBuilder item: headers) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withHeaders(List<Matcher> headers) {
        if (this.headers != null) { _visitables.get("headers").removeAll(this.headers);}
        if (headers != null) {this.headers = new ArrayList<MatcherBuilder>(); for (Matcher item : headers){this.addToHeaders(item);}} else { this.headers = null;} return (A) this;
    }

    public A withHeaders(Matcher... headers) {
        if (this.headers != null) {this.headers.clear();}
        if (headers != null) {for (Matcher item :headers){ this.addToHeaders(item);}} return (A) this;
    }

    public Boolean hasHeaders() {
        return headers != null && !headers.isEmpty();
    }

    public HTTPChaosSpecFluent.HeadersNested<A> addNewHeader() {
        return new HeadersNestedImpl();
    }

    public HTTPChaosSpecFluent.HeadersNested<A> addNewHeaderLike(Matcher item) {
        return new HeadersNestedImpl(-1, item);
    }

    public HTTPChaosSpecFluent.HeadersNested<A> setNewHeaderLike(int index,Matcher item) {
        return new HeadersNestedImpl(index, item);
    }

    public HTTPChaosSpecFluent.HeadersNested<A> editHeader(int index) {
        if (headers.size() <= index) throw new RuntimeException("Can't edit headers. Index exceeds size.");
        return setNewHeaderLike(index, buildHeader(index));
    }

    public HTTPChaosSpecFluent.HeadersNested<A> editFirstHeader() {
        if (headers.size() == 0) throw new RuntimeException("Can't edit first headers. The list is empty.");
        return setNewHeaderLike(0, buildHeader(0));
    }

    public HTTPChaosSpecFluent.HeadersNested<A> editLastHeader() {
        int index = headers.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last headers. The list is empty.");
        return setNewHeaderLike(index, buildHeader(index));
    }

    public HTTPChaosSpecFluent.HeadersNested<A> editMatchingHeader(Predicate<MatcherBuilder> predicate) {
        int index = -1;
        for (int i=0;i<headers.size();i++) { 
        if (predicate.test(headers.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching headers. No match found.");
        return setNewHeaderLike(index, buildHeader(index));
    }

    public String getMode() {
        return this.mode;
    }

    public A withMode(String mode) {
        this.mode=mode; return (A) this;
    }

    public Boolean hasMode() {
        return this.mode != null;
    }

    public A withNewMode(String arg1) {
        return (A)withMode(new String(arg1));
    }

    public A withNewMode(StringBuilder arg1) {
        return (A)withMode(new String(arg1));
    }

    public A withNewMode(StringBuffer arg1) {
        return (A)withMode(new String(arg1));
    }

    public String getPercent() {
        return this.percent;
    }

    public A withPercent(String percent) {
        this.percent=percent; return (A) this;
    }

    public Boolean hasPercent() {
        return this.percent != null;
    }

    public A withNewPercent(String arg1) {
        return (A)withPercent(new String(arg1));
    }

    public A withNewPercent(StringBuilder arg1) {
        return (A)withPercent(new String(arg1));
    }

    public A withNewPercent(StringBuffer arg1) {
        return (A)withPercent(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildScheduler instead.
 * @return The buildable object.
 */
@Deprecated public SchedulerSpec getScheduler() {
        return this.scheduler!=null?this.scheduler.build():null;
    }

    public SchedulerSpec buildScheduler() {
        return this.scheduler!=null?this.scheduler.build():null;
    }

    public A withScheduler(SchedulerSpec scheduler) {
        _visitables.get("scheduler").remove(this.scheduler);
        if (scheduler!=null){ this.scheduler= new SchedulerSpecBuilder(scheduler); _visitables.get("scheduler").add(this.scheduler);} return (A) this;
    }

    public Boolean hasScheduler() {
        return this.scheduler != null;
    }

    public A withNewScheduler(String cron) {
        return (A)withScheduler(new SchedulerSpec(cron));
    }

    public HTTPChaosSpecFluent.SchedulerNested<A> withNewScheduler() {
        return new SchedulerNestedImpl();
    }

    public HTTPChaosSpecFluent.SchedulerNested<A> withNewSchedulerLike(SchedulerSpec item) {
        return new SchedulerNestedImpl(item);
    }

    public HTTPChaosSpecFluent.SchedulerNested<A> editScheduler() {
        return withNewSchedulerLike(getScheduler());
    }

    public HTTPChaosSpecFluent.SchedulerNested<A> editOrNewScheduler() {
        return withNewSchedulerLike(getScheduler() != null ? getScheduler(): new SchedulerSpecBuilder().build());
    }

    public HTTPChaosSpecFluent.SchedulerNested<A> editOrNewSchedulerLike(SchedulerSpec item) {
        return withNewSchedulerLike(getScheduler() != null ? getScheduler(): item);
    }

    
/**
 * This method has been deprecated, please use method buildSelector instead.
 * @return The buildable object.
 */
@Deprecated public SelectorSpec getSelector() {
        return this.selector!=null?this.selector.build():null;
    }

    public SelectorSpec buildSelector() {
        return this.selector!=null?this.selector.build():null;
    }

    public A withSelector(SelectorSpec selector) {
        _visitables.get("selector").remove(this.selector);
        if (selector!=null){ this.selector= new SelectorSpecBuilder(selector); _visitables.get("selector").add(this.selector);} return (A) this;
    }

    public Boolean hasSelector() {
        return this.selector != null;
    }

    public HTTPChaosSpecFluent.SelectorNested<A> withNewSelector() {
        return new SelectorNestedImpl();
    }

    public HTTPChaosSpecFluent.SelectorNested<A> withNewSelectorLike(SelectorSpec item) {
        return new SelectorNestedImpl(item);
    }

    public HTTPChaosSpecFluent.SelectorNested<A> editSelector() {
        return withNewSelectorLike(getSelector());
    }

    public HTTPChaosSpecFluent.SelectorNested<A> editOrNewSelector() {
        return withNewSelectorLike(getSelector() != null ? getSelector(): new SelectorSpecBuilder().build());
    }

    public HTTPChaosSpecFluent.SelectorNested<A> editOrNewSelectorLike(SelectorSpec item) {
        return withNewSelectorLike(getSelector() != null ? getSelector(): item);
    }

    public String getValue() {
        return this.value;
    }

    public A withValue(String value) {
        this.value=value; return (A) this;
    }

    public Boolean hasValue() {
        return this.value != null;
    }

    public A withNewValue(String arg1) {
        return (A)withValue(new String(arg1));
    }

    public A withNewValue(StringBuilder arg1) {
        return (A)withValue(new String(arg1));
    }

    public A withNewValue(StringBuffer arg1) {
        return (A)withValue(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        HTTPChaosSpecFluentImpl that = (HTTPChaosSpecFluentImpl) o;
        if (action != null ? !action.equals(that.action) :that.action != null) return false;
        if (duration != null ? !duration.equals(that.duration) :that.duration != null) return false;
        if (headers != null ? !headers.equals(that.headers) :that.headers != null) return false;
        if (mode != null ? !mode.equals(that.mode) :that.mode != null) return false;
        if (percent != null ? !percent.equals(that.percent) :that.percent != null) return false;
        if (scheduler != null ? !scheduler.equals(that.scheduler) :that.scheduler != null) return false;
        if (selector != null ? !selector.equals(that.selector) :that.selector != null) return false;
        if (value != null ? !value.equals(that.value) :that.value != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(action,  duration,  headers,  mode,  percent,  scheduler,  selector,  value,  super.hashCode());
    }

    public class HeadersNestedImpl<N> extends MatcherFluentImpl<HTTPChaosSpecFluent.HeadersNested<N>> implements HTTPChaosSpecFluent.HeadersNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final MatcherBuilder builder;
        private final int index;

            HeadersNestedImpl(int index,Matcher item) {
                this.index = index;
                this.builder = new MatcherBuilder(this, item);
                        
            }

            HeadersNestedImpl() {
                this.index = -1;
                this.builder = new MatcherBuilder(this);
                        
            }

            public N and() {
                return (N) HTTPChaosSpecFluentImpl.this.setToHeaders(index,builder.build());
            }

            public N endHeader() {
                return and();
            }
    }


    public class SchedulerNestedImpl<N> extends SchedulerSpecFluentImpl<HTTPChaosSpecFluent.SchedulerNested<N>> implements HTTPChaosSpecFluent.SchedulerNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final SchedulerSpecBuilder builder;

            SchedulerNestedImpl(SchedulerSpec item) {
                this.builder = new SchedulerSpecBuilder(this, item);
                        
            }

            SchedulerNestedImpl() {
                this.builder = new SchedulerSpecBuilder(this);
                        
            }

            public N and() {
                return (N) HTTPChaosSpecFluentImpl.this.withScheduler(builder.build());
            }

            public N endScheduler() {
                return and();
            }
    }


    public class SelectorNestedImpl<N> extends SelectorSpecFluentImpl<HTTPChaosSpecFluent.SelectorNested<N>> implements HTTPChaosSpecFluent.SelectorNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final SelectorSpecBuilder builder;

            SelectorNestedImpl(SelectorSpec item) {
                this.builder = new SelectorSpecBuilder(this, item);
                        
            }

            SelectorNestedImpl() {
                this.builder = new SelectorSpecBuilder(this);
                        
            }

            public N and() {
                return (N) HTTPChaosSpecFluentImpl.this.withSelector(builder.build());
            }

            public N endSelector() {
                return and();
            }
    }


}
