package io.fabric8.chaosmesh.v1alpha1;

import java.lang.StringBuffer;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;

public class ServletExceptionSpecFluentImpl<A extends ServletExceptionSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements ServletExceptionSpecFluent<A> {

    private String exception;
    private String message;
    private String method;
    private String querystring;
    private String requestpath;

    public ServletExceptionSpecFluentImpl() {
    }

    public ServletExceptionSpecFluentImpl(ServletExceptionSpec instance) {
        this.withException(instance.getException()); 
        this.withMessage(instance.getMessage()); 
        this.withMethod(instance.getMethod()); 
        this.withQuerystring(instance.getQuerystring()); 
        this.withRequestpath(instance.getRequestpath()); 
    }

    public String getException() {
        return this.exception;
    }

    public A withException(String exception) {
        this.exception=exception; return (A) this;
    }

    public Boolean hasException() {
        return this.exception != null;
    }

    public A withNewException(String arg1) {
        return (A)withException(new String(arg1));
    }

    public A withNewException(StringBuilder arg1) {
        return (A)withException(new String(arg1));
    }

    public A withNewException(StringBuffer arg1) {
        return (A)withException(new String(arg1));
    }

    public String getMessage() {
        return this.message;
    }

    public A withMessage(String message) {
        this.message=message; return (A) this;
    }

    public Boolean hasMessage() {
        return this.message != null;
    }

    public A withNewMessage(String arg1) {
        return (A)withMessage(new String(arg1));
    }

    public A withNewMessage(StringBuilder arg1) {
        return (A)withMessage(new String(arg1));
    }

    public A withNewMessage(StringBuffer arg1) {
        return (A)withMessage(new String(arg1));
    }

    public String getMethod() {
        return this.method;
    }

    public A withMethod(String method) {
        this.method=method; return (A) this;
    }

    public Boolean hasMethod() {
        return this.method != null;
    }

    public A withNewMethod(String arg1) {
        return (A)withMethod(new String(arg1));
    }

    public A withNewMethod(StringBuilder arg1) {
        return (A)withMethod(new String(arg1));
    }

    public A withNewMethod(StringBuffer arg1) {
        return (A)withMethod(new String(arg1));
    }

    public String getQuerystring() {
        return this.querystring;
    }

    public A withQuerystring(String querystring) {
        this.querystring=querystring; return (A) this;
    }

    public Boolean hasQuerystring() {
        return this.querystring != null;
    }

    public A withNewQuerystring(String arg1) {
        return (A)withQuerystring(new String(arg1));
    }

    public A withNewQuerystring(StringBuilder arg1) {
        return (A)withQuerystring(new String(arg1));
    }

    public A withNewQuerystring(StringBuffer arg1) {
        return (A)withQuerystring(new String(arg1));
    }

    public String getRequestpath() {
        return this.requestpath;
    }

    public A withRequestpath(String requestpath) {
        this.requestpath=requestpath; return (A) this;
    }

    public Boolean hasRequestpath() {
        return this.requestpath != null;
    }

    public A withNewRequestpath(String arg1) {
        return (A)withRequestpath(new String(arg1));
    }

    public A withNewRequestpath(StringBuilder arg1) {
        return (A)withRequestpath(new String(arg1));
    }

    public A withNewRequestpath(StringBuffer arg1) {
        return (A)withRequestpath(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        ServletExceptionSpecFluentImpl that = (ServletExceptionSpecFluentImpl) o;
        if (exception != null ? !exception.equals(that.exception) :that.exception != null) return false;
        if (message != null ? !message.equals(that.message) :that.message != null) return false;
        if (method != null ? !method.equals(that.method) :that.method != null) return false;
        if (querystring != null ? !querystring.equals(that.querystring) :that.querystring != null) return false;
        if (requestpath != null ? !requestpath.equals(that.requestpath) :that.requestpath != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(exception,  message,  method,  querystring,  requestpath,  super.hashCode());
    }

}
