package io.fabric8.chaosmesh.v1alpha1;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.StringBuffer;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import io.fabric8.kubernetes.api.model.LabelSelectorRequirement;
import java.lang.Boolean;
import java.util.Map;

public class SelectorSpecFluentImpl<A extends SelectorSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements SelectorSpecFluent<A> {

    private Map<String,String> annotationSelectors;
    private List<LabelSelectorRequirement> expressionSelectors;
    private Map<String,String> fieldSelectors;
    private Map<String,String> labelSelectors;
    private List<String> namespaces;
    private Map<String,String> nodeSelectors;
    private List<String> nodes;
    private List<String> podPhaseSelectors;
    private Map<String,List<String>> pods;

    public SelectorSpecFluentImpl() {
    }

    public SelectorSpecFluentImpl(SelectorSpec instance) {
        this.withAnnotationSelectors(instance.getAnnotationSelectors()); 
        this.withExpressionSelectors(instance.getExpressionSelectors()); 
        this.withFieldSelectors(instance.getFieldSelectors()); 
        this.withLabelSelectors(instance.getLabelSelectors()); 
        this.withNamespaces(instance.getNamespaces()); 
        this.withNodeSelectors(instance.getNodeSelectors()); 
        this.withNodes(instance.getNodes()); 
        this.withPodPhaseSelectors(instance.getPodPhaseSelectors()); 
        this.withPods(instance.getPods()); 
    }

    public A addToAnnotationSelectors(String key,String value) {
        if(this.annotationSelectors == null && key != null && value != null) { this.annotationSelectors = new LinkedHashMap<String,String>(); }
        if(key != null && value != null) {this.annotationSelectors.put(key, value);} return (A)this;
    }

    public A addToAnnotationSelectors(Map<String,String> map) {
        if(this.annotationSelectors == null && map != null) { this.annotationSelectors = new LinkedHashMap<String,String>(); }
        if(map != null) { this.annotationSelectors.putAll(map);} return (A)this;
    }

    public A removeFromAnnotationSelectors(String key) {
        if(this.annotationSelectors == null) { return (A) this; }
        if(key != null && this.annotationSelectors != null) {this.annotationSelectors.remove(key);} return (A)this;
    }

    public A removeFromAnnotationSelectors(Map<String,String> map) {
        if(this.annotationSelectors == null) { return (A) this; }
        if(map != null) { for(Object key : map.keySet()) {if (this.annotationSelectors != null){this.annotationSelectors.remove(key);}}} return (A)this;
    }

    public Map<String,String> getAnnotationSelectors() {
        return this.annotationSelectors;
    }

    public A withAnnotationSelectors(Map<String,String> annotationSelectors) {
        if (annotationSelectors == null) { this.annotationSelectors =  null;} else {this.annotationSelectors = new LinkedHashMap<String,String>(annotationSelectors);} return (A) this;
    }

    public Boolean hasAnnotationSelectors() {
        return this.annotationSelectors != null;
    }

    public A addToExpressionSelectors(int index,LabelSelectorRequirement item) {
        if (this.expressionSelectors == null) {this.expressionSelectors = new ArrayList<LabelSelectorRequirement>();}
        this.expressionSelectors.add(index, item);
        return (A)this;
    }

    public A setToExpressionSelectors(int index,LabelSelectorRequirement item) {
        if (this.expressionSelectors == null) {this.expressionSelectors = new ArrayList<LabelSelectorRequirement>();}
        this.expressionSelectors.set(index, item); return (A)this;
    }

    public A addToExpressionSelectors(LabelSelectorRequirement... items) {
        if (this.expressionSelectors == null) {this.expressionSelectors = new ArrayList<LabelSelectorRequirement>();}
        for (LabelSelectorRequirement item : items) {this.expressionSelectors.add(item);} return (A)this;
    }

    public A addAllToExpressionSelectors(Collection<LabelSelectorRequirement> items) {
        if (this.expressionSelectors == null) {this.expressionSelectors = new ArrayList<LabelSelectorRequirement>();}
        for (LabelSelectorRequirement item : items) {this.expressionSelectors.add(item);} return (A)this;
    }

    public A removeFromExpressionSelectors(LabelSelectorRequirement... items) {
        for (LabelSelectorRequirement item : items) {if (this.expressionSelectors!= null){ this.expressionSelectors.remove(item);}} return (A)this;
    }

    public A removeAllFromExpressionSelectors(Collection<LabelSelectorRequirement> items) {
        for (LabelSelectorRequirement item : items) {if (this.expressionSelectors!= null){ this.expressionSelectors.remove(item);}} return (A)this;
    }

    public List<LabelSelectorRequirement> getExpressionSelectors() {
        return this.expressionSelectors;
    }

    public LabelSelectorRequirement getExpressionSelector(int index) {
        return this.expressionSelectors.get(index);
    }

    public LabelSelectorRequirement getFirstExpressionSelector() {
        return this.expressionSelectors.get(0);
    }

    public LabelSelectorRequirement getLastExpressionSelector() {
        return this.expressionSelectors.get(expressionSelectors.size() - 1);
    }

    public LabelSelectorRequirement getMatchingExpressionSelector(Predicate<LabelSelectorRequirement> predicate) {
        for (LabelSelectorRequirement item: expressionSelectors) { if(predicate.test(item)){ return item;} } return null;
    }

    public Boolean hasMatchingExpressionSelector(Predicate<LabelSelectorRequirement> predicate) {
        for (LabelSelectorRequirement item: expressionSelectors) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withExpressionSelectors(List<LabelSelectorRequirement> expressionSelectors) {
        if (this.expressionSelectors != null) { _visitables.get("expressionSelectors").removeAll(this.expressionSelectors);}
        if (expressionSelectors != null) {this.expressionSelectors = new ArrayList<LabelSelectorRequirement>(); for (LabelSelectorRequirement item : expressionSelectors){this.addToExpressionSelectors(item);}} else { this.expressionSelectors = null;} return (A) this;
    }

    public A withExpressionSelectors(LabelSelectorRequirement... expressionSelectors) {
        if (this.expressionSelectors != null) {this.expressionSelectors.clear();}
        if (expressionSelectors != null) {for (LabelSelectorRequirement item :expressionSelectors){ this.addToExpressionSelectors(item);}} return (A) this;
    }

    public Boolean hasExpressionSelectors() {
        return expressionSelectors != null && !expressionSelectors.isEmpty();
    }

    public A addToFieldSelectors(String key,String value) {
        if(this.fieldSelectors == null && key != null && value != null) { this.fieldSelectors = new LinkedHashMap<String,String>(); }
        if(key != null && value != null) {this.fieldSelectors.put(key, value);} return (A)this;
    }

    public A addToFieldSelectors(Map<String,String> map) {
        if(this.fieldSelectors == null && map != null) { this.fieldSelectors = new LinkedHashMap<String,String>(); }
        if(map != null) { this.fieldSelectors.putAll(map);} return (A)this;
    }

    public A removeFromFieldSelectors(String key) {
        if(this.fieldSelectors == null) { return (A) this; }
        if(key != null && this.fieldSelectors != null) {this.fieldSelectors.remove(key);} return (A)this;
    }

    public A removeFromFieldSelectors(Map<String,String> map) {
        if(this.fieldSelectors == null) { return (A) this; }
        if(map != null) { for(Object key : map.keySet()) {if (this.fieldSelectors != null){this.fieldSelectors.remove(key);}}} return (A)this;
    }

    public Map<String,String> getFieldSelectors() {
        return this.fieldSelectors;
    }

    public A withFieldSelectors(Map<String,String> fieldSelectors) {
        if (fieldSelectors == null) { this.fieldSelectors =  null;} else {this.fieldSelectors = new LinkedHashMap<String,String>(fieldSelectors);} return (A) this;
    }

    public Boolean hasFieldSelectors() {
        return this.fieldSelectors != null;
    }

    public A addToLabelSelectors(String key,String value) {
        if(this.labelSelectors == null && key != null && value != null) { this.labelSelectors = new LinkedHashMap<String,String>(); }
        if(key != null && value != null) {this.labelSelectors.put(key, value);} return (A)this;
    }

    public A addToLabelSelectors(Map<String,String> map) {
        if(this.labelSelectors == null && map != null) { this.labelSelectors = new LinkedHashMap<String,String>(); }
        if(map != null) { this.labelSelectors.putAll(map);} return (A)this;
    }

    public A removeFromLabelSelectors(String key) {
        if(this.labelSelectors == null) { return (A) this; }
        if(key != null && this.labelSelectors != null) {this.labelSelectors.remove(key);} return (A)this;
    }

    public A removeFromLabelSelectors(Map<String,String> map) {
        if(this.labelSelectors == null) { return (A) this; }
        if(map != null) { for(Object key : map.keySet()) {if (this.labelSelectors != null){this.labelSelectors.remove(key);}}} return (A)this;
    }

    public Map<String,String> getLabelSelectors() {
        return this.labelSelectors;
    }

    public A withLabelSelectors(Map<String,String> labelSelectors) {
        if (labelSelectors == null) { this.labelSelectors =  null;} else {this.labelSelectors = new LinkedHashMap<String,String>(labelSelectors);} return (A) this;
    }

    public Boolean hasLabelSelectors() {
        return this.labelSelectors != null;
    }

    public A addToNamespaces(int index,String item) {
        if (this.namespaces == null) {this.namespaces = new ArrayList<String>();}
        this.namespaces.add(index, item);
        return (A)this;
    }

    public A setToNamespaces(int index,String item) {
        if (this.namespaces == null) {this.namespaces = new ArrayList<String>();}
        this.namespaces.set(index, item); return (A)this;
    }

    public A addToNamespaces(String... items) {
        if (this.namespaces == null) {this.namespaces = new ArrayList<String>();}
        for (String item : items) {this.namespaces.add(item);} return (A)this;
    }

    public A addAllToNamespaces(Collection<String> items) {
        if (this.namespaces == null) {this.namespaces = new ArrayList<String>();}
        for (String item : items) {this.namespaces.add(item);} return (A)this;
    }

    public A removeFromNamespaces(String... items) {
        for (String item : items) {if (this.namespaces!= null){ this.namespaces.remove(item);}} return (A)this;
    }

    public A removeAllFromNamespaces(Collection<String> items) {
        for (String item : items) {if (this.namespaces!= null){ this.namespaces.remove(item);}} return (A)this;
    }

    public List<String> getNamespaces() {
        return this.namespaces;
    }

    public String getNamespace(int index) {
        return this.namespaces.get(index);
    }

    public String getFirstNamespace() {
        return this.namespaces.get(0);
    }

    public String getLastNamespace() {
        return this.namespaces.get(namespaces.size() - 1);
    }

    public String getMatchingNamespace(Predicate<String> predicate) {
        for (String item: namespaces) { if(predicate.test(item)){ return item;} } return null;
    }

    public Boolean hasMatchingNamespace(Predicate<String> predicate) {
        for (String item: namespaces) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withNamespaces(List<String> namespaces) {
        if (this.namespaces != null) { _visitables.get("namespaces").removeAll(this.namespaces);}
        if (namespaces != null) {this.namespaces = new ArrayList<String>(); for (String item : namespaces){this.addToNamespaces(item);}} else { this.namespaces = null;} return (A) this;
    }

    public A withNamespaces(String... namespaces) {
        if (this.namespaces != null) {this.namespaces.clear();}
        if (namespaces != null) {for (String item :namespaces){ this.addToNamespaces(item);}} return (A) this;
    }

    public Boolean hasNamespaces() {
        return namespaces != null && !namespaces.isEmpty();
    }

    public A addNewNamespace(String arg1) {
        return (A)addToNamespaces(new String(arg1));
    }

    public A addNewNamespace(StringBuilder arg1) {
        return (A)addToNamespaces(new String(arg1));
    }

    public A addNewNamespace(StringBuffer arg1) {
        return (A)addToNamespaces(new String(arg1));
    }

    public A addToNodeSelectors(String key,String value) {
        if(this.nodeSelectors == null && key != null && value != null) { this.nodeSelectors = new LinkedHashMap<String,String>(); }
        if(key != null && value != null) {this.nodeSelectors.put(key, value);} return (A)this;
    }

    public A addToNodeSelectors(Map<String,String> map) {
        if(this.nodeSelectors == null && map != null) { this.nodeSelectors = new LinkedHashMap<String,String>(); }
        if(map != null) { this.nodeSelectors.putAll(map);} return (A)this;
    }

    public A removeFromNodeSelectors(String key) {
        if(this.nodeSelectors == null) { return (A) this; }
        if(key != null && this.nodeSelectors != null) {this.nodeSelectors.remove(key);} return (A)this;
    }

    public A removeFromNodeSelectors(Map<String,String> map) {
        if(this.nodeSelectors == null) { return (A) this; }
        if(map != null) { for(Object key : map.keySet()) {if (this.nodeSelectors != null){this.nodeSelectors.remove(key);}}} return (A)this;
    }

    public Map<String,String> getNodeSelectors() {
        return this.nodeSelectors;
    }

    public A withNodeSelectors(Map<String,String> nodeSelectors) {
        if (nodeSelectors == null) { this.nodeSelectors =  null;} else {this.nodeSelectors = new LinkedHashMap<String,String>(nodeSelectors);} return (A) this;
    }

    public Boolean hasNodeSelectors() {
        return this.nodeSelectors != null;
    }

    public A addToNodes(int index,String item) {
        if (this.nodes == null) {this.nodes = new ArrayList<String>();}
        this.nodes.add(index, item);
        return (A)this;
    }

    public A setToNodes(int index,String item) {
        if (this.nodes == null) {this.nodes = new ArrayList<String>();}
        this.nodes.set(index, item); return (A)this;
    }

    public A addToNodes(String... items) {
        if (this.nodes == null) {this.nodes = new ArrayList<String>();}
        for (String item : items) {this.nodes.add(item);} return (A)this;
    }

    public A addAllToNodes(Collection<String> items) {
        if (this.nodes == null) {this.nodes = new ArrayList<String>();}
        for (String item : items) {this.nodes.add(item);} return (A)this;
    }

    public A removeFromNodes(String... items) {
        for (String item : items) {if (this.nodes!= null){ this.nodes.remove(item);}} return (A)this;
    }

    public A removeAllFromNodes(Collection<String> items) {
        for (String item : items) {if (this.nodes!= null){ this.nodes.remove(item);}} return (A)this;
    }

    public List<String> getNodes() {
        return this.nodes;
    }

    public String getNode(int index) {
        return this.nodes.get(index);
    }

    public String getFirstNode() {
        return this.nodes.get(0);
    }

    public String getLastNode() {
        return this.nodes.get(nodes.size() - 1);
    }

    public String getMatchingNode(Predicate<String> predicate) {
        for (String item: nodes) { if(predicate.test(item)){ return item;} } return null;
    }

    public Boolean hasMatchingNode(Predicate<String> predicate) {
        for (String item: nodes) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withNodes(List<String> nodes) {
        if (this.nodes != null) { _visitables.get("nodes").removeAll(this.nodes);}
        if (nodes != null) {this.nodes = new ArrayList<String>(); for (String item : nodes){this.addToNodes(item);}} else { this.nodes = null;} return (A) this;
    }

    public A withNodes(String... nodes) {
        if (this.nodes != null) {this.nodes.clear();}
        if (nodes != null) {for (String item :nodes){ this.addToNodes(item);}} return (A) this;
    }

    public Boolean hasNodes() {
        return nodes != null && !nodes.isEmpty();
    }

    public A addNewNode(String arg1) {
        return (A)addToNodes(new String(arg1));
    }

    public A addNewNode(StringBuilder arg1) {
        return (A)addToNodes(new String(arg1));
    }

    public A addNewNode(StringBuffer arg1) {
        return (A)addToNodes(new String(arg1));
    }

    public A addToPodPhaseSelectors(int index,String item) {
        if (this.podPhaseSelectors == null) {this.podPhaseSelectors = new ArrayList<String>();}
        this.podPhaseSelectors.add(index, item);
        return (A)this;
    }

    public A setToPodPhaseSelectors(int index,String item) {
        if (this.podPhaseSelectors == null) {this.podPhaseSelectors = new ArrayList<String>();}
        this.podPhaseSelectors.set(index, item); return (A)this;
    }

    public A addToPodPhaseSelectors(String... items) {
        if (this.podPhaseSelectors == null) {this.podPhaseSelectors = new ArrayList<String>();}
        for (String item : items) {this.podPhaseSelectors.add(item);} return (A)this;
    }

    public A addAllToPodPhaseSelectors(Collection<String> items) {
        if (this.podPhaseSelectors == null) {this.podPhaseSelectors = new ArrayList<String>();}
        for (String item : items) {this.podPhaseSelectors.add(item);} return (A)this;
    }

    public A removeFromPodPhaseSelectors(String... items) {
        for (String item : items) {if (this.podPhaseSelectors!= null){ this.podPhaseSelectors.remove(item);}} return (A)this;
    }

    public A removeAllFromPodPhaseSelectors(Collection<String> items) {
        for (String item : items) {if (this.podPhaseSelectors!= null){ this.podPhaseSelectors.remove(item);}} return (A)this;
    }

    public List<String> getPodPhaseSelectors() {
        return this.podPhaseSelectors;
    }

    public String getPodPhaseSelector(int index) {
        return this.podPhaseSelectors.get(index);
    }

    public String getFirstPodPhaseSelector() {
        return this.podPhaseSelectors.get(0);
    }

    public String getLastPodPhaseSelector() {
        return this.podPhaseSelectors.get(podPhaseSelectors.size() - 1);
    }

    public String getMatchingPodPhaseSelector(Predicate<String> predicate) {
        for (String item: podPhaseSelectors) { if(predicate.test(item)){ return item;} } return null;
    }

    public Boolean hasMatchingPodPhaseSelector(Predicate<String> predicate) {
        for (String item: podPhaseSelectors) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withPodPhaseSelectors(List<String> podPhaseSelectors) {
        if (this.podPhaseSelectors != null) { _visitables.get("podPhaseSelectors").removeAll(this.podPhaseSelectors);}
        if (podPhaseSelectors != null) {this.podPhaseSelectors = new ArrayList<String>(); for (String item : podPhaseSelectors){this.addToPodPhaseSelectors(item);}} else { this.podPhaseSelectors = null;} return (A) this;
    }

    public A withPodPhaseSelectors(String... podPhaseSelectors) {
        if (this.podPhaseSelectors != null) {this.podPhaseSelectors.clear();}
        if (podPhaseSelectors != null) {for (String item :podPhaseSelectors){ this.addToPodPhaseSelectors(item);}} return (A) this;
    }

    public Boolean hasPodPhaseSelectors() {
        return podPhaseSelectors != null && !podPhaseSelectors.isEmpty();
    }

    public A addNewPodPhaseSelector(String arg1) {
        return (A)addToPodPhaseSelectors(new String(arg1));
    }

    public A addNewPodPhaseSelector(StringBuilder arg1) {
        return (A)addToPodPhaseSelectors(new String(arg1));
    }

    public A addNewPodPhaseSelector(StringBuffer arg1) {
        return (A)addToPodPhaseSelectors(new String(arg1));
    }

    public A addToPods(String key,List<String> value) {
        if(this.pods == null && key != null && value != null) { this.pods = new LinkedHashMap<String,List<String>>(); }
        if(key != null && value != null) {this.pods.put(key, value);} return (A)this;
    }

    public A addToPods(Map<String,List<String>> map) {
        if(this.pods == null && map != null) { this.pods = new LinkedHashMap<String,List<String>>(); }
        if(map != null) { this.pods.putAll(map);} return (A)this;
    }

    public A removeFromPods(String key) {
        if(this.pods == null) { return (A) this; }
        if(key != null && this.pods != null) {this.pods.remove(key);} return (A)this;
    }

    public A removeFromPods(Map<String,List<String>> map) {
        if(this.pods == null) { return (A) this; }
        if(map != null) { for(Object key : map.keySet()) {if (this.pods != null){this.pods.remove(key);}}} return (A)this;
    }

    public Map<String,List<String>> getPods() {
        return this.pods;
    }

    public A withPods(Map<String,List<String>> pods) {
        if (pods == null) { this.pods =  null;} else {this.pods = new LinkedHashMap<String,List<String>>(pods);} return (A) this;
    }

    public Boolean hasPods() {
        return this.pods != null;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        SelectorSpecFluentImpl that = (SelectorSpecFluentImpl) o;
        if (annotationSelectors != null ? !annotationSelectors.equals(that.annotationSelectors) :that.annotationSelectors != null) return false;
        if (expressionSelectors != null ? !expressionSelectors.equals(that.expressionSelectors) :that.expressionSelectors != null) return false;
        if (fieldSelectors != null ? !fieldSelectors.equals(that.fieldSelectors) :that.fieldSelectors != null) return false;
        if (labelSelectors != null ? !labelSelectors.equals(that.labelSelectors) :that.labelSelectors != null) return false;
        if (namespaces != null ? !namespaces.equals(that.namespaces) :that.namespaces != null) return false;
        if (nodeSelectors != null ? !nodeSelectors.equals(that.nodeSelectors) :that.nodeSelectors != null) return false;
        if (nodes != null ? !nodes.equals(that.nodes) :that.nodes != null) return false;
        if (podPhaseSelectors != null ? !podPhaseSelectors.equals(that.podPhaseSelectors) :that.podPhaseSelectors != null) return false;
        if (pods != null ? !pods.equals(that.pods) :that.pods != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(annotationSelectors,  expressionSelectors,  fieldSelectors,  labelSelectors,  namespaces,  nodeSelectors,  nodes,  podPhaseSelectors,  pods,  super.hashCode());
    }

}
