package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.builder.Fluent;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

public interface PodNetworkChaosSpecFluent<A extends PodNetworkChaosSpecFluent<A>> extends Fluent<A> {


    public A addToIpsets(int index,RawIPSet item);
    public A setToIpsets(int index,RawIPSet item);
    public A addToIpsets(RawIPSet... items);
    public A addAllToIpsets(Collection<RawIPSet> items);
    public A removeFromIpsets(RawIPSet... items);
    public A removeAllFromIpsets(Collection<RawIPSet> items);
    public A removeMatchingFromIpsets(Predicate<RawIPSetBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildIpsets instead.
 * @return The buildable object.
 */
@Deprecated public List<RawIPSet> getIpsets();
    public List<RawIPSet> buildIpsets();
    public RawIPSet buildIpset(int index);
    public RawIPSet buildFirstIpset();
    public RawIPSet buildLastIpset();
    public RawIPSet buildMatchingIpset(Predicate<RawIPSetBuilder> predicate);
    public Boolean hasMatchingIpset(Predicate<RawIPSetBuilder> predicate);
    public A withIpsets(List<RawIPSet> ipsets);
    public A withIpsets(RawIPSet... ipsets);
    public Boolean hasIpsets();
    public PodNetworkChaosSpecFluent.IpsetsNested<A> addNewIpset();
    public PodNetworkChaosSpecFluent.IpsetsNested<A> addNewIpsetLike(RawIPSet item);
    public PodNetworkChaosSpecFluent.IpsetsNested<A> setNewIpsetLike(int index,RawIPSet item);
    public PodNetworkChaosSpecFluent.IpsetsNested<A> editIpset(int index);
    public PodNetworkChaosSpecFluent.IpsetsNested<A> editFirstIpset();
    public PodNetworkChaosSpecFluent.IpsetsNested<A> editLastIpset();
    public PodNetworkChaosSpecFluent.IpsetsNested<A> editMatchingIpset(Predicate<RawIPSetBuilder> predicate);
    public A addToIptables(int index,RawIptables item);
    public A setToIptables(int index,RawIptables item);
    public A addToIptables(RawIptables... items);
    public A addAllToIptables(Collection<RawIptables> items);
    public A removeFromIptables(RawIptables... items);
    public A removeAllFromIptables(Collection<RawIptables> items);
    public A removeMatchingFromIptables(Predicate<RawIptablesBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildIptables instead.
 * @return The buildable object.
 */
@Deprecated public List<RawIptables> getIptables();
    public List<RawIptables> buildIptables();
    public RawIptables buildIptable(int index);
    public RawIptables buildFirstIptable();
    public RawIptables buildLastIptable();
    public RawIptables buildMatchingIptable(Predicate<RawIptablesBuilder> predicate);
    public Boolean hasMatchingIptable(Predicate<RawIptablesBuilder> predicate);
    public A withIptables(List<RawIptables> iptables);
    public A withIptables(RawIptables... iptables);
    public Boolean hasIptables();
    public PodNetworkChaosSpecFluent.IptablesNested<A> addNewIptable();
    public PodNetworkChaosSpecFluent.IptablesNested<A> addNewIptableLike(RawIptables item);
    public PodNetworkChaosSpecFluent.IptablesNested<A> setNewIptableLike(int index,RawIptables item);
    public PodNetworkChaosSpecFluent.IptablesNested<A> editIptable(int index);
    public PodNetworkChaosSpecFluent.IptablesNested<A> editFirstIptable();
    public PodNetworkChaosSpecFluent.IptablesNested<A> editLastIptable();
    public PodNetworkChaosSpecFluent.IptablesNested<A> editMatchingIptable(Predicate<RawIptablesBuilder> predicate);
    public A addToTcs(int index,RawTrafficControl item);
    public A setToTcs(int index,RawTrafficControl item);
    public A addToTcs(RawTrafficControl... items);
    public A addAllToTcs(Collection<RawTrafficControl> items);
    public A removeFromTcs(RawTrafficControl... items);
    public A removeAllFromTcs(Collection<RawTrafficControl> items);
    public A removeMatchingFromTcs(Predicate<RawTrafficControlBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildTcs instead.
 * @return The buildable object.
 */
@Deprecated public List<RawTrafficControl> getTcs();
    public List<RawTrafficControl> buildTcs();
    public RawTrafficControl buildTc(int index);
    public RawTrafficControl buildFirstTc();
    public RawTrafficControl buildLastTc();
    public RawTrafficControl buildMatchingTc(Predicate<RawTrafficControlBuilder> predicate);
    public Boolean hasMatchingTc(Predicate<RawTrafficControlBuilder> predicate);
    public A withTcs(List<RawTrafficControl> tcs);
    public A withTcs(RawTrafficControl... tcs);
    public Boolean hasTcs();
    public PodNetworkChaosSpecFluent.TcsNested<A> addNewTc();
    public PodNetworkChaosSpecFluent.TcsNested<A> addNewTcLike(RawTrafficControl item);
    public PodNetworkChaosSpecFluent.TcsNested<A> setNewTcLike(int index,RawTrafficControl item);
    public PodNetworkChaosSpecFluent.TcsNested<A> editTc(int index);
    public PodNetworkChaosSpecFluent.TcsNested<A> editFirstTc();
    public PodNetworkChaosSpecFluent.TcsNested<A> editLastTc();
    public PodNetworkChaosSpecFluent.TcsNested<A> editMatchingTc(Predicate<RawTrafficControlBuilder> predicate);
    public interface IpsetsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,RawIPSetFluent<PodNetworkChaosSpecFluent.IpsetsNested<N>> {

            public N and();
            public N endIpset();    }


    public interface IptablesNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,RawIptablesFluent<PodNetworkChaosSpecFluent.IptablesNested<N>> {

            public N and();
            public N endIptable();    }


    public interface TcsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,RawTrafficControlFluent<PodNetworkChaosSpecFluent.TcsNested<N>> {

            public N and();
            public N endTc();    }


}
